/*
 * Decompiled with CFR 0.152.
 */
package withoutaname.mods.withoutawallpaper.tools;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.world.item.DyeColor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Colors {
    public static final Logger LOGGER = LogManager.getLogger();
    private List<DyeColor> colors = new ArrayList<DyeColor>();

    public Colors() {
    }

    public Colors(@Nonnull String colors) {
        for (String color : colors.split(",")) {
            if (color.equals("all")) {
                this.addAll();
                break;
            }
            DyeColor dyeColor = DyeColor.m_41057_((String)color, null);
            if (dyeColor != null) {
                this.colors.add(dyeColor);
                continue;
            }
            LOGGER.error("Color \"" + color + "\" does not exist.");
        }
    }

    public List<DyeColor> getColors() {
        return this.colors;
    }

    public void setColors(List<DyeColor> colors) {
        this.colors = colors;
    }

    public Colors add(DyeColor dyeColor) {
        this.colors.add(dyeColor);
        return this;
    }

    public Colors addAll() {
        for (int i = 0; i < 16; ++i) {
            this.addByID(i);
        }
        return this;
    }

    public Colors addAll(@Nonnull List<DyeColor> dyeColors) {
        for (DyeColor color : dyeColors) {
            this.add(color);
        }
        return this;
    }

    public Colors addByID(int id) {
        return this.add(DyeColor.m_41053_((int)id));
    }

    public Colors addAllByID(@Nonnull List<Integer> ids) {
        for (int id : ids) {
            this.addByID(id);
        }
        return this;
    }

    public Colors addWhite() {
        return this.addByID(0);
    }

    public Colors addOrange() {
        return this.addByID(1);
    }

    public Colors addMagenta() {
        return this.addByID(2);
    }

    public Colors addLightBlue() {
        return this.addByID(3);
    }

    public Colors addYellow() {
        return this.addByID(4);
    }

    public Colors addLime() {
        return this.addByID(5);
    }

    public Colors addPink() {
        return this.addByID(6);
    }

    public Colors addGray() {
        return this.addByID(7);
    }

    public Colors addLightGray() {
        return this.addByID(8);
    }

    public Colors addCyan() {
        return this.addByID(9);
    }

    public Colors addPurple() {
        return this.addByID(10);
    }

    public Colors addBlue() {
        return this.addByID(11);
    }

    public Colors addBrown() {
        return this.addByID(12);
    }

    public Colors addGreen() {
        return this.addByID(13);
    }

    public Colors addRed() {
        return this.addByID(14);
    }

    public Colors addBlack() {
        return this.addByID(15);
    }
}

