/*
 * Decompiled with CFR 0.152.
 */
package withoutaname.mods.withoutawallpaper.tools;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import withoutaname.mods.withoutawallpaper.setup.Config;
import withoutaname.mods.withoutawallpaper.tools.Colors;

public class WallpaperDesign {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final WallpaperDesign NONE = new WallpaperDesign("none", new Colors[0]);
    private static List<WallpaperDesign> designs = new ArrayList<WallpaperDesign>();
    private final String name;
    private final Colors[] availableColors;

    public WallpaperDesign(String name, Colors ... availableColors) {
        this.name = name;
        this.availableColors = availableColors;
    }

    public static void loadDesigns() {
        designs = new ArrayList<WallpaperDesign>();
        List designsString = (List)Config.CUSTOM_DESIGNS.get();
        for (String designString : designsString) {
            if (designString.contains("[") && designString.contains("]")) {
                String[] designStringSplit = designString.substring(0, designString.length() - 1).split("\\[");
                String[] availableColorsString = designStringSplit[1].split(";");
                if (availableColorsString.length <= 3) {
                    Colors[] availableColors = new Colors[availableColorsString.length];
                    for (int i = 0; i < availableColorsString.length; ++i) {
                        availableColors[i] = new Colors(availableColorsString[i]);
                    }
                    designs.add(new WallpaperDesign(designStringSplit[0], availableColors));
                    LOGGER.debug("Successfully loaded design \"" + designStringSplit[0] + "\".");
                    continue;
                }
                LOGGER.error("Error loading design \"" + designStringSplit[0] + "\". Only three colors are allowed!");
                continue;
            }
            LOGGER.error("Error loading design \"" + designString + "\". No colors defined");
        }
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public static List<ResourceLocation> getAllTextures() {
        ArrayList<ResourceLocation> textures = new ArrayList<ResourceLocation>();
        for (WallpaperDesign wallpaperDesign : WallpaperDesign.getValuesExceptNone()) {
            textures.addAll(wallpaperDesign.getTextures());
        }
        return textures;
    }

    public static List<WallpaperDesign> getValuesExceptNone() {
        return designs;
    }

    @Nullable
    public static WallpaperDesign fromInt(int i) {
        if (i == -1) {
            return NONE;
        }
        if (i >= 0 && i < designs.size()) {
            return designs.get(i);
        }
        return null;
    }

    public static WallpaperDesign fromString(@Nonnull String design) {
        if (design.equals("none")) {
            return NONE;
        }
        for (WallpaperDesign d : designs) {
            if (!d.getName().equals(design)) continue;
            return d;
        }
        throw new IllegalArgumentException("No design " + design);
    }

    public int toInt() {
        for (int i = 0; i < designs.size(); ++i) {
            if (!this.name.equals(designs.get(i).getName())) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public Colors[] getAvailableColors() {
        return this.availableColors;
    }

    public int getColorCount() {
        return this.availableColors.length;
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<ResourceLocation> getTextures() {
        ArrayList<ResourceLocation> textures = new ArrayList<ResourceLocation>();
        for (int i = 0; i < this.availableColors.length; ++i) {
            Colors colors = this.availableColors[i];
            for (DyeColor color : colors.getColors()) {
                textures.add(new ResourceLocation("withoutawallpaper", "block/wallpaper/" + this.name + "/color" + i + "/" + color.toString()));
            }
        }
        return textures;
    }
}

