/*
 * Decompiled with CFR 0.152.
 */
package withoutaname.mods.withoutawallpaper.tools;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import withoutaname.mods.withoutawallpaper.tools.Colors;
import withoutaname.mods.withoutawallpaper.tools.WallpaperDesign;

public class WallpaperType {
    public static final WallpaperType NONE = new WallpaperType(WallpaperDesign.NONE, new DyeColor[0]);
    private WallpaperDesign design;
    private DyeColor[] colors;

    public WallpaperType(@Nonnull WallpaperDesign design, DyeColor ... colors) {
        if (colors.length != design.getColorCount()) {
            throw new IllegalStateException(colors.length + " colors defined, " + design.getColorCount() + " colors expected for design " + design.toString() + "!");
        }
        this.design = design;
        this.colors = colors;
    }

    public WallpaperType(WallpaperDesign design, List<DyeColor> colors) {
        this(design, WallpaperType.getColorsFromList(colors));
    }

    public static WallpaperType fromNBT(@Nonnull CompoundTag wallpaperTypeNBT) {
        ArrayList<DyeColor> colors = new ArrayList<DyeColor>();
        for (int colorID : wallpaperTypeNBT.m_128465_("colors")) {
            colors.add(DyeColor.m_41053_((int)colorID));
        }
        try {
            return new WallpaperType(WallpaperDesign.fromString(wallpaperTypeNBT.m_128461_("design")), colors);
        }
        catch (IllegalArgumentException e) {
            Colors[] availableColors = new Colors[colors.size()];
            for (int i = 0; i < colors.size(); ++i) {
                availableColors[i] = new Colors().add((DyeColor)colors.get(i));
            }
            return new WallpaperType(new WallpaperDesign(wallpaperTypeNBT.m_128461_("design"), availableColors), colors);
        }
    }

    @Nonnull
    private static DyeColor[] getColorsFromList(@Nonnull List<DyeColor> colors) {
        DyeColor[] array = new DyeColor[colors.size()];
        for (int i = 0; i < colors.size(); ++i) {
            array[i] = colors.get(i);
        }
        return array;
    }

    public CompoundTag toNBT() {
        CompoundTag wallpaperTypeNBT = new CompoundTag();
        wallpaperTypeNBT.m_128359_("design", this.design.toString());
        int[] colorIDs = new int[this.colors.length];
        for (int i = 0; i < this.colors.length; ++i) {
            colorIDs[i] = this.colors[i].m_41060_();
        }
        wallpaperTypeNBT.m_128385_("colors", colorIDs);
        return wallpaperTypeNBT;
    }

    public DyeColor[] getColors() {
        return this.colors;
    }

    public void setColors(@Nonnull DyeColor[] colors) {
        if (colors.length != this.design.getColorCount()) {
            throw new IllegalStateException(colors.length + " colors defined, " + this.design.getColorCount() + " colors expected for design " + this.design.toString() + "!");
        }
        this.colors = colors;
    }

    public List<ResourceLocation> getResourceLocations() {
        ArrayList<ResourceLocation> resourceLocations = new ArrayList<ResourceLocation>();
        for (int i = 0; i < this.colors.length; ++i) {
            resourceLocations.add(new ResourceLocation("withoutawallpaper", "block/wallpaper/" + this.design.toString() + "/color" + i + "/" + this.colors[i].toString()));
        }
        return resourceLocations;
    }

    public List<TextureAtlasSprite> getAtlasSprites() {
        ArrayList<TextureAtlasSprite> atlasSprites = new ArrayList<TextureAtlasSprite>();
        for (ResourceLocation resourceLocation : this.getResourceLocations()) {
            atlasSprites.add((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(resourceLocation));
        }
        return atlasSprites;
    }

    public WallpaperDesign getDesign() {
        return this.design;
    }

    public void setDesign(WallpaperDesign design) {
        this.design = design;
    }
}

