/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.xplosives.common.block;

import com.swdteam.xplosives.common.block.IExplosive;
import com.swdteam.xplosives.common.entity.EntityPrimedBlock;
import com.swdteam.xplosives.registry.XEntities;
import com.swdteam.xplosives.registry.XItems;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockDetonator
extends FaceAttachedHorizontalDirectionalBlock {
    protected static final VoxelShape AABB_CEILING_X_OFF = Block.m_49796_((double)6.0, (double)14.0, (double)5.0, (double)10.0, (double)16.0, (double)11.0);
    protected static final VoxelShape AABB_CEILING_Z_OFF = Block.m_49796_((double)5.0, (double)14.0, (double)6.0, (double)11.0, (double)16.0, (double)10.0);
    protected static final VoxelShape AABB_FLOOR_X_OFF = Block.m_49796_((double)6.0, (double)0.0, (double)5.0, (double)10.0, (double)2.0, (double)11.0);
    protected static final VoxelShape AABB_FLOOR_Z_OFF = Block.m_49796_((double)5.0, (double)0.0, (double)6.0, (double)11.0, (double)2.0, (double)10.0);
    protected static final VoxelShape AABB_NORTH_OFF = Block.m_49796_((double)5.0, (double)6.0, (double)14.0, (double)11.0, (double)10.0, (double)16.0);
    protected static final VoxelShape AABB_SOUTH_OFF = Block.m_49796_((double)5.0, (double)6.0, (double)0.0, (double)11.0, (double)10.0, (double)2.0);
    protected static final VoxelShape AABB_WEST_OFF = Block.m_49796_((double)14.0, (double)6.0, (double)5.0, (double)16.0, (double)10.0, (double)11.0);
    protected static final VoxelShape AABB_EAST_OFF = Block.m_49796_((double)0.0, (double)6.0, (double)5.0, (double)2.0, (double)10.0, (double)11.0);

    public BlockDetonator(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)f_53179_, (Comparable)AttachFace.WALL));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter p_51105_, BlockPos p_51106_, CollisionContext p_51107_) {
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        switch ((AttachFace)state.m_61143_((Property)f_53179_)) {
            case FLOOR: {
                if (direction.m_122434_() == Direction.Axis.X) {
                    return AABB_FLOOR_X_OFF;
                }
                return AABB_FLOOR_Z_OFF;
            }
            case WALL: {
                switch (direction) {
                    case EAST: {
                        return AABB_EAST_OFF;
                    }
                    case WEST: {
                        return AABB_WEST_OFF;
                    }
                    case SOUTH: {
                        return AABB_SOUTH_OFF;
                    }
                }
                return AABB_NORTH_OFF;
            }
        }
        if (direction.m_122434_() == Direction.Axis.X) {
            return AABB_CEILING_X_OFF;
        }
        return AABB_CEILING_Z_OFF;
    }

    public InteractionResult m_6227_(BlockState p_60503_, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult p_60508_) {
        ItemStack stack;
        if (!worldIn.f_46443_ && handIn == InteractionHand.MAIN_HAND && (stack = player.m_21120_(handIn)) != null && stack.m_41720_() == XItems.DETONATOR_REMOTE.get()) {
            if (!stack.m_41782_()) {
                stack.m_41751_(new CompoundTag());
            }
            if (!stack.m_41783_().m_128441_("positions")) {
                stack.m_41783_().m_128365_("positions", (Tag)new CompoundTag());
                stack.m_41783_().m_128359_("dimension", worldIn.m_46472_().m_135782_().toString());
            }
            String display = pos.m_123341_() + ", " + pos.m_123342_() + ", " + pos.m_123343_();
            String loc = "bp-" + pos.m_123341_() + "-" + pos.m_123342_() + "-" + pos.m_123343_();
            if (((CompoundTag)stack.m_41783_().m_128423_("positions")).m_128441_(loc)) {
                ((CompoundTag)stack.m_41783_().m_128423_("positions")).m_128473_(loc);
                ((ServerPlayer)player).m_9146_((Component)new TextComponent(ChatFormatting.GREEN + "Removed " + display), ChatType.GAME_INFO, Util.f_137441_);
                worldIn.m_5594_(null, pos, SoundEvents.f_12444_, SoundSource.BLOCKS, 1.0f, 0.75f);
            } else {
                CompoundTag tag = NbtUtils.m_129224_((BlockPos)pos);
                ((CompoundTag)stack.m_41783_().m_128423_("positions")).m_128365_(loc, (Tag)tag);
                ((ServerPlayer)player).m_9146_((Component)new TextComponent(ChatFormatting.GREEN + "Added " + display), ChatType.GAME_INFO, Util.f_137441_);
                worldIn.m_5594_(null, pos, SoundEvents.f_12444_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
        return super.m_6227_(p_60503_, worldIn, pos, player, handIn, p_60508_);
    }

    public void activate(Level worldIn, BlockPos pos, BlockState state, Player player) {
        Direction d = BlockDetonator.m_53200_((BlockState)state).m_122424_();
        BlockState blockState = worldIn.m_8055_(pos.m_142300_(d));
        if (blockState.m_60734_() instanceof IExplosive) {
            System.out.println("ljksflsjkdfjsd");
            EntityPrimedBlock block = new EntityPrimedBlock((EntityType<? extends EntityPrimedBlock>)((EntityType)XEntities.ENTITY_PRIMED_BLOCK.get()), worldIn);
            BlockPos p = pos.m_142300_(d);
            block.m_6034_((double)p.m_123341_() + 0.5, p.m_123342_(), (double)p.m_123343_() + 0.5);
            block.m_20334_(0.0, 0.15f, 0.0);
            block.setBlockState(worldIn.m_8055_(pos.m_142300_(d)));
            block.setFuse(20);
            worldIn.m_7967_((Entity)block);
            worldIn.m_46597_(pos.m_142300_(d), Blocks.f_50016_.m_49966_());
        } else if (blockState.m_60734_() == Blocks.f_50077_) {
            ((TntBlock)blockState.m_60734_()).catchFire(blockState, worldIn, pos.m_142300_(d), d, (LivingEntity)player);
            worldIn.m_46597_(pos.m_142300_(d), Blocks.f_50016_.m_49966_());
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_51101_) {
        p_51101_.m_61104_(new Property[]{f_54117_, f_53179_});
    }
}

