/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.xplosives.common.entity;

import com.swdteam.xplosives.common.block.IExplosive;
import com.swdteam.xplosives.registry.XEntities;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fmllegacy.network.NetworkHooks;

public class EntityPrimedBlock
extends Entity {
    private static final EntityDataAccessor<Optional<BlockState>> BLOCKSTATE = SynchedEntityData.m_135353_(EntityPrimedBlock.class, (EntityDataSerializer)EntityDataSerializers.f_135034_);
    private static final EntityDataAccessor<Integer> DATA_FUSE_ID = SynchedEntityData.m_135353_(EntityPrimedBlock.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    @Nullable
    private LivingEntity tntPlacedBy;
    private int fuse = 80;

    public EntityPrimedBlock(EntityType<? extends EntityPrimedBlock> type, Level worldIn) {
        super(type, worldIn);
        this.f_19850_ = true;
    }

    public EntityPrimedBlock(Level worldIn, double x, double y, double z, @Nullable LivingEntity igniter, BlockState state) {
        super((EntityType)XEntities.ENTITY_PRIMED_BLOCK.get(), worldIn);
        double d0 = worldIn.f_46441_.nextDouble() * 6.2831854820251465;
        this.f_19850_ = true;
        this.m_20334_(-Math.sin(d0) * 0.02, 0.2f, -Math.cos(d0) * 0.02);
        this.setFuse(80);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
        this.m_6034_(x, y, z);
        this.tntPlacedBy = igniter;
        this.setBlockState(state);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_FUSE_ID, (Object)80);
        this.f_19804_.m_135372_(BLOCKSTATE, Optional.empty());
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    public boolean m_6087_() {
        return !this.m_146910_();
    }

    public void m_8119_() {
        if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.m_20256_(this.m_20184_().m_82490_(0.98));
        if (this.f_19861_) {
            this.m_20256_(this.m_20184_().m_82542_(0.7, -0.5, 0.7));
        }
        int i = this.getFuse() - 1;
        this.setFuse(i);
        if (i <= 0) {
            this.m_146870_();
            if (!this.f_19853_.f_46443_) {
                this.explode();
            }
        } else {
            this.m_20073_();
            if (this.f_19853_.f_46443_) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 0.0, 0.0, 0.0);
            }
        }
    }

    protected void explode() {
        if (this.getBlockState() != null && this.getBlockState().m_60734_() instanceof IExplosive) {
            IExplosive e = (IExplosive)this.getBlockState().m_60734_();
            e.onExplode(this.f_19853_, this, this.m_142538_());
        } else if (this.getBlockState() != null && this.getBlockState().m_60734_() == Blocks.f_50077_) {
            this.f_19853_.m_46511_((Entity)this.tntPlacedBy, this.m_20185_(), this.m_20227_(0.0625), this.m_20189_(), 4.0f, Explosion.BlockInteraction.BREAK);
        }
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128376_("Fuse", (short)this.getFuse());
        BlockState blockstate = this.getBlockState();
        if (blockstate != null) {
            compound.m_128365_("blockState", (Tag)NbtUtils.m_129202_((BlockState)blockstate));
        }
    }

    protected void m_7378_(CompoundTag compound) {
        this.setFuse(compound.m_128448_("Fuse"));
        BlockState blockstate = null;
        if (compound.m_128425_("blockState", 10) && (blockstate = NbtUtils.m_129241_((CompoundTag)compound.m_128469_("blockState"))).m_60795_()) {
            blockstate = null;
        }
        this.setBlockState(blockstate);
    }

    @Nullable
    public LivingEntity getTntPlacedBy() {
        return this.tntPlacedBy;
    }

    protected float m_6380_(Pose p_32088_, EntityDimensions p_32089_) {
        return 0.15f;
    }

    public void setFuse(int fuseIn) {
        this.f_19804_.m_135381_(DATA_FUSE_ID, (Object)fuseIn);
        this.fuse = fuseIn;
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (DATA_FUSE_ID.equals(key)) {
            this.fuse = this.getFuseDataManager();
        }
    }

    public int getFuseDataManager() {
        return (Integer)this.f_19804_.m_135370_(DATA_FUSE_ID);
    }

    public int getFuse() {
        return this.fuse;
    }

    public void setBlockState(@Nullable BlockState state) {
        this.f_19804_.m_135381_(BLOCKSTATE, Optional.ofNullable(state));
    }

    @Nullable
    public BlockState getBlockState() {
        return ((Optional)this.f_19804_.m_135370_(BLOCKSTATE)).orElse(Blocks.f_50077_.m_49966_());
    }

    public void throwBlock(Entity p_37252_, float p_37253_, float p_37254_, float p_37255_, float p_37256_, float p_37257_) {
        float f = -Mth.m_14031_((float)(p_37254_ * ((float)Math.PI / 180))) * Mth.m_14089_((float)(p_37253_ * ((float)Math.PI / 180)));
        float f1 = -Mth.m_14031_((float)((p_37253_ + p_37255_) * ((float)Math.PI / 180)));
        float f2 = Mth.m_14089_((float)(p_37254_ * ((float)Math.PI / 180))) * Mth.m_14089_((float)(p_37253_ * ((float)Math.PI / 180)));
        this.shoot(f, f1, f2, p_37256_, p_37257_);
        Vec3 vec3 = p_37252_.m_20184_();
        this.m_20256_(this.m_20184_().m_82520_(vec3.f_82479_, p_37252_.m_20096_() ? 0.0 : vec3.f_82480_, vec3.f_82481_));
    }

    public void shoot(double x, double y, double z, float velocity, float inaccuracy) {
        Vec3 vector3d = new Vec3(x, y, z).m_82541_().m_82520_(this.f_19853_.f_46441_.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.f_19853_.f_46441_.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.f_19853_.f_46441_.nextGaussian() * (double)0.0075f * (double)inaccuracy).m_82490_((double)velocity);
        this.m_20256_(vector3d);
        float f = Mth.m_14116_((float)((float)EntityPrimedBlock.horizontalMag(vector3d)));
        this.m_146926_((float)(Mth.m_14136_((double)vector3d.f_82479_, (double)vector3d.f_82481_) * 57.2957763671875));
        this.m_146922_((float)(Mth.m_14136_((double)vector3d.f_82480_, (double)f) * 57.2957763671875));
        this.f_19860_ = this.m_146909_();
        this.f_19859_ = this.m_146908_();
    }

    public static double horizontalMag(Vec3 vec) {
        return vec.f_82479_ * vec.f_82479_ + vec.f_82481_ * vec.f_82481_;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void setTntPlacedBy(LivingEntity tntPlacedBy) {
        this.tntPlacedBy = tntPlacedBy;
    }
}

