/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.xplosive.client.graphics;

import com.swdteam.xplosive.client.registry.ResourceManager;
import com.swdteam.xplosive.main.Utils;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class Graphics {
    static int zLevel = 0;
    public static final float RENDER_NUM = 0.0625f;
    public static TextureManager render = Minecraft.func_71410_x().field_71446_o;

    public static int loadTexture(BufferedImage image) {
        int[] pixels = new int[image.getWidth() * image.getHeight()];
        image.getRGB(0, 0, image.getWidth(), image.getHeight(), pixels, 0, image.getWidth());
        ByteBuffer buffer = BufferUtils.createByteBuffer((int)(image.getWidth() * image.getHeight() * 4));
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int pixel = pixels[y * image.getWidth() + x];
                buffer.put((byte)(pixel >> 16 & 0xFF));
                buffer.put((byte)(pixel >> 8 & 0xFF));
                buffer.put((byte)(pixel & 0xFF));
                buffer.put((byte)(pixel >> 24 & 0xFF));
            }
        }
        buffer.flip();
        int textureID = GL11.glGenTextures();
        GL11.glBindTexture((int)3553, (int)textureID);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)image.getWidth(), (int)image.getHeight(), (int)0, (int)6408, (int)5121, (ByteBuffer)buffer);
        return textureID;
    }

    public static void draw(ResourceLocation r, float h, float y, float f, float g, int depth) {
        GL11.glPushMatrix();
        render.func_110577_a(r);
        Graphics.drawTexture(h, y, f, g, depth);
        GL11.glPopMatrix();
    }

    public static void drawNoBind(float x, float y, float width, float height, int depth) {
        GL11.glPushMatrix();
        Graphics.drawTexture(x, y, width, height, depth);
        GL11.glPopMatrix();
    }

    private static void drawTexture(float x, float y, float width, float height, double zLevel) {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexBuffer.func_181662_b((double)(x + 0.0f), (double)(y + height), zLevel).func_187315_a(0.0, 1.0).func_181675_d();
        vertexBuffer.func_181662_b((double)(x + width), (double)(y + height), zLevel).func_187315_a(1.0, 1.0).func_181675_d();
        vertexBuffer.func_181662_b((double)(x + width), (double)(y + 0.0f), zLevel).func_187315_a(1.0, 0.0).func_181675_d();
        vertexBuffer.func_181662_b((double)(x + 0.0f), (double)(y + 0.0f), zLevel).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
    }

    private static void drawTextureOffset(float x, float y, float width, float height, double zLevel) {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        vertexBuffer.func_181662_b((double)x, (double)y, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        vertexBuffer.func_181662_b((double)x, (double)y, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        vertexBuffer.func_181662_b((double)x, (double)y, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        vertexBuffer.func_181662_b((double)x, (double)y, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
    }

    public static void FillRect(double x, double y, double width, double height, double zLevel, Color col) {
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glColor4f((float)((float)col.getRed() / 255.0f), (float)((float)col.getGreen() / 255.0f), (float)((float)col.getBlue() / 255.0f), (float)((float)col.getAlpha() / 255.0f));
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexBuffer.func_181662_b(x + 0.0, y + height, zLevel).func_187315_a(0.0, 1.0).func_181675_d();
        vertexBuffer.func_181662_b(x + width, y + height, zLevel).func_187315_a(1.0, 1.0).func_181675_d();
        vertexBuffer.func_181662_b(x + width, y + 0.0, zLevel).func_187315_a(1.0, 0.0).func_181675_d();
        vertexBuffer.func_181662_b(x + 0.0, y + 0.0, zLevel).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    public static void FillRect(double x, double y, double width, double height, double zLevel, int col) {
        float r = col >> 16 & 0xFF;
        float g = col >> 8 & 0xFF;
        float b = col & 0xFF;
        float a = col >> 24 & 0xFF;
        GL11.glPushMatrix();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        vertexBuffer.func_181662_b(x, y + height, 0.0).func_181666_a(r / 255.0f, g / 255.0f, b / 255.0f, a / 255.0f).func_181675_d();
        vertexBuffer.func_181662_b(x + width, y + height, 0.0).func_181666_a(r / 255.0f, g / 255.0f, b / 255.0f, a / 255.0f).func_181675_d();
        vertexBuffer.func_181662_b(x + width, y, 0.0).func_181666_a(r / 255.0f, g / 255.0f, b / 255.0f, a / 255.0f).func_181675_d();
        vertexBuffer.func_181662_b(x, y, 0.0).func_181666_a(r / 255.0f, g / 255.0f, b / 255.0f, a / 255.0f).func_181675_d();
        tessellator.func_78381_a();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    public static void bindTexture(int i) {
        GL11.glBindTexture((int)3553, (int)i);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
    }

    public static void bindTexture(ResourceLocation r) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(r);
    }

    public static void drawQuad(BufferBuilder buf, double x, double y, double width, double height) {
        buf.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        buf.func_181662_b(x, y + height, 0.0).func_181675_d();
        buf.func_181662_b(x + width, y + height, 0.0).func_181675_d();
        buf.func_181662_b(x + width, y, 0.0).func_181675_d();
        buf.func_181662_b(x, y, 0.0).func_181675_d();
        buf.func_178977_d();
    }

    public static void drawTexturedModalRect(int x, int y, int textureX, int textureY, int width, int height) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexBuffer.func_181662_b((double)(x + 0), (double)(y + height), (double)zLevel).func_187315_a((double)((float)(textureX + 0) * f), (double)((float)(textureY + height) * f1)).func_181675_d();
        vertexBuffer.func_181662_b((double)(x + width), (double)(y + height), (double)zLevel).func_187315_a((double)((float)(textureX + width) * f), (double)((float)(textureY + height) * f1)).func_181675_d();
        vertexBuffer.func_181662_b((double)(x + width), (double)(y + 0), (double)zLevel).func_187315_a((double)((float)(textureX + width) * f), (double)((float)(textureY + 0) * f1)).func_181675_d();
        vertexBuffer.func_181662_b((double)(x + 0), (double)(y + 0), (double)zLevel).func_187315_a((double)((float)(textureX + 0) * f), (double)((float)(textureY + 0) * f1)).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawTexturedModalRect(float xCoord, float yCoord, int minU, int minV, int maxU, int maxV) {
        float f2 = 0.00390625f;
        float f3 = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexBuffer.func_181662_b((double)(xCoord + 0.0f), (double)(yCoord + (float)maxV), (double)zLevel).func_187315_a((double)((float)(minU + 0) * f2), (double)((float)(minV + maxV) * f3)).func_181675_d();
        vertexBuffer.func_181662_b((double)(xCoord + (float)maxU), (double)(yCoord + (float)maxV), (double)zLevel).func_187315_a((double)((float)(minU + maxU) * f2), (double)((float)(minV + maxV) * f3)).func_181675_d();
        vertexBuffer.func_181662_b((double)(xCoord + (float)maxU), (double)(yCoord + 0.0f), (double)zLevel).func_187315_a((double)((float)(minU + maxU) * f2), (double)((float)(minV + 0) * f3)).func_181675_d();
        vertexBuffer.func_181662_b((double)(xCoord + 0.0f), (double)(yCoord + 0.0f), (double)zLevel).func_187315_a((double)((float)(minU + 0) * f2), (double)((float)(minV + 0) * f3)).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawTexturedModalRect(int xCoord, int yCoord, TextureAtlasSprite textureSprite, int widthIn, int heightIn) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexBuffer.func_181662_b((double)(xCoord + 0), (double)(yCoord + heightIn), (double)zLevel).func_187315_a((double)textureSprite.func_94209_e(), (double)textureSprite.func_94210_h()).func_181675_d();
        vertexBuffer.func_181662_b((double)(xCoord + widthIn), (double)(yCoord + heightIn), (double)zLevel).func_187315_a((double)textureSprite.func_94212_f(), (double)textureSprite.func_94210_h()).func_181675_d();
        vertexBuffer.func_181662_b((double)(xCoord + widthIn), (double)(yCoord + 0), (double)zLevel).func_187315_a((double)textureSprite.func_94212_f(), (double)textureSprite.func_94206_g()).func_181675_d();
        vertexBuffer.func_181662_b((double)(xCoord + 0), (double)(yCoord + 0), (double)zLevel).func_187315_a((double)textureSprite.func_94209_e(), (double)textureSprite.func_94206_g()).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawWithBlendingMode(ResourceLocation r, float x, float y, float width, float height, int depth, int BLEND_1, int BLEND_2) {
        GL11.glPushMatrix();
        render.func_110577_a(r);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)BLEND_1, (int)BLEND_2);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b((double)(x + 0.0f), (double)(y + height), (double)zLevel).func_187315_a(0.0, 1.0).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + width), (double)(y + height), (double)zLevel).func_187315_a(1.0, 1.0).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + width), (double)(y + 0.0f), (double)zLevel).func_187315_a(1.0, 0.0).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + 0.0f), (double)(y + 0.0f), (double)zLevel).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    public static float renderNum() {
        return 0.0625f;
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderTileEntityBounds(TileEntity tileentity1) {
        GlStateManager.func_179094_E();
        GlStateManager.func_187409_d((int)1032, (int)6913);
        GlStateManager.func_179109_b((float)(-tileentity1.func_174877_v().func_177958_n()), (float)(-tileentity1.func_174877_v().func_177956_o()), (float)(-tileentity1.func_174877_v().func_177952_p()));
        GlStateManager.func_179109_b((float)-0.5f, (float)-1.5f, (float)-0.5f);
        Render.func_76978_a((AxisAlignedBB)tileentity1.getRenderBoundingBox(), (double)0.0, (double)0.0, (double)0.0);
        GlStateManager.func_187409_d((int)1032, (int)6914);
        GlStateManager.func_179121_F();
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderBlockBoundsWithinAABB(AxisAlignedBB b) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)-0.5f, (float)-1.5f, (float)-0.5f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)0.2f, (float)0.2f, (float)0.75f, (float)0.4f);
        GlStateManager.func_179090_x();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        GL11.glScalef((float)1.01f, (float)1.01f, (float)1.01f);
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        vertexBuffer.func_178969_c(0.0, 0.0, 0.0);
        vertexBuffer.func_181663_c(0.0f, 0.0f, -1.0f);
        vertexBuffer.func_181662_b(b.field_72340_a, b.field_72338_b, b.field_72339_c).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72336_d, b.field_72337_e, b.field_72339_c).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72336_d, b.field_72338_b, b.field_72339_c).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72340_a, b.field_72338_b, b.field_72339_c).func_181675_d();
        vertexBuffer.func_181663_c(0.0f, 0.0f, 1.0f);
        vertexBuffer.func_181662_b(b.field_72340_a, b.field_72338_b, b.field_72334_f).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72336_d, b.field_72338_b, b.field_72334_f).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72336_d, b.field_72337_e, b.field_72334_f).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72340_a, b.field_72337_e, b.field_72334_f).func_181675_d();
        vertexBuffer.func_181663_c(0.0f, -1.0f, 0.0f);
        vertexBuffer.func_181662_b(b.field_72340_a, b.field_72338_b, b.field_72339_c).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72336_d, b.field_72338_b, b.field_72339_c).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72336_d, b.field_72338_b, b.field_72334_f).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72340_a, b.field_72338_b, b.field_72334_f).func_181675_d();
        vertexBuffer.func_181663_c(0.0f, 1.0f, 0.0f);
        vertexBuffer.func_181662_b(b.field_72340_a, b.field_72337_e, b.field_72334_f).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72336_d, b.field_72337_e, b.field_72334_f).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72336_d, b.field_72337_e, b.field_72339_c).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72340_a, b.field_72337_e, b.field_72339_c).func_181675_d();
        vertexBuffer.func_181663_c(-1.0f, 0.0f, 0.0f);
        vertexBuffer.func_181662_b(b.field_72340_a, b.field_72338_b, b.field_72334_f).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72340_a, b.field_72337_e, b.field_72334_f).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72340_a, b.field_72337_e, b.field_72339_c).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72340_a, b.field_72338_b, b.field_72339_c).func_181675_d();
        vertexBuffer.func_181663_c(1.0f, 0.0f, 0.0f);
        vertexBuffer.func_181662_b(b.field_72336_d, b.field_72338_b, b.field_72339_c).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72336_d, b.field_72337_e, b.field_72339_c).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72336_d, b.field_72337_e, b.field_72334_f).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72336_d, b.field_72338_b, b.field_72334_f).func_181675_d();
        vertexBuffer.func_178969_c(0.0, 0.0, 0.0);
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)-0.5f, (float)-1.5f, (float)-0.5f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)0.2f, (float)0.2f, (float)1.0f, (float)0.5f);
        GL11.glPolygonMode((int)1032, (int)6913);
        GlStateManager.func_179090_x();
        GL11.glScalef((float)1.01f, (float)1.01f, (float)1.01f);
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        vertexBuffer.func_178969_c(0.0, 0.0, 0.0);
        vertexBuffer.func_181663_c(0.0f, 0.0f, -1.0f);
        vertexBuffer.func_181662_b(b.field_72340_a, b.field_72337_e, b.field_72339_c).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72336_d, b.field_72337_e, b.field_72339_c).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72336_d, b.field_72338_b, b.field_72339_c).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72340_a, b.field_72338_b, b.field_72339_c).func_181675_d();
        vertexBuffer.func_181663_c(0.0f, 0.0f, 1.0f);
        vertexBuffer.func_181662_b(b.field_72340_a, b.field_72338_b, b.field_72334_f).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72336_d, b.field_72338_b, b.field_72334_f).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72336_d, b.field_72337_e, b.field_72334_f).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72340_a, b.field_72337_e, b.field_72334_f).func_181675_d();
        vertexBuffer.func_181663_c(0.0f, -1.0f, 0.0f);
        vertexBuffer.func_181662_b(b.field_72340_a, b.field_72338_b, b.field_72339_c).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72336_d, b.field_72338_b, b.field_72339_c).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72336_d, b.field_72338_b, b.field_72334_f).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72340_a, b.field_72338_b, b.field_72334_f).func_181675_d();
        vertexBuffer.func_181663_c(0.0f, 1.0f, 0.0f);
        vertexBuffer.func_181662_b(b.field_72340_a, b.field_72337_e, b.field_72334_f).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72336_d, b.field_72337_e, b.field_72334_f).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72336_d, b.field_72337_e, b.field_72339_c).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72340_a, b.field_72337_e, b.field_72339_c).func_181675_d();
        vertexBuffer.func_181663_c(-1.0f, 0.0f, 0.0f);
        vertexBuffer.func_181662_b(b.field_72340_a, b.field_72338_b, b.field_72334_f).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72340_a, b.field_72337_e, b.field_72334_f).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72340_a, b.field_72337_e, b.field_72339_c).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72340_a, b.field_72338_b, b.field_72339_c).func_181675_d();
        vertexBuffer.func_181663_c(1.0f, 0.0f, 0.0f);
        vertexBuffer.func_181662_b(b.field_72336_d, b.field_72338_b, b.field_72339_c).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72336_d, b.field_72337_e, b.field_72339_c).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72336_d, b.field_72337_e, b.field_72334_f).func_181675_d();
        vertexBuffer.func_181662_b(b.field_72336_d, b.field_72338_b, b.field_72334_f).func_181675_d();
        vertexBuffer.func_178969_c(0.0, 0.0, 0.0);
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GL11.glPolygonMode((int)1032, (int)6914);
        GL11.glPopMatrix();
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawGUIBack(int x, int y, int width, int height) {
        Graphics.FillRect((double)x, (double)y, (double)width, (double)height, 0.0, ResourceManager.GUI_BACK);
        Graphics.FillRect((double)x, (double)(y - 3), (double)width, 1.0, 0.0, Color.black);
        Graphics.FillRect((double)x, (double)(y - 2), (double)width, 2.0, 0.0, Color.white);
        Graphics.FillRect((double)(x - 3), (double)y, 1.0, (double)height, 0.0, Color.black);
        Graphics.FillRect((double)(x - 2), (double)y, 2.0, (double)height, 0.0, Color.white);
        Graphics.FillRect((double)(x + width), (double)y, 2.0, (double)height, 0.0, Color.darkGray);
        Graphics.FillRect((double)(x + width + 2), (double)y, 1.0, (double)height, 0.0, Color.black);
        Graphics.FillRect((double)x, (double)(y + height), (double)width, 2.0, 0.0, Color.darkGray);
        Graphics.FillRect((double)x, (double)(y + height + 2), (double)width, 1.0, 0.0, Color.black);
        Graphics.bindTexture(ResourceManager.GUI_BACK_PARTS.getResourceLocation());
        Gui.func_146110_a((int)(x - 3), (int)(y - 3), (float)0.0f, (float)0.0f, (int)4, (int)4, (float)16.0f, (float)16.0f);
        Gui.func_146110_a((int)(x + width), (int)(y - 2), (float)4.0f, (float)2.0f, (int)4, (int)2, (float)16.0f, (float)16.0f);
        Gui.func_146110_a((int)(x + width - 1), (int)(y + height - 1), (float)0.0f, (float)4.0f, (int)4, (int)4, (float)16.0f, (float)16.0f);
        Gui.func_146110_a((int)(x - 2), (int)(y + height), (float)4.0f, (float)0.0f, (int)4, (int)2, (float)16.0f, (float)16.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawGUIEdges(int x, int y, int width, int height) {
        ScaledResolution s = new ScaledResolution(Minecraft.func_71410_x());
        Graphics.FillRect(0.0, 0.0, (double)s.func_78326_a(), (double)y, 1.0, Color.gray);
        Graphics.FillRect(0.0, (double)(y + height), (double)s.func_78326_a(), (double)(s.func_78328_b() - height - y), 1.0, Color.gray);
        Graphics.FillRect(0.0, 0.0, (double)x, (double)s.func_78328_b(), 1.0, Color.gray);
        Graphics.FillRect((double)(width + x), 1.0, (double)(s.func_78326_a() - width - x), (double)s.func_78328_b(), 1.0, Color.gray);
        Graphics.FillRect((double)(x + 1), (double)y, (double)(width - 1), 1.0, 1.0, Color.black);
        Graphics.FillRect((double)(x + 1), (double)(y - 2), (double)(width - 1), 2.0, 1.0, Color.darkGray);
        Graphics.FillRect((double)x, (double)(y + 1), 1.0, (double)(height - 1), 1.0, Color.black);
        Graphics.FillRect((double)(x - 2), (double)(y + 1), 2.0, (double)(height - 1), 1.0, Color.darkGray);
        Graphics.FillRect((double)(x + width + 1), (double)(y + 1), 2.0, (double)(height - 1), 1.0, Color.white);
        Graphics.FillRect((double)(x + width), (double)(y + 1), 1.0, (double)(height - 1), 1.0, Color.black);
        Graphics.FillRect((double)(x + 1), (double)(y + height + 1), (double)(width - 1), 2.0, 1.0, Color.white);
        Graphics.FillRect((double)(x + 1), (double)(y + height), (double)(width - 1), 1.0, 1.0, Color.black);
        Graphics.FillRect((double)(x - 1), (double)(y - 1), 2.0, 2.0, 1.0, Color.darkGray);
        Graphics.FillRect((double)(x - 1), (double)(y + height), 2.0, 2.0, 1.0, Color.darkGray);
        Graphics.FillRect((double)(x + width), (double)(y + height), 2.0, 2.0, 1.0, Color.white);
        Graphics.FillRect((double)(x + width), (double)(y - 1), 2.0, 2.0, 1.0, Color.white);
    }

    @SideOnly(value=Side.CLIENT)
    public static void brightRender() {
        int i = 0xF000F0;
        int j = i % 65536;
        int k = i / 65536;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)j / 1.0f), (float)((float)k / 1.0f));
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawModelToGui(ModelBase model, int xPos, int yPos, float par2, float rotation) {
        GL11.glPushMatrix();
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glTranslatef((float)xPos, (float)yPos, (float)100.0f);
        GL11.glRotatef((float)-25.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74520_c();
        GL11.glScalef((float)(38.0f * par2), (float)(34.0f * par2), (float)(38.0f * par2));
        GL11.glScalef((float)-1.0f, (float)1.0f, (float)1.0f);
        model.func_78088_a((Entity)Minecraft.func_71410_x().field_71439_g, 0.0f, 0.0f, Utils.handleRotationFloat((EntityLivingBase)Minecraft.func_71410_x().field_71439_g, 0.0f), 0.0f, 0.0f, Graphics.renderNum());
        Graphics.FillRect((double)xPos, (double)yPos, 10.0, 10.0, 0.0, -1);
        RenderHelper.func_74518_a();
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2929);
        GL11.glPopMatrix();
    }

    @SideOnly(value=Side.CLIENT)
    public static ResourceLocation getTextureForPlayer(String username) {
        ResourceLocation resourcelocation = DefaultPlayerSkin.func_177335_a();
        resourcelocation = AbstractClientPlayer.func_110311_f((String)username);
        AbstractClientPlayer.func_110304_a((ResourceLocation)resourcelocation, (String)username);
        return resourcelocation;
    }
}

