/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.xplosive.client.model.mdl;

import com.swdteam.xplosive.client.graphics.Graphics;
import com.swdteam.xplosive.client.model.mdl.MDLData;
import com.swdteam.xplosive.client.model.mdl.MDLState;
import com.swdteam.xplosive.client.model.mdl.ModelRendererPatch;
import com.swdteam.xplosive.client.render.IRenderExtender;
import java.awt.image.BufferedImage;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class ModelMDL
extends ModelBase {
    private BufferedImage texture;
    private int textureID;
    private boolean loadingTexture;
    private List<ModelRendererPatch> parts = new ArrayList<ModelRendererPatch>();
    private boolean useTexture;
    private MDLData model_data;
    private IRenderExtender renderExtender;

    public void renderModel(TileEntity t, float ... f) {
        this.renderModel(MDLState.DEFAULT, t, f);
    }

    public void renderModel(MDLState state, TileEntity t, float ... f) {
        FloatBuffer color = BufferUtils.createFloatBuffer((int)16);
        GL11.glGetFloat((int)2816, (FloatBuffer)color);
        float alphaValue = color.get(3);
        int previousTexture = GL11.glGetInteger((int)32873);
        GL11.glPushMatrix();
        GL11.glNormal3f((float)1.0f, (float)1.0f, (float)1.0f);
        if (this.parts != null) {
            boolean enabled;
            if (this.useTexture && this.texture != null) {
                if (!this.loadingTexture) {
                    this.loadingTexture = true;
                    if (this.texture != null) {
                        this.textureID = Graphics.loadTexture(this.texture);
                    }
                }
                Graphics.bindTexture(this.textureID);
            }
            if (!(enabled = GL11.glIsEnabled((int)3042))) {
                GL11.glEnable((int)3042);
            }
            GL11.glBlendFunc((int)770, (int)771);
            if (this.model_data != null) {
                GL11.glTranslated((double)this.model_data.transform[0], (double)this.model_data.transform[1], (double)this.model_data.transform[2]);
                GL11.glTranslated((double)this.model_data.offset[0], (double)this.model_data.offset[1], (double)this.model_data.offset[2]);
                GL11.glRotated((double)this.model_data.rotation[0], (double)1.0, (double)0.0, (double)0.0);
                GL11.glRotated((double)this.model_data.rotation[1], (double)0.0, (double)1.0, (double)0.0);
                GL11.glRotated((double)this.model_data.rotation[2], (double)0.0, (double)0.0, (double)1.0);
                GL11.glTranslated((double)(-this.model_data.offset[0]), (double)(-this.model_data.offset[1]), (double)(-this.model_data.offset[2]));
                GL11.glScaled((double)this.model_data.scale[0], (double)this.model_data.scale[1], (double)this.model_data.scale[2]);
            }
            for (ModelRendererPatch modelRendererPatch : this.parts) {
                modelRendererPatch.field_78800_c = modelRendererPatch.default_position[0];
                modelRendererPatch.field_78797_d = modelRendererPatch.default_position[1];
                modelRendererPatch.field_78798_e = modelRendererPatch.default_position[2];
                modelRendererPatch.field_78795_f = (float)Math.toRadians(modelRendererPatch.default_rotation[0]);
                modelRendererPatch.field_78796_g = (float)Math.toRadians(modelRendererPatch.default_rotation[1]);
                modelRendererPatch.field_78808_h = (float)Math.toRadians(modelRendererPatch.default_rotation[2]);
                modelRendererPatch.field_82906_o = modelRendererPatch.default_offset[0];
                modelRendererPatch.field_82908_p = modelRendererPatch.default_offset[1];
                modelRendererPatch.field_82907_q = modelRendererPatch.default_offset[2];
                modelRendererPatch.func_78784_a(modelRendererPatch.default_texture_offset[0], modelRendererPatch.default_texture_offset[1]);
                this.defaultChildElements(modelRendererPatch);
            }
            MDLState temp_state = MDLState.DEFAULT;
            for (MDLData.MDLStates s : this.model_data.model_states) {
                if (s.state != state) continue;
                for (ModelRendererPatch p : this.parts) {
                    if (p.getShapeName().equals(s.shape_name)) {
                        if (s.state_position != null) {
                            p.field_78800_c = s.state_position[0];
                            p.field_78797_d = s.state_position[1];
                            p.field_78798_e = s.state_position[2];
                        }
                        if (s.state_rotation != null) {
                            p.field_78795_f = (float)Math.toRadians(s.state_rotation[0]);
                            p.field_78796_g = (float)Math.toRadians(s.state_rotation[1]);
                            p.field_78808_h = (float)Math.toRadians(s.state_rotation[2]);
                        }
                        if (s.state_offset != null) {
                            p.field_82906_o = s.state_offset[0];
                            p.field_82908_p = s.state_offset[1];
                            p.field_82907_q = s.state_offset[2];
                        }
                        if (s.state_texture_offset != null) {
                            p.func_78784_a(s.state_texture_offset[0], s.state_texture_offset[1]);
                        }
                    }
                    this.checkChildElementsForStates(this.model_data, p, s);
                }
                break;
            }
            for (ModelRendererPatch r : this.parts) {
                r.func_78791_b(f[0]);
            }
            if (!enabled) {
                GL11.glDisable((int)3042);
            }
            if (this.useTexture) {
                // empty if block
            }
        }
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        if (this.model_data != null && this.model_data.font_renderer != null) {
            for (int i = 0; i < this.model_data.font_renderer.length; ++i) {
                FontRenderer font = Minecraft.func_71410_x().field_71466_p;
                MDLData.MDLTextData mDLTextData = this.model_data.font_renderer[i];
                if (font == null || mDLTextData == null) continue;
                GL11.glPushMatrix();
                double[] offset = mDLTextData.offset;
                double[] scale = mDLTextData.scale;
                double[] transform = mDLTextData.transform;
                double[] rotation = mDLTextData.rotation;
                GL11.glTranslated((double)transform[0], (double)transform[1], (double)transform[2]);
                GL11.glTranslated((double)offset[0], (double)offset[1], (double)offset[2]);
                GL11.glRotated((double)mDLTextData.rotation[0], (double)1.0, (double)0.0, (double)0.0);
                GL11.glRotated((double)mDLTextData.rotation[1], (double)0.0, (double)1.0, (double)0.0);
                GL11.glRotated((double)mDLTextData.rotation[2], (double)0.0, (double)0.0, (double)1.0);
                GL11.glTranslated((double)(-offset[0]), (double)(-offset[1]), (double)(-offset[2]));
                GL11.glScalef((float)0.05f, (float)0.05f, (float)0.05f);
                GL11.glScaled((double)scale[0], (double)scale[1], (double)scale[2]);
                int col = mDLTextData.color;
                float r = col >> 16 & 0xFF;
                float g = col >> 8 & 0xFF;
                float b = col & 0xFF;
                float a = (float)(col >> 24 & 0xFF) / 255.0f - (1.0f - alphaValue);
                if (a < 0.0f) {
                    a = 0.0f;
                }
                GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
                font.func_175065_a(mDLTextData.getText(), 1.0f, 1.0f, -1, false);
                GL11.glScaled((double)(-scale[0]), (double)(-scale[1]), (double)(-scale[2]));
                GL11.glScalef((float)-0.05f, (float)-0.05f, (float)-0.05f);
                GL11.glTranslated((double)(-transform[0]), (double)(-transform[1]), (double)(-transform[2]));
                GL11.glPopMatrix();
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alphaValue);
        }
        Graphics.bindTexture(previousTexture);
        GL11.glPopMatrix();
    }

    public void checkChildElementsForStates(MDLData data, ModelRendererPatch mr, MDLData.MDLStates s) {
        if (mr.field_78805_m != null) {
            for (Object o : mr.field_78805_m) {
                if (!(o instanceof ModelRendererPatch)) continue;
                ModelRendererPatch p = (ModelRendererPatch)((Object)o);
                if (p.getShapeName().equals(s.shape_name)) {
                    p.field_78800_c = s.state_offset[0];
                    p.field_78797_d = s.state_offset[1];
                    p.field_78798_e = s.state_offset[2];
                    p.field_78795_f = s.state_rotation[0];
                    p.field_78796_g = s.state_rotation[1];
                    p.field_78808_h = s.state_rotation[2];
                    p.field_82906_o = s.state_position[0];
                    p.field_82908_p = s.state_position[1];
                    p.field_82907_q = s.state_position[2];
                    p.func_78784_a(s.state_texture_offset[0], s.state_texture_offset[1]);
                }
                this.checkChildElementsForStates(data, p, s);
            }
        }
    }

    public void defaultChildElements(ModelRenderer m) {
        if (m.field_78805_m != null && m.field_78805_m.size() > 0) {
            for (Object j : m.field_78805_m) {
                if (j instanceof ModelRendererPatch) {
                    ModelRendererPatch p = (ModelRendererPatch)((Object)j);
                    p.field_78800_c = p.default_position[0];
                    p.field_78797_d = p.default_position[1];
                    p.field_78798_e = p.default_position[2];
                    p.field_78795_f = (float)Math.toRadians(p.default_rotation[0]);
                    p.field_78796_g = (float)Math.toRadians(p.default_rotation[1]);
                    p.field_78808_h = (float)Math.toRadians(p.default_rotation[2]);
                    p.field_82906_o = p.default_offset[0];
                    p.field_82908_p = p.default_offset[1];
                    p.field_82907_q = p.default_offset[2];
                    p.func_78784_a(p.default_texture_offset[0], p.default_texture_offset[1]);
                }
                this.defaultChildElements((ModelRenderer)j);
            }
        }
    }

    public int getTextureID() {
        return this.textureID;
    }

    public void setTexture(BufferedImage texture) {
        this.texture = texture;
    }

    public BufferedImage getTexture() {
        return this.texture;
    }

    public List<ModelRendererPatch> getParts() {
        return this.parts;
    }

    public void addPart(ModelRendererPatch r) {
        this.parts.add(r);
    }

    public void setRotation(ModelRenderer model, float x, float y, float z) {
        model.field_78795_f = x;
        model.field_78796_g = y;
        model.field_78808_h = z;
    }

    public void func_78088_a(Entity p_78088_1_, float p_78088_2_, float p_78088_3_, float p_78088_4_, float p_78088_5_, float p_78088_6_, float p_78088_7_) {
        if (this.getRenderExtender() != null) {
            this.getRenderExtender().preRender(p_78088_1_);
        }
        this.renderModel(null, p_78088_7_);
        if (this.getRenderExtender() != null) {
            this.getRenderExtender().postRender(p_78088_1_);
        }
        super.func_78088_a(p_78088_1_, p_78088_2_, p_78088_3_, p_78088_4_, p_78088_5_, p_78088_6_, p_78088_7_);
    }

    public boolean canUseTexture() {
        return this.useTexture;
    }

    public void setUseTexture(boolean useTexture) {
        this.useTexture = useTexture;
    }

    public void setRenderExtender(IRenderExtender renderExtender) {
        this.renderExtender = renderExtender;
    }

    public IRenderExtender getRenderExtender() {
        return this.renderExtender;
    }

    public void setModelData(MDLData model_data) {
        this.model_data = model_data;
    }

    public MDLData getModelData() {
        return this.model_data;
    }
}

