/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.xplosive.client.registry;

import com.swdteam.xplosive.client.model.mdl.MDLData;
import com.swdteam.xplosive.client.model.mdl.ModelBaseMDL;
import com.swdteam.xplosive.client.model.mdl.ModelMDL;
import com.swdteam.xplosive.client.model.mdl.ModelRendererMDL;
import com.swdteam.xplosive.client.model.mdl.ModelRendererPatch;
import com.swdteam.xplosive.client.registry.ResourceManager;
import com.swdteam.xplosive.main.Xplosives;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import net.minecraft.client.model.ModelRenderer;

public class MDLLoader {
    public static ModelMDL loadModel(String s) {
        return MDLLoader.loadModel(s, true);
    }

    public static ModelMDL loadModel(String s, boolean loadTexture) {
        ResourceManager.ResourceData r = new ResourceManager.ResourceData("xplosives:models/mdl/" + s + ".mdl");
        return MDLLoader.loadModel(r.getStream(), loadTexture);
    }

    public static ModelMDL loadModel(InputStream inputstream, boolean loadTexture) {
        ModelMDL model = new ModelMDL();
        model.setUseTexture(loadTexture);
        ModelBaseMDL modelData = null;
        ZipInputStream stream = new ZipInputStream(inputstream);
        ZipEntry e = null;
        try {
            while ((e = stream.getNextEntry()) != null) {
                String line;
                StringBuilder sb;
                BufferedReader reader;
                MDLData mdld = new MDLData();
                if (e.getName().equals("model_data.json")) {
                    try {
                        reader = new BufferedReader(new InputStreamReader(stream));
                        sb = new StringBuilder();
                        line = null;
                        while ((line = reader.readLine()) != null) {
                            sb.append(line);
                        }
                        mdld = (MDLData)Xplosives.json.fromJson(sb.toString(), MDLData.class);
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
                if (mdld != null) {
                    model.setModelData(mdld);
                } else {
                    model.setModelData(new MDLData());
                }
                if (loadTexture && e.getName().endsWith(".png")) {
                    model.setTexture(ImageIO.read(stream));
                }
                if (!e.getName().equalsIgnoreCase("model.json")) continue;
                reader = new BufferedReader(new InputStreamReader(stream));
                sb = new StringBuilder();
                line = null;
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                }
                modelData = (ModelBaseMDL)Xplosives.json.fromJson(sb.toString(), ModelBaseMDL.class);
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        model.field_78090_t = modelData.texture_width;
        model.field_78089_u = modelData.texture_height;
        for (int i = 0; i < modelData.getParts().size(); ++i) {
            ModelRendererMDL m = modelData.getParts().get(i);
            ModelRendererPatch mr = new ModelRendererPatch(model, m.getTexture_offset()[0], m.getTexture_offset()[1]);
            if (m.getShapeName() == null) {
                mr.setShapeName("shape_" + i);
            } else {
                mr.setShapeName(m.getShapeName());
            }
            mr.default_offset = m.getOffset();
            mr.default_position = m.getPosition();
            mr.default_rotation = m.getRotation();
            mr.default_texture_offset = m.getTexture_offset();
            mr.field_78809_i = m.isFlipTexture();
            mr.field_78801_a = model.field_78090_t;
            mr.field_78799_b = model.field_78089_u;
            mr.func_78789_a(m.getOffset()[0], m.getOffset()[1], m.getOffset()[2], m.getDimension()[0], m.getDimension()[1], m.getDimension()[2]);
            mr.func_78793_a(m.getPosition()[0], m.getPosition()[1], m.getPosition()[2]);
            mr.func_78784_a(m.getTexture_offset()[0], m.getTexture_offset()[1]);
            mr.field_78795_f = (float)Math.toRadians(m.getRotation()[0]);
            mr.field_78796_g = (float)Math.toRadians(m.getRotation()[1]);
            mr.field_78808_h = (float)Math.toRadians(m.getRotation()[2]);
            MDLLoader.addChildElements(model, m, mr);
            model.addPart(mr);
        }
        return model;
    }

    public static void addChildElements(ModelMDL model, ModelRendererMDL modelMDL, ModelRenderer parent) {
        if (modelMDL.getChildElements() != null && modelMDL.getChildElements().length > 0) {
            for (int i = 0; i < modelMDL.getChildElements().length; ++i) {
                ModelRendererMDL m = modelMDL.getChildElements()[i];
                ModelRendererPatch mr = new ModelRendererPatch(model, m.getTexture_offset()[0], m.getTexture_offset()[1]);
                if (m.getShapeName() == null) {
                    mr.setShapeName("shape_" + i);
                } else {
                    mr.setShapeName(m.getShapeName());
                }
                mr.default_offset = m.getOffset();
                mr.default_position = m.getPosition();
                mr.default_rotation = m.getRotation();
                mr.default_texture_offset = m.getTexture_offset();
                mr.field_78809_i = m.isFlipTexture();
                mr.field_78801_a = model.field_78090_t;
                mr.field_78799_b = model.field_78089_u;
                mr.func_78789_a(m.getOffset()[0], m.getOffset()[1], m.getOffset()[2], m.getDimension()[0], m.getDimension()[1], m.getDimension()[2]);
                mr.func_78793_a(m.getPosition()[0], m.getPosition()[1], m.getPosition()[2]);
                mr.func_78784_a(m.getTexture_offset()[0], m.getTexture_offset()[1]);
                mr.field_78795_f = (float)Math.toRadians(m.getRotation()[0]);
                mr.field_78796_g = (float)Math.toRadians(m.getRotation()[1]);
                mr.field_78808_h = (float)Math.toRadians(m.getRotation()[2]);
                MDLLoader.addChildElements(model, m, mr);
                parent.func_78792_a((ModelRenderer)mr);
            }
        }
    }
}

