/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.xplosive.common.block;

import com.swdteam.xplosive.common.block.BlockTileEntityBase;
import com.swdteam.xplosive.common.tileentity.TileEntityBase;
import com.swdteam.xplosive.common.tileentity.TileEntityDetonator;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockDetonator
extends BlockTileEntityBase {
    protected static final AxisAlignedBB AABB_DOWN = new AxisAlignedBB(0.41, 0.0, 0.345, 0.59, 0.1, 0.65).func_186662_g(0.025).func_72317_d(0.0, 0.875, 0.0);
    protected static final AxisAlignedBB AABB_UP = new AxisAlignedBB(0.41, 0.0, 0.345, 0.59, 0.1, 0.65).func_186662_g(0.025).func_72317_d(0.0, 0.025, 0.0);
    protected static final AxisAlignedBB AABB_NORTH = new AxisAlignedBB(0.35, 0.3, 1.0, 0.65, 0.7, 0.875);
    protected static final AxisAlignedBB AABB_SOUTH = new AxisAlignedBB(0.35, 0.3, 0.0, 0.65, 0.7, 0.125);
    protected static final AxisAlignedBB AABB_WEST = new AxisAlignedBB(0.875, 0.3, 0.35, 1.0, 0.7, 0.65);
    protected static final AxisAlignedBB AABB_EAST = new AxisAlignedBB(0.0, 0.3, 0.35, 0.125, 0.7, 0.65);

    public BlockDetonator(Class<? extends TileEntity> tClass) {
        super(tClass);
    }

    @Override
    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityBase) {
            int i = RANDOM.nextInt(360);
            ((TileEntityBase)te).rotation = i;
            if (te instanceof TileEntityDetonator) {
                TileEntityDetonator de = (TileEntityDetonator)te;
                de.placer = placer.func_110124_au();
            }
        }
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        return BlockDetonator.canPlaceBlock(worldIn, pos, side);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (!BlockDetonator.canPlaceBlock(worldIn, pos, enumfacing)) continue;
            return true;
        }
        return false;
    }

    @Override
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        switch (enumfacing) {
            case EAST: {
                return AABB_EAST;
            }
            case WEST: {
                return AABB_WEST;
            }
            case SOUTH: {
                return AABB_SOUTH;
            }
            default: {
                return AABB_NORTH;
            }
            case UP: {
                return AABB_UP;
            }
            case DOWN: 
        }
        return AABB_DOWN;
    }

    protected static boolean canPlaceBlock(World worldIn, BlockPos pos, EnumFacing direction) {
        BlockPos blockpos = pos.func_177972_a(direction.func_176734_d());
        IBlockState iblockstate = worldIn.func_180495_p(blockpos);
        boolean flag = iblockstate.func_193401_d((IBlockAccess)worldIn, blockpos, direction) == BlockFaceShape.SOLID;
        Block block = iblockstate.func_177230_c();
        if (block instanceof BlockDetonator) {
            flag = false;
        }
        if (direction == EnumFacing.UP) {
            return iblockstate.func_185896_q() || !BlockDetonator.func_193384_b((Block)block) && flag;
        }
        return !BlockDetonator.func_193382_c((Block)block) && flag;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return BlockDetonator.canPlaceBlock(worldIn, pos, facing) ? this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing) : this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.DOWN);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (this.checkForDrop(worldIn, pos, state) && !BlockDetonator.canPlaceBlock(worldIn, pos, (EnumFacing)state.func_177229_b((IProperty)FACING))) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    private boolean checkForDrop(World worldIn, BlockPos pos, IBlockState state) {
        if (this.func_176196_c(worldIn, pos)) {
            return true;
        }
        this.func_176226_b(worldIn, pos, state, 0);
        worldIn.func_175698_g(pos);
        return false;
    }
}

