/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.xplosive.common.block;

import com.swdteam.xplosive.client.registry.CreativeTabRegistry;
import com.swdteam.xplosive.common.block.IBlockExplodable;
import com.swdteam.xplosive.common.data.ExplosionFuseType;
import com.swdteam.xplosive.common.entity.EntityPrimedTntBase;
import com.swdteam.xplosive.common.entity.ExplosionHook;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class BlockTNTBase
extends Block
implements IBlockExplodable {
    public float explosionRadius = 4.0f;
    public int explosionFuse = 30;

    public BlockTNTBase(float explosionSize, int explosionFuse) {
        super(Material.field_151590_u);
        this.explosionRadius = explosionSize;
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149647_a(CreativeTabRegistry.TAB_EXPLOSIVES);
        this.explosionFuse = explosionFuse;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
        if (worldIn.func_175640_z(pos)) {
            this.explode(worldIn, null, pos, ExplosionFuseType.FULL);
            worldIn.func_175698_g(pos);
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (worldIn.func_175640_z(pos)) {
            this.explode(worldIn, null, pos, ExplosionFuseType.FULL);
            worldIn.func_175698_g(pos);
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack itemstack = playerIn.func_184586_b(hand);
        if (!(itemstack.func_190926_b() || itemstack.func_77973_b() != Items.field_151033_d && itemstack.func_77973_b() != Items.field_151059_bz)) {
            this.explode(worldIn, null, pos, ExplosionFuseType.FULL);
            worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 11);
            if (itemstack.func_77973_b() == Items.field_151033_d) {
                itemstack.func_77972_a(1, (EntityLivingBase)playerIn);
            } else if (!playerIn.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            return true;
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        EntityArrow entityarrow;
        if (!worldIn.field_72995_K && entityIn instanceof EntityArrow && (entityarrow = (EntityArrow)entityIn).func_70027_ad()) {
            this.explode(worldIn, entityarrow.field_70250_c instanceof EntityLivingBase ? (EntityLivingBase)entityarrow.field_70250_c : null, pos, ExplosionFuseType.FULL);
            worldIn.func_175698_g(pos);
        }
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
        if (!worldIn.field_72995_K) {
            this.explode(worldIn, explosionIn.func_94613_c() instanceof EntityLivingBase ? explosionIn.func_94613_c() : null, pos, ExplosionFuseType.SHORT);
        }
    }

    public boolean func_149659_a(Explosion explosionIn) {
        return false;
    }

    @Override
    public Entity explode(World w, EntityLivingBase entity, BlockPos p, ExplosionFuseType override) {
        if (!w.field_72995_K) {
            EntityPrimedTntBase entitytntprimed = new EntityPrimedTntBase(w, (float)p.func_177958_n() + 0.5f, p.func_177956_o(), (float)p.func_177952_p() + 0.5f, entity, w.func_180495_p(p));
            entitytntprimed.setBlock(this.func_176223_P());
            entitytntprimed.setFuse(this.getFuse(override));
            entitytntprimed.setExplosionRadius(this.explosionRadius);
            entitytntprimed.setHook(this.getExplosionHook());
            entitytntprimed.setDamage(this.canDamageTerrain());
            entitytntprimed.setFireExplosion(this.fireDamage());
            w.func_175698_g(p);
            w.func_72838_d((Entity)entitytntprimed);
            return entitytntprimed;
        }
        return null;
    }

    public int getFuse(ExplosionFuseType e) {
        switch (e) {
            case NONE: {
                return 0;
            }
            case TWO_TICKS: {
                return 2;
            }
            case SHORT: {
                return 10;
            }
        }
        return this.explosionFuse;
    }

    @Override
    public ExplosionFuseType getFuseTypeForDetonator() {
        return ExplosionFuseType.NONE;
    }

    @Override
    public ExplosionHook getExplosionHook() {
        return null;
    }

    @Override
    public boolean canDamageTerrain() {
        return true;
    }

    @Override
    public boolean fireDamage() {
        return false;
    }

    @Override
    public boolean canBeFired() {
        return true;
    }
}

