/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.xplosive.common.entity;

import com.swdteam.xplosive.common.entity.ExplosionHook;
import com.swdteam.xplosive.common.registry.BlockRegistry;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityPrimedTntBase
extends Entity
implements IEntityAdditionalSpawnData {
    private static final DataParameter<Integer> FUSE = EntityDataManager.func_187226_a(EntityPrimedTntBase.class, (DataSerializer)DataSerializers.field_187192_b);
    @Nullable
    private EntityLivingBase tntPlacedBy;
    private int fuse = 80;
    private ExplosionHook hook;
    private float explosionRadius = 4.0f;
    private boolean fireExplosion;
    private boolean doDamage = true;
    private IBlockState block;

    public EntityPrimedTntBase(World worldIn) {
        super(worldIn);
        this.field_70156_m = true;
        this.field_70178_ae = true;
        this.func_70105_a(0.98f, 0.98f);
        this.block = BlockRegistry.packed_tnt.func_176223_P();
    }

    public EntityPrimedTntBase(World worldIn, double x, double y, double z, EntityLivingBase igniter, IBlockState block) {
        this(worldIn);
        this.block = block;
        this.func_70107_b(x, y, z);
        float f = (float)(Math.random() * (Math.PI * 2));
        this.field_70159_w = -((float)Math.sin(f)) * 0.02f;
        this.field_70181_x = 0.2f;
        this.field_70179_y = -((float)Math.cos(f)) * 0.02f;
        this.setFuse(80);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
        this.tntPlacedBy = igniter;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(FUSE, (Object)80);
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public void func_70071_h_() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (!this.func_189652_ae()) {
            this.field_70181_x -= (double)0.04f;
        }
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.field_70159_w *= (double)0.98f;
        this.field_70181_x *= (double)0.98f;
        this.field_70179_y *= (double)0.98f;
        if (this.field_70122_E) {
            this.field_70159_w *= (double)0.7f;
            this.field_70179_y *= (double)0.7f;
            this.field_70181_x *= -0.5;
        }
        --this.fuse;
        if (this.hook != null) {
            this.hook.onEntityTick(this.field_70170_p, this);
        }
        if (this.fuse <= 0) {
            this.func_70106_y();
            if (!this.field_70170_p.field_72995_K) {
                this.explode();
            }
        } else {
            this.func_70072_I();
            this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    private void explode() {
        Explosion e = this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u + (double)(this.field_70131_O / 16.0f), this.field_70161_v, this.explosionRadius, this.doesDamage());
        if (this.isFireExplosion()) {
            for (int i = 0; i < e.func_180343_e().size(); ++i) {
                BlockPos p = (BlockPos)e.func_180343_e().get(i);
                if (this.field_70170_p.func_180495_p(p).func_185904_a() != Material.field_151579_a || !this.field_70170_p.func_180495_p(p.func_177977_b()).func_185913_b() || this.field_70146_Z.nextInt(3) != 0) continue;
                this.field_70170_p.func_175656_a(p, Blocks.field_150480_ab.func_176223_P());
            }
        }
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74777_a("Fuse", (short)this.getFuse());
        if (this.block != null) {
            compound.func_74768_a("block_id", Block.func_149682_b((Block)this.block.func_177230_c()));
            compound.func_74768_a("block_meta", this.block.func_177230_c().func_176201_c(this.block));
        }
        if (this.hook != null) {
            compound.func_74768_a("explosion_hook", ExplosionHook.getHookID(this.hook));
        }
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.setFuse(compound.func_74765_d("Fuse"));
        if (compound.func_74764_b("block_id")) {
            Block b = Block.func_149729_e((int)compound.func_74762_e("block_id"));
            this.block = b.func_176203_a(compound.func_74762_e("block_meta"));
        }
        if (compound.func_74764_b("explosion_hook")) {
            this.hook = ExplosionHook.getExplosionHook(compound.func_74762_e("explosion_hook"));
        }
    }

    @Nullable
    public EntityLivingBase getTntPlacedBy() {
        return this.tntPlacedBy;
    }

    public float func_70047_e() {
        return 0.0f;
    }

    public void setFuse(int fuseIn) {
        this.field_70180_af.func_187227_b(FUSE, (Object)fuseIn);
        this.fuse = fuseIn;
    }

    public void func_184206_a(DataParameter<?> key) {
        if (FUSE.equals(key)) {
            this.fuse = this.getFuseDataManager();
        }
    }

    public int getFuseDataManager() {
        return (Integer)this.field_70180_af.func_187225_a(FUSE);
    }

    public int getFuse() {
        return this.fuse;
    }

    public IBlockState getBlock() {
        if (this.block == null) {
            this.block = BlockRegistry.packed_tnt.func_176223_P();
        }
        return this.block;
    }

    public void setExplosionRadius(float explosionRadius) {
        this.explosionRadius = explosionRadius;
    }

    public float getExplosionRadius() {
        return this.explosionRadius;
    }

    public boolean isFireExplosion() {
        return this.fireExplosion;
    }

    public void setFireExplosion(boolean fireExplosion) {
        this.fireExplosion = fireExplosion;
    }

    public void setBlock(IBlockState block) {
        this.block = block;
    }

    public void writeSpawnData(ByteBuf buffer) {
        if (this.block == null) {
            this.block = BlockRegistry.packed_tnt.func_176223_P();
        }
        buffer.writeInt(Block.func_149682_b((Block)this.block.func_177230_c()));
        buffer.writeInt(this.block.func_177230_c().func_176201_c(this.block));
        buffer.writeInt(ExplosionHook.getHookID(this.hook));
    }

    public void readSpawnData(ByteBuf additionalData) {
        Block b = Block.func_149729_e((int)additionalData.readInt());
        this.block = b.func_176203_a(additionalData.readInt());
        this.hook = ExplosionHook.getExplosionHook(additionalData.readInt());
    }

    public ExplosionHook getHook() {
        return this.hook;
    }

    public void setHook(ExplosionHook hook) {
        this.hook = hook;
    }

    public boolean doesDamage() {
        return this.doDamage;
    }

    public void setDamage(boolean doesDamage) {
        this.doDamage = doesDamage;
    }
}

