/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.xplosive.common.registry;

import com.swdteam.xplosive.common.block.IBlockExplodable;
import com.swdteam.xplosive.common.entity.EntityFallingBlockOverride;
import com.swdteam.xplosive.common.entity.EntityPrimedTntBase;
import com.swdteam.xplosive.common.entity.ExplosionHook;
import java.util.ArrayList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.projectile.EntitySnowball;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class ExplosionHookRegistry {
    public static ExplosionHook HOOK_CLUSTER_BOMB = new ExplosionHook(){

        @Override
        public void onEntityTick(World w, EntityPrimedTntBase tnt) {
            if (tnt.getFuse() == 1 && !w.field_72995_K) {
                for (int i = 0; i < 30; ++i) {
                    EntityPrimedTntBase e = new EntityPrimedTntBase(w, tnt.field_70165_t, tnt.field_70163_u, tnt.field_70161_v, tnt.getTntPlacedBy(), Blocks.field_150335_W.func_176223_P());
                    boolean b = w.field_73012_v.nextBoolean();
                    e.setBlock(Blocks.field_150335_W.func_176223_P());
                    float motionX = w.field_73012_v.nextFloat() * (float)(b ? 1 : -1);
                    float motionY = w.field_73012_v.nextFloat();
                    b = w.field_73012_v.nextBoolean();
                    float motionZ = w.field_73012_v.nextFloat() * (float)(b ? 1 : -1);
                    e.field_70159_w = motionX;
                    e.field_70181_x = motionY;
                    e.field_70179_y = motionZ;
                    e.setFuse(70);
                    e.setExplosionRadius(4.0f);
                    w.func_72838_d((Entity)e);
                }
            }
        }
    };
    public static ExplosionHook HOOK_PHYSICS_BOMB = new ExplosionHook(){

        @Override
        public void onEntityTick(World w, EntityPrimedTntBase tnt) {
            if (tnt.getFuse() == 1 && !w.field_72995_K) {
                int i;
                Explosion explosion = new Explosion(w, (Entity)tnt.getTntPlacedBy(), tnt.field_70165_t, tnt.field_70163_u, tnt.field_70161_v, tnt.getExplosionRadius(), tnt.isFireExplosion(), true);
                if (ForgeEventFactory.onExplosionStart((World)w, (Explosion)explosion)) {
                    return;
                }
                explosion.func_77278_a();
                ArrayList<IBlockState> blockList = new ArrayList<IBlockState>();
                for (i = 0; i < explosion.func_180343_e().size(); ++i) {
                    blockList.add(w.func_180495_p((BlockPos)explosion.func_180343_e().get(i)));
                }
                for (i = 0; i < blockList.size(); ++i) {
                    IBlockState blockState = (IBlockState)blockList.get(i);
                    if (blockState.func_177230_c() == Blocks.field_150350_a || blockState.func_177230_c() instanceof IBlockExplodable) continue;
                    EntityFallingBlockOverride e = new EntityFallingBlockOverride(w, tnt.field_70165_t, tnt.field_70163_u, tnt.field_70161_v, blockState);
                    e.fallTime = -190;
                    e.setFallTile(blockState);
                    boolean b = w.field_73012_v.nextBoolean();
                    float motionX = w.field_73012_v.nextFloat() * (float)(b ? 1 : -1);
                    float motionY = w.field_73012_v.nextFloat();
                    b = w.field_73012_v.nextBoolean();
                    float motionZ = w.field_73012_v.nextFloat() * (float)(b ? 1 : -1);
                    e.field_70159_w = motionX;
                    e.field_70181_x = motionY;
                    e.field_70179_y = motionZ;
                    w.func_72838_d((Entity)e);
                }
            }
        }
    };
    public static ExplosionHook HOOK_BONEMEAL_BOMB = new ExplosionHook(){

        @Override
        public void onEntityTick(World w, EntityPrimedTntBase tnt) {
            if (tnt.getFuse() == 1) {
                Explosion explosion = new Explosion(w, (Entity)tnt.getTntPlacedBy(), tnt.field_70165_t, tnt.field_70163_u, tnt.field_70161_v, 20.0f, tnt.isFireExplosion(), true);
                if (ForgeEventFactory.onExplosionStart((World)w, (Explosion)explosion)) {
                    return;
                }
                explosion.func_77278_a();
                for (int i = 0; i < explosion.func_180343_e().size(); ++i) {
                    ItemDye.func_179234_a((ItemStack)new ItemStack(Items.field_151100_aR, 64, 0), (World)w, (BlockPos)((BlockPos)explosion.func_180343_e().get(i)));
                }
            }
        }
    };
    public static ExplosionHook HOOK_LIGHTNING_CONDUCTOR = new ExplosionHook(){

        @Override
        public void onEntityTick(World w, EntityPrimedTntBase tnt) {
            if (tnt.getFuse() <= 2) {
                for (int i = 0; i < 5; ++i) {
                    w.func_72942_c((Entity)new EntityLightningBolt(w, tnt.field_70165_t, tnt.field_70163_u, tnt.field_70161_v, true));
                }
            }
        }
    };
    public static ExplosionHook HOOK_INCENDIARY_BOMB = new ExplosionHook(){

        @Override
        public void onEntityTick(World w, EntityPrimedTntBase tnt) {
            if (tnt.getFuse() == 1 && !w.field_72995_K) {
                for (int i = 0; i < 90; ++i) {
                    EntityFallingBlockOverride e = new EntityFallingBlockOverride(w, tnt.field_70165_t, tnt.field_70163_u, tnt.field_70161_v, Blocks.field_150480_ab.func_176223_P());
                    e.fallTime = -190;
                    e.setFallTile(Blocks.field_150480_ab.func_176223_P());
                    boolean b = w.field_73012_v.nextBoolean();
                    float motionX = w.field_73012_v.nextFloat() * (b ? 0.5f : -0.5f);
                    b = w.field_73012_v.nextBoolean();
                    float motionY = w.field_73012_v.nextFloat() * (b ? 0.5f : -0.5f);
                    b = w.field_73012_v.nextBoolean();
                    float motionZ = w.field_73012_v.nextFloat() * (b ? 0.5f : -0.5f);
                    e.field_70159_w = motionX;
                    e.field_70181_x = motionY;
                    e.field_70179_y = motionZ;
                    w.func_72838_d((Entity)e);
                }
            }
        }
    };
    public static ExplosionHook HOOK_SNOWBALL_BOMB = new ExplosionHook(){

        @Override
        public void onEntityTick(World w, EntityPrimedTntBase tnt) {
            if (tnt.getFuse() == 1 && !w.field_72995_K) {
                int amount = 100 + w.field_73012_v.nextInt(200);
                for (int i = 0; i < amount; ++i) {
                    EntitySnowball e = new EntitySnowball(w, tnt.field_70165_t, tnt.field_70163_u, tnt.field_70161_v);
                    if (e == null) continue;
                    boolean b = w.field_73012_v.nextBoolean();
                    float motionX = w.field_73012_v.nextFloat() * (b ? 0.2f : -0.2f);
                    b = w.field_73012_v.nextBoolean();
                    float motionY = w.field_73012_v.nextFloat();
                    b = w.field_73012_v.nextBoolean();
                    float motionZ = w.field_73012_v.nextFloat() * (b ? 0.2f : -0.2f);
                    e.field_70159_w = motionX;
                    e.field_70181_x = motionY;
                    e.field_70179_y = motionZ;
                    w.func_72838_d((Entity)e);
                }
            }
        }
    };
    public static ExplosionHook HOOK_ARROW_BOMB = new ExplosionHook(){

        @Override
        public void onEntityTick(World w, EntityPrimedTntBase tnt) {
            if (tnt.getFuse() == 1 && !w.field_72995_K) {
                int amount = 100 + w.field_73012_v.nextInt(200);
                for (int i = 0; i < amount; ++i) {
                    EntityTippedArrow e = new EntityTippedArrow(w, tnt.field_70165_t, tnt.field_70163_u, tnt.field_70161_v);
                    if (e == null) continue;
                    boolean b = w.field_73012_v.nextBoolean();
                    float motionX = w.field_73012_v.nextFloat() * (b ? 0.2f : -0.2f);
                    b = w.field_73012_v.nextBoolean();
                    float motionY = w.field_73012_v.nextFloat();
                    b = w.field_73012_v.nextBoolean();
                    float motionZ = w.field_73012_v.nextFloat() * (b ? 0.2f : -0.2f);
                    e.field_70159_w = motionX;
                    e.field_70181_x = motionY;
                    e.field_70179_y = motionZ;
                    w.func_72838_d((Entity)e);
                }
            }
        }
    };
    public static ExplosionHook HOOK_TIPPED_ARROW_BOMB = new ExplosionHook(){

        @Override
        public void onEntityTick(World w, EntityPrimedTntBase tnt) {
            if (tnt.getFuse() == 1 && !w.field_72995_K) {
                int amount = 50 + w.field_73012_v.nextInt(150);
                ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                for (PotionType potiontype : PotionType.field_185176_a) {
                    if (potiontype.func_185170_a().isEmpty()) continue;
                    items.add(PotionUtils.func_185188_a((ItemStack)new ItemStack(Items.field_185167_i), (PotionType)potiontype));
                }
                items.add(new ItemStack(Items.field_151032_g));
                items.add(new ItemStack(Items.field_185166_h));
                for (int i = 0; i < amount; ++i) {
                    EntityTippedArrow e = new EntityTippedArrow(w, tnt.field_70165_t, tnt.field_70163_u, tnt.field_70161_v);
                    if (e == null) continue;
                    e.func_184555_a((ItemStack)items.get(w.field_73012_v.nextInt(items.size())));
                    boolean b = w.field_73012_v.nextBoolean();
                    float motionX = w.field_73012_v.nextFloat() * (b ? 0.2f : -0.2f);
                    b = w.field_73012_v.nextBoolean();
                    float motionY = w.field_73012_v.nextFloat();
                    b = w.field_73012_v.nextBoolean();
                    float motionZ = w.field_73012_v.nextFloat() * (b ? 0.2f : -0.2f);
                    e.field_70159_w = motionX;
                    e.field_70181_x = motionY;
                    e.field_70179_y = motionZ;
                    w.func_72838_d((Entity)e);
                }
            }
        }
    };
    public static ExplosionHook HOOK_HYDROGEN_BOMB = new ExplosionHook(){

        @Override
        public void onEntityTick(World w, EntityPrimedTntBase tnt) {
            if (tnt.getFuse() == 1) {
                int bX = (int)tnt.field_70165_t;
                int bY = (int)tnt.field_70163_u;
                int bZ = (int)tnt.field_70161_v;
                int radius = 25;
                boolean hollow = false;
                HOOK_INCENDIARY_BOMB.onEntityTick(w, tnt);
                for (int x = bX - radius; x <= bX + radius; ++x) {
                    for (int y = bY - radius / 2; y <= bY + radius / 3; ++y) {
                        for (int z = bZ - radius; z <= bZ + radius; ++z) {
                            double distance = (bX - x) * (bX - x) + (bZ - z) * (bZ - z) + (bY - y) * (bY - y);
                            if (!(distance < (double)(radius * radius)) || hollow && distance < (double)((radius - 1) * (radius - 1))) continue;
                            BlockPos pos = new BlockPos(x, y, z);
                            if (w.field_73012_v.nextInt(2500) == 1) {
                                w.func_72876_a((Entity)tnt.getTntPlacedBy(), (double)x, (double)y, (double)z, 18.0f, true);
                                continue;
                            }
                            if (w.func_180495_p(pos).func_177230_c() == Blocks.field_150357_h || w.func_180495_p(pos).func_177230_c() == Blocks.field_150350_a) continue;
                            w.func_175698_g(pos);
                            if (!(distance < (double)(radius * radius)) || !hollow && distance < (double)((radius - 1) * (radius - 1)) || w.field_73012_v.nextInt(5) != 2) continue;
                            w.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
                        }
                    }
                }
            }
        }
    };
}

