/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.xplosives.common.block;

import com.swdteam.xplosives.common.block.IExplosive;
import com.swdteam.xplosives.common.entity.EntityPrimedBlock;
import com.swdteam.xplosives.registry.XItems;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalFaceBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BlockDetonator
extends HorizontalFaceBlock {
    protected static final VoxelShape AABB_CEILING_X_OFF = Block.func_208617_a((double)6.0, (double)14.0, (double)5.0, (double)10.0, (double)16.0, (double)11.0);
    protected static final VoxelShape AABB_CEILING_Z_OFF = Block.func_208617_a((double)5.0, (double)14.0, (double)6.0, (double)11.0, (double)16.0, (double)10.0);
    protected static final VoxelShape AABB_FLOOR_X_OFF = Block.func_208617_a((double)6.0, (double)0.0, (double)5.0, (double)10.0, (double)2.0, (double)11.0);
    protected static final VoxelShape AABB_FLOOR_Z_OFF = Block.func_208617_a((double)5.0, (double)0.0, (double)6.0, (double)11.0, (double)2.0, (double)10.0);
    protected static final VoxelShape AABB_NORTH_OFF = Block.func_208617_a((double)5.0, (double)6.0, (double)14.0, (double)11.0, (double)10.0, (double)16.0);
    protected static final VoxelShape AABB_SOUTH_OFF = Block.func_208617_a((double)5.0, (double)6.0, (double)0.0, (double)11.0, (double)10.0, (double)2.0);
    protected static final VoxelShape AABB_WEST_OFF = Block.func_208617_a((double)14.0, (double)6.0, (double)5.0, (double)16.0, (double)10.0, (double)11.0);
    protected static final VoxelShape AABB_EAST_OFF = Block.func_208617_a((double)0.0, (double)6.0, (double)5.0, (double)2.0, (double)10.0, (double)11.0);

    public BlockDetonator(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_185512_D, (Comparable)Direction.NORTH)).func_206870_a((Property)field_196366_M, (Comparable)AttachFace.WALL));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction direction = (Direction)state.func_177229_b((Property)field_185512_D);
        switch ((AttachFace)state.func_177229_b((Property)field_196366_M)) {
            case FLOOR: {
                if (direction.func_176740_k() == Direction.Axis.X) {
                    return AABB_FLOOR_X_OFF;
                }
                return AABB_FLOOR_Z_OFF;
            }
            case WALL: {
                switch (direction) {
                    case EAST: {
                        return AABB_EAST_OFF;
                    }
                    case WEST: {
                        return AABB_WEST_OFF;
                    }
                    case SOUTH: {
                        return AABB_SOUTH_OFF;
                    }
                }
                return AABB_NORTH_OFF;
            }
        }
        if (direction.func_176740_k() == Direction.Axis.X) {
            return AABB_CEILING_X_OFF;
        }
        return AABB_CEILING_Z_OFF;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack stack;
        if (!worldIn.field_72995_K && handIn == Hand.MAIN_HAND && (stack = player.func_184586_b(handIn)) != null && stack.func_77973_b() == XItems.DETONATOR_REMOTE.get()) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new CompoundNBT());
            }
            if (!stack.func_77978_p().func_74764_b("positions")) {
                stack.func_77978_p().func_218657_a("positions", (INBT)new CompoundNBT());
                stack.func_77978_p().func_74778_a("dimension", worldIn.func_234923_W_().func_240901_a_().toString());
            }
            String display = pos.func_177958_n() + ", " + pos.func_177956_o() + ", " + pos.func_177952_p();
            String loc = "bp-" + pos.func_177958_n() + "-" + pos.func_177956_o() + "-" + pos.func_177952_p();
            if (((CompoundNBT)stack.func_77978_p().func_74781_a("positions")).func_74764_b(loc)) {
                ((CompoundNBT)stack.func_77978_p().func_74781_a("positions")).func_82580_o(loc);
                player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Removed " + display), true);
                worldIn.func_184133_a(null, pos, SoundEvents.field_187839_fV, SoundCategory.BLOCKS, 1.0f, 0.75f);
            } else {
                CompoundNBT tag = NBTUtil.func_186859_a((BlockPos)pos);
                ((CompoundNBT)stack.func_77978_p().func_74781_a("positions")).func_218657_a(loc, (INBT)tag);
                player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Added " + display), true);
                worldIn.func_184133_a(null, pos, SoundEvents.field_187839_fV, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    public void activate(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        BlockState blockState = worldIn.func_180495_p(pos.func_177972_a(BlockDetonator.func_196365_i((BlockState)state).func_176734_d()));
        if (blockState.func_177230_c() instanceof IExplosive) {
            EntityPrimedBlock block = new EntityPrimedBlock(worldIn, (double)pos.func_177972_a(BlockDetonator.func_196365_i((BlockState)state).func_176734_d()).func_177958_n() + 0.5, pos.func_177972_a(BlockDetonator.func_196365_i((BlockState)state).func_176734_d()).func_177956_o(), (double)pos.func_177972_a(BlockDetonator.func_196365_i((BlockState)state).func_176734_d()).func_177952_p() + 0.5, (LivingEntity)player, blockState);
            worldIn.func_217376_c((Entity)block);
            worldIn.func_175656_a(pos.func_177972_a(BlockDetonator.func_196365_i((BlockState)state).func_176734_d()), Blocks.field_150350_a.func_176223_P());
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_185512_D, field_196366_M});
    }
}

