/*
 * Decompiled with CFR 0.152.
 */
package com.turtledove.necropolisofnostalgia.ai;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.init.Blocks;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class NecropolisPathNavigateGround {
    protected EntityLiving entity;
    protected World world;
    @Nullable
    protected Path currentPath;
    protected double speed;
    private final IAttributeInstance pathSearchRange;
    protected int totalTicks;
    private int ticksAtLastPos;
    private Vec3d lastPosCheck = Vec3d.field_186680_a;
    private Vec3d timeoutCachedNode = Vec3d.field_186680_a;
    private long timeoutTimer;
    private long lastTimeoutCheck;
    private double timeoutLimit;
    protected float maxDistanceToWaypoint = 0.5f;
    protected boolean tryUpdatePath;
    private long lastTimeUpdated;
    protected NodeProcessor nodeProcessor;
    private BlockPos targetPos;
    private final PathFinder pathFinder;

    public NecropolisPathNavigateGround(EntityLiving entityIn, World worldIn) {
        this.entity = entityIn;
        this.world = worldIn;
        this.pathSearchRange = entityIn.func_110148_a(SharedMonsterAttributes.field_111265_b);
        this.pathFinder = this.getPathFinder();
    }

    protected abstract PathFinder getPathFinder();

    public void setSpeed(double speedIn) {
        this.speed = speedIn;
    }

    public float getPathSearchRange() {
        return (float)this.pathSearchRange.func_111126_e();
    }

    public boolean canUpdatePathOnTimeout() {
        return this.tryUpdatePath;
    }

    public void updatePath() {
        if (this.world.func_82737_E() - this.lastTimeUpdated > 20L) {
            if (this.targetPos != null) {
                this.currentPath = null;
                this.currentPath = this.getPathToPos(this.targetPos);
                this.lastTimeUpdated = this.world.func_82737_E();
                this.tryUpdatePath = false;
            }
        } else {
            this.tryUpdatePath = true;
        }
    }

    @Nullable
    public final Path getPathToXYZ(double x, double y, double z) {
        return this.getPathToPos(new BlockPos(x, y, z));
    }

    @Nullable
    public Path getPathToPos(BlockPos pos) {
        if (!this.canNavigate()) {
            return null;
        }
        if (this.currentPath != null && !this.currentPath.func_75879_b() && pos.equals((Object)this.targetPos)) {
            return this.currentPath;
        }
        this.targetPos = pos;
        float f = this.getPathSearchRange();
        this.world.field_72984_F.func_76320_a("pathfind");
        BlockPos blockpos = new BlockPos((Entity)this.entity);
        int i = (int)(f + 8.0f);
        ChunkCache chunkcache = new ChunkCache(this.world, blockpos.func_177982_a(-i, -i, -i), blockpos.func_177982_a(i, i, i), 0);
        Path path = this.pathFinder.func_186336_a((IBlockAccess)chunkcache, this.entity, this.targetPos, f);
        this.world.field_72984_F.func_76319_b();
        return path;
    }

    @Nullable
    public Path getPathToEntityLiving(Entity entityIn) {
        if (!this.canNavigate()) {
            return null;
        }
        BlockPos blockpos = new BlockPos(entityIn);
        if (this.currentPath != null && !this.currentPath.func_75879_b() && blockpos.equals((Object)this.targetPos)) {
            return this.currentPath;
        }
        this.targetPos = blockpos;
        float f = this.getPathSearchRange();
        this.world.field_72984_F.func_76320_a("pathfind");
        BlockPos blockpos1 = new BlockPos((Entity)this.entity).func_177984_a();
        int i = (int)(f + 16.0f);
        ChunkCache chunkcache = new ChunkCache(this.world, blockpos1.func_177982_a(-i, -i, -i), blockpos1.func_177982_a(i, i, i), 0);
        Path path = this.pathFinder.func_186333_a((IBlockAccess)chunkcache, this.entity, entityIn, f);
        this.world.field_72984_F.func_76319_b();
        return path;
    }

    public boolean tryMoveToXYZ(double x, double y, double z, double speedIn) {
        return this.setPath(this.getPathToXYZ(x, y, z), speedIn);
    }

    public boolean tryMoveToEntityLiving(Entity entityIn, double speedIn) {
        Path path = this.getPathToEntityLiving(entityIn);
        return path != null && this.setPath(path, speedIn);
    }

    public boolean setPath(@Nullable Path pathentityIn, double speedIn) {
        if (pathentityIn == null) {
            this.currentPath = null;
            return false;
        }
        if (!pathentityIn.func_75876_a(this.currentPath)) {
            this.currentPath = pathentityIn;
        }
        this.removeSunnyPath();
        if (this.currentPath.func_75874_d() <= 0) {
            return false;
        }
        this.speed = speedIn;
        Vec3d vec3d = this.getEntityPosition();
        this.ticksAtLastPos = this.totalTicks;
        this.lastPosCheck = vec3d;
        return true;
    }

    @Nullable
    public Path getPath() {
        return this.currentPath;
    }

    public void onUpdateNavigation() {
        ++this.totalTicks;
        if (this.tryUpdatePath) {
            this.updatePath();
        }
        if (!this.noPath()) {
            if (this.canNavigate()) {
                this.pathFollow();
            } else if (this.currentPath != null && this.currentPath.func_75873_e() < this.currentPath.func_75874_d()) {
                Vec3d vec3d = this.getEntityPosition();
                Vec3d vec3d1 = this.currentPath.func_75881_a((Entity)this.entity, this.currentPath.func_75873_e());
                if (vec3d.field_72448_b > vec3d1.field_72448_b && !this.entity.field_70122_E && MathHelper.func_76128_c((double)vec3d.field_72450_a) == MathHelper.func_76128_c((double)vec3d1.field_72450_a) && MathHelper.func_76128_c((double)vec3d.field_72449_c) == MathHelper.func_76128_c((double)vec3d1.field_72449_c)) {
                    this.currentPath.func_75872_c(this.currentPath.func_75873_e() + 1);
                }
            }
            this.debugPathFinding();
            if (!this.noPath()) {
                Vec3d vec3d2 = this.currentPath.func_75878_a((Entity)this.entity);
                BlockPos blockpos = new BlockPos(vec3d2).func_177977_b();
                AxisAlignedBB axisalignedbb = this.world.func_180495_p(blockpos).func_185900_c((IBlockAccess)this.world, blockpos);
                vec3d2 = vec3d2.func_178786_a(0.0, 1.0 - axisalignedbb.field_72337_e, 0.0);
                this.entity.func_70605_aq().func_75642_a(vec3d2.field_72450_a, vec3d2.field_72448_b, vec3d2.field_72449_c, this.speed);
            }
        }
    }

    protected void debugPathFinding() {
    }

    protected void pathFollow() {
        Vec3d vec3d = this.getEntityPosition();
        int i = this.currentPath.func_75874_d();
        for (int j = this.currentPath.func_75873_e(); j < this.currentPath.func_75874_d(); ++j) {
            if ((double)this.currentPath.func_75877_a((int)j).field_75837_b == Math.floor(vec3d.field_72448_b)) continue;
            i = j;
            break;
        }
        this.maxDistanceToWaypoint = this.entity.field_70130_N > 0.75f ? this.entity.field_70130_N / 2.0f : 0.75f - this.entity.field_70130_N / 2.0f;
        Vec3d vec3d1 = this.currentPath.func_186310_f();
        if (MathHelper.func_76135_e((float)((float)(this.entity.field_70165_t - (vec3d1.field_72450_a + 0.5)))) < this.maxDistanceToWaypoint && MathHelper.func_76135_e((float)((float)(this.entity.field_70161_v - (vec3d1.field_72449_c + 0.5)))) < this.maxDistanceToWaypoint && Math.abs(this.entity.field_70163_u - vec3d1.field_72448_b) < 1.0) {
            this.currentPath.func_75872_c(this.currentPath.func_75873_e() + 1);
        }
        int k = MathHelper.func_76123_f((float)this.entity.field_70130_N);
        int l = MathHelper.func_76123_f((float)this.entity.field_70131_O);
        int i1 = k;
        for (int j1 = i - 1; j1 >= this.currentPath.func_75873_e(); --j1) {
            if (!this.isDirectPathBetweenPoints(vec3d, this.currentPath.func_75881_a((Entity)this.entity, j1), k, l, i1)) continue;
            this.currentPath.func_75872_c(j1);
            break;
        }
        this.checkForStuck(vec3d);
    }

    protected void checkForStuck(Vec3d positionVec3) {
        if (this.totalTicks - this.ticksAtLastPos > 100) {
            if (positionVec3.func_72436_e(this.lastPosCheck) < 2.25) {
                this.clearPath();
            }
            this.ticksAtLastPos = this.totalTicks;
            this.lastPosCheck = positionVec3;
        }
        if (this.currentPath != null && !this.currentPath.func_75879_b()) {
            Vec3d vec3d = this.currentPath.func_186310_f();
            if (vec3d.equals((Object)this.timeoutCachedNode)) {
                this.timeoutTimer += System.currentTimeMillis() - this.lastTimeoutCheck;
            } else {
                this.timeoutCachedNode = vec3d;
                double d0 = positionVec3.func_72438_d(this.timeoutCachedNode);
                double d = this.timeoutLimit = this.entity.func_70689_ay() > 0.0f ? d0 / (double)this.entity.func_70689_ay() * 1000.0 : 0.0;
            }
            if (this.timeoutLimit > 0.0 && (double)this.timeoutTimer > this.timeoutLimit * 3.0) {
                this.timeoutCachedNode = Vec3d.field_186680_a;
                this.timeoutTimer = 0L;
                this.timeoutLimit = 0.0;
                this.clearPath();
            }
            this.lastTimeoutCheck = System.currentTimeMillis();
        }
    }

    public boolean noPath() {
        return this.currentPath == null || this.currentPath.func_75879_b();
    }

    public void clearPath() {
        this.currentPath = null;
    }

    protected abstract Vec3d getEntityPosition();

    protected abstract boolean canNavigate();

    protected boolean isInLiquid() {
        return this.entity.func_70090_H() || this.entity.func_180799_ab();
    }

    protected void removeSunnyPath() {
        if (this.currentPath != null) {
            for (int i = 0; i < this.currentPath.func_75874_d(); ++i) {
                PathPoint pathpoint = this.currentPath.func_75877_a(i);
                PathPoint pathpoint1 = i + 1 < this.currentPath.func_75874_d() ? this.currentPath.func_75877_a(i + 1) : null;
                IBlockState iblockstate = this.world.func_180495_p(new BlockPos(pathpoint.field_75839_a, pathpoint.field_75837_b, pathpoint.field_75838_c));
                Block block = iblockstate.func_177230_c();
                if (block != Blocks.field_150383_bp) continue;
                this.currentPath.func_186309_a(i, pathpoint.func_186283_a(pathpoint.field_75839_a, pathpoint.field_75837_b + 1, pathpoint.field_75838_c));
                if (pathpoint1 == null || pathpoint.field_75837_b < pathpoint1.field_75837_b) continue;
                this.currentPath.func_186309_a(i + 1, pathpoint1.func_186283_a(pathpoint1.field_75839_a, pathpoint.field_75837_b + 1, pathpoint1.field_75838_c));
            }
        }
    }

    protected abstract boolean isDirectPathBetweenPoints(Vec3d var1, Vec3d var2, int var3, int var4, int var5);

    public boolean canEntityStandOnPos(BlockPos pos) {
        return this.world.func_180495_p(pos.func_177977_b()).func_185913_b();
    }

    public NodeProcessor getNodeProcessor() {
        return this.nodeProcessor;
    }
}

