/*
 * Decompiled with CFR 0.152.
 */
package com.turtledove.necropolisofnostalgia.entity;

import com.google.common.primitives.Ints;
import com.turtledove.necropolisofnostalgia.ai.AnimationAI;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.ilexiconn.llibrary.server.animation.IAnimatedEntity;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;

public abstract class NecropolisEntity
extends EntityCreature
implements IAnimatedEntity {
    private static final byte START_IA_HEALTH_UPDATE_ID = 4;
    private static final DataParameter<Boolean> ISRAIDER = EntityDataManager.func_187226_a(NecropolisEntity.class, (DataSerializer)DataSerializers.field_187198_h);
    public int frame;
    public float targetDistance;
    public float targetAngle;
    private int animationTick;
    protected boolean prevOnGround;
    protected boolean prevPrevOnGround;
    protected boolean willLandSoon;
    private Animation animation = NO_ANIMATION;
    protected int[] elementWeakness = new int[8];
    public AnimationAI currentAnim = null;
    protected int[] dimensions;
    protected float height_max;
    protected float height_min;
    protected boolean needsDarkness;
    protected boolean needsSeeSky;
    protected String[] allowed_blocks;
    protected boolean isBoss = false;
    public boolean active;
    public boolean hitbyarrow = false;
    public boolean struckwhileGuarding = false;
    protected int defense = 0;
    protected int sDefense = 0;
    protected boolean isRaidMob = false;
    public Entity targetofmyrevenge = null;

    public NecropolisEntity(World world) {
        super(world);
        for (int i = 0; i < 8; ++i) {
            this.elementWeakness[i] = 0;
        }
        this.setFoeType(0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ISRAIDER, (Object)false);
    }

    public void setFoeType(int type) {
        switch (type) {
            case 0: {
                this.dimensions = new int[1];
                this.dimensions[0] = 0;
                this.height_max = 256.0f;
                this.height_min = 40.0f;
                this.needsDarkness = false;
                this.needsSeeSky = false;
                this.allowed_blocks = new String[]{"grass", "stone", "sand"};
                break;
            }
            case 1: {
                this.dimensions = new int[1];
                this.dimensions[0] = 0;
                this.height_max = 40.0f;
                this.height_min = 22.0f;
                this.needsDarkness = true;
                this.needsSeeSky = false;
                this.allowed_blocks = new String[]{"grass", "stone", "sand"};
            }
            case 2: {
                this.dimensions = new int[1];
                this.dimensions[0] = 0;
                this.height_max = 22.0f;
                this.height_min = 1.0f;
                this.needsDarkness = true;
                this.needsSeeSky = false;
                this.allowed_blocks = new String[]{"stone"};
            }
        }
    }

    public boolean func_70601_bi() {
        if (this.isBoss) {
            return false;
        }
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b);
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        BlockPos pos = new BlockPos(i, j, k);
        List dimensionIDs = Ints.asList((int[])this.dimensions);
        if (!dimensionIDs.contains(this.field_70170_p.field_73011_w.getDimension())) {
            return false;
        }
        float heightMax = this.height_max;
        float heightMin = this.height_min;
        if (this.field_70163_u > (double)heightMax && heightMax >= 0.0f) {
            return false;
        }
        if (this.field_70163_u < (double)heightMin) {
            return false;
        }
        if (this.needsDarkness && !this.isValidLightLevel()) {
            return false;
        }
        ResourceLocation blockName = this.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c().getRegistryName();
        List<String> allowedBlocks = Arrays.asList(this.allowed_blocks);
        if (blockName == null) {
            return false;
        }
        if (this.needsSeeSky && !this.field_70170_p.func_175678_i(pos)) {
            return false;
        }
        return this.needsSeeSky || !this.field_70170_p.func_175678_i(pos);
    }

    protected boolean isValidLightLevel() {
        BlockPos blockpos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        if (this.field_70170_p.func_175642_b(EnumSkyBlock.SKY, blockpos) > this.field_70146_Z.nextInt(32)) {
            return false;
        }
        int i = this.field_70170_p.func_175671_l(blockpos);
        if (this.field_70170_p.func_72911_I()) {
            int j = this.field_70170_p.func_175657_ab();
            this.field_70170_p.func_175692_b(10);
            i = this.field_70170_p.func_175671_l(blockpos);
            this.field_70170_p.func_175692_b(j);
        }
        return i <= this.field_70146_Z.nextInt(8);
    }

    public int getElementResponse(int i) {
        return this.elementWeakness[i];
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        String id = this.getPickedEntityId();
        if (id == null) {
            return ItemStack.field_190927_a;
        }
        return ItemStack.field_190927_a;
    }

    protected String getPickedEntityId() {
        return this.func_70022_Q();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
    }

    public int getDef() {
        return this.defense;
    }

    public int getSDef() {
        return this.sDefense;
    }

    public void func_70071_h_() {
        this.prevPrevOnGround = this.prevOnGround;
        this.prevOnGround = this.field_70122_E;
        super.func_70071_h_();
        ++this.frame;
        if (this.getAnimation() != NO_ANIMATION) {
            ++this.animationTick;
            if (this.field_70170_p.field_72995_K && this.animationTick >= this.animation.getDuration()) {
                this.setAnimation(NO_ANIMATION);
            }
        }
        if (this.func_70638_az() != null) {
            this.targetDistance = this.func_70032_d((Entity)this.func_70638_az());
            this.targetAngle = (float)this.getAngleBetweenEntities((Entity)this, (Entity)this.func_70638_az());
        }
        boolean bl = this.willLandSoon = !this.field_70122_E && this.field_70170_p.func_184143_b(this.func_174813_aQ().func_191194_a(new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y)));
        if (this.field_70170_p.field_72995_K && Boolean.valueOf((Boolean)this.field_70180_af.func_187225_a(ISRAIDER)).booleanValue() && this.field_70173_aa % 30 == 0) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t, this.field_70163_u + (double)this.field_70131_O + 1.0, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag;
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int i = 0;
        if (entityIn instanceof EntityLivingBase) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)entityIn).func_70668_bt());
            i += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
        }
        if (flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f)) {
            int j;
            if (i > 0 && entityIn instanceof EntityLivingBase) {
                ((EntityLivingBase)entityIn).func_70653_a((Entity)this, (float)i * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                entityIn.func_70015_d(j * 4);
            }
            if (entityIn instanceof EntityPlayer) {
                ItemStack itemstack1;
                EntityPlayer entityplayer = (EntityPlayer)entityIn;
                ItemStack itemstack = this.func_184614_ca();
                ItemStack itemStack = itemstack1 = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : ItemStack.field_190927_a;
                if (!itemstack.func_190926_b() && !itemstack1.func_190926_b() && itemstack.func_77973_b() instanceof ItemAxe && itemstack1.func_77973_b() == Items.field_185159_cQ) {
                    float f1 = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)this) * 0.05f;
                    if (this.field_70146_Z.nextFloat() < f1) {
                        entityplayer.func_184811_cZ().func_185145_a(Items.field_185159_cQ, 100);
                        this.field_70170_p.func_72960_a((Entity)entityplayer, (byte)30);
                    }
                }
            }
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    public Vec3d worldToThisEntity(Entity entityIn) {
        Vec3d player_dracoSpace_translated = new Vec3d(entityIn.field_70165_t - this.field_70165_t, entityIn.field_70163_u - this.field_70163_u, entityIn.field_70161_v - this.field_70161_v);
        float draco_angle = this.field_70177_z * 0.0174533f;
        float t_sin = MathHelper.func_76126_a((float)draco_angle);
        float t_cos = MathHelper.func_76134_b((float)draco_angle);
        Vec3d player_dracoSpace_rotated = new Vec3d(player_dracoSpace_translated.field_72450_a * (double)t_cos + player_dracoSpace_translated.field_72449_c * (double)t_sin, player_dracoSpace_translated.field_72448_b, -player_dracoSpace_translated.field_72450_a * (double)t_sin + player_dracoSpace_translated.field_72449_c * (double)t_cos);
        return player_dracoSpace_rotated;
    }

    public double getAngleBetweenEntities(Entity first, Entity second) {
        return Math.atan2(second.field_70161_v - first.field_70161_v, second.field_70165_t - first.field_70165_t) * 57.29577951308232 + 90.0;
    }

    public List<EntityPlayer> getPlayersNearby(double distanceX, double distanceY, double distanceZ, double radius) {
        List nearbyEntities = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(distanceX, distanceY, distanceZ));
        List<EntityPlayer> listEntityPlayers = nearbyEntities.stream().filter(entityNeighbor -> entityNeighbor instanceof EntityPlayer && (double)this.func_70032_d((Entity)entityNeighbor) <= radius).map(entityNeighbor -> (EntityPlayer)entityNeighbor).collect(Collectors.toList());
        return listEntityPlayers;
    }

    public List<EntityLivingBase> getAttackableEntityLivingBaseNearby(double distanceX, double distanceY, double distanceZ, double radius) {
        List nearbyEntities = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(distanceX, distanceY, distanceZ));
        List<EntityLivingBase> listEntityLivingBase = nearbyEntities.stream().filter(entityNeighbor -> entityNeighbor instanceof EntityLivingBase && ((EntityLivingBase)entityNeighbor).func_190631_cK() && (!(entityNeighbor instanceof EntityPlayer) || !((EntityPlayer)entityNeighbor).func_184812_l_()) && (double)this.func_70032_d((Entity)entityNeighbor) <= radius).map(entityNeighbor -> (EntityLivingBase)entityNeighbor).collect(Collectors.toList());
        return listEntityLivingBase;
    }

    public List<EntityLivingBase> getEntityLivingBaseNearby(double distanceX, double distanceY, double distanceZ, double radius) {
        return this.getEntitiesNearby(EntityLivingBase.class, distanceX, distanceY, distanceZ, radius);
    }

    public <T extends Entity> List<T> getEntitiesNearby(Class<T> entityClass, double r) {
        return this.field_70170_p.func_175647_a(entityClass, this.func_174813_aQ().func_72314_b(r, r, r), e -> e != this && (double)this.func_70032_d((Entity)e) <= r);
    }

    public <T extends Entity> List<T> getEntitiesNearby(Class<T> entityClass, double dX, double dY, double dZ, double r) {
        return this.field_70170_p.func_175647_a(entityClass, this.func_174813_aQ().func_72314_b(dX, dY, dZ), e -> e != this && (double)this.func_70032_d((Entity)e) <= r && e.field_70163_u <= this.field_70163_u + dY);
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.func_110143_aJ() <= 0.0f) {
            this.onDeathUpdate(20);
        }
    }

    private void onDeathUpdate(int deathDuration) {
        this.onDeathAIUpdate();
        if (++this.field_70725_aQ >= deathDuration) {
            boolean isPlayerKill;
            boolean bl = isPlayerKill = this.field_70718_bc > 0;
            if (!this.field_70170_p.field_72995_K && isPlayerKill && this.func_146066_aG() && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
                int value;
                for (int remaining = this.func_70693_a(this.field_70717_bb); remaining > 0; remaining -= value) {
                    value = EntityXPOrb.func_70527_a((int)remaining);
                    this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, value));
                }
            }
            if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
                this.dropLoot();
            }
            this.func_70106_y();
            for (int n = 0; n < 20; ++n) {
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d2, d0, d1, new int[0]);
            }
        }
    }

    protected void onDeathAIUpdate() {
    }

    protected final void func_70609_aI() {
        this.func_70106_y();
    }

    protected final void func_184610_a(boolean isPlayerKill, int lootingModifier, DamageSource source) {
    }

    protected final void func_70628_a(boolean isPlayerKill, int lootingModifier) {
    }

    protected void dropExperience(int p_184668_1_) {
        while (p_184668_1_ > 0) {
            int i = EntityXPOrb.func_70527_a((int)p_184668_1_);
            p_184668_1_ -= i;
            this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, i));
        }
    }

    protected final void func_82160_b(boolean isPlayerKill, int lootingModifier) {
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        return super.func_70097_a(source, damage);
    }

    protected boolean func_70692_ba() {
        return !this.isRaidMob;
    }

    public void func_70103_a(byte id) {
        super.func_70103_a(id);
    }

    protected void dropLoot() {
    }

    protected void onAnimationFinish(Animation animation) {
    }

    public Animation getAnimation() {
        return this.animation;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public void setAnimation(Animation animation) {
        if (animation == NO_ANIMATION) {
            this.onAnimationFinish(this.animation);
        }
        this.animation = animation;
        this.setAnimationTick(0);
    }

    public void setRaider() {
        this.isRaidMob = true;
        this.field_70180_af.func_187227_b(ISRAIDER, (Object)true);
    }

    public boolean isRaider() {
        return this.isRaidMob;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("is_raider", this.isRaidMob);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.isRaidMob = compound.func_74767_n("is_raider");
        this.field_70180_af.func_187227_b(ISRAIDER, (Object)this.isRaidMob);
    }
}

