/*
 * Decompiled with CFR 0.152.
 */
package com.turtledove.necropolisofnostalgia.entity;

import com.turtledove.necropolisofnostalgia.Necropolis_of_Nostalgia;
import com.turtledove.necropolisofnostalgia.entity.enemies.EntityAxeBeak;
import com.turtledove.necropolisofnostalgia.entity.enemies.EntityBabyNecropolisSpider;
import com.turtledove.necropolisofnostalgia.entity.enemies.EntityBooglin;
import com.turtledove.necropolisofnostalgia.entity.enemies.EntityFugu;
import com.turtledove.necropolisofnostalgia.entity.enemies.EntityNecropolisSkeleton;
import com.turtledove.necropolisofnostalgia.entity.enemies.EntityNecropolisSpider;
import com.turtledove.necropolisofnostalgia.entity.enemies.EntityVampireBat;
import java.util.Arrays;
import java.util.LinkedHashSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="turtdance")
public class NecropolisMobs {
    private static int nextEntityId;

    @SubscribeEvent
    public static void register(RegistryEvent.Register<EntityEntry> event) {
        Biome[] coldBiomes = BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.COLD).toArray(new Biome[BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.COLD).size()]);
        Biome[] hotBiomes = BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.HOT).toArray(new Biome[BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.HOT).size()]);
        Biome[] mountainBiomes = BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN).toArray(new Biome[BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN).size()]);
        Biome[] forestBiomes = BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST).toArray(new Biome[BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST).size()]);
        Biome[] plainsBiomes = BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS).toArray(new Biome[BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS).size()]);
        Biome[] wetBiomes = BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.WET).toArray(new Biome[BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.WET).size()]);
        LinkedHashSet<Biome> overworldSetA = new LinkedHashSet<Biome>();
        overworldSetA.addAll(Arrays.asList(coldBiomes));
        overworldSetA.addAll(Arrays.asList(hotBiomes));
        overworldSetA.addAll(Arrays.asList(mountainBiomes));
        overworldSetA.addAll(Arrays.asList(forestBiomes));
        overworldSetA.addAll(Arrays.asList(plainsBiomes));
        overworldSetA.addAll(Arrays.asList(wetBiomes));
        NecropolisMobs.registerMonster(EntityEntryBuilder.create(), event, EntityNecropolisSkeleton.class, "necropolis_skeleton", 11907995, 16184798, overworldSetA.toArray(new Biome[overworldSetA.size()]), Necropolis_of_Nostalgia.CONFIG.skeletonSpawnWeight, 1, Necropolis_of_Nostalgia.CONFIG.skeletonSpawnMaxGroupSize);
        NecropolisMobs.registerMonster(EntityEntryBuilder.create(), event, EntityAxeBeak.class, "axe_beak", 10747506, 10981675, overworldSetA.toArray(new Biome[overworldSetA.size()]), Necropolis_of_Nostalgia.CONFIG.axebeakSpawnWeight, 1, Necropolis_of_Nostalgia.CONFIG.axebeakSpawnMaxGroupSize);
        NecropolisMobs.registerMonster(EntityEntryBuilder.create(), event, EntityVampireBat.class, "vampire_bat", 3289140, 5918780, overworldSetA.toArray(new Biome[overworldSetA.size()]), Necropolis_of_Nostalgia.CONFIG.vampireBatSpawnWeight, 1, 2);
        NecropolisMobs.registerMonster(EntityEntryBuilder.create(), event, EntityBooglin.class, "booglin", 5402995, 14529158, overworldSetA.toArray(new Biome[overworldSetA.size()]), Necropolis_of_Nostalgia.CONFIG.booglinSpawnWeight, 1, 2);
        NecropolisMobs.registerMonster(EntityEntryBuilder.create(), event, EntityNecropolisSpider.class, "necropolis_spider", 2890513, 4337461, overworldSetA.toArray(new Biome[overworldSetA.size()]), Necropolis_of_Nostalgia.CONFIG.spiderSpawnWeight, 1, 1);
        NecropolisMobs.registerEntity(event, EntityBabyNecropolisSpider.class, "baby_necropolis_spider", true, 6375220, 14269307, 64);
        NecropolisMobs.registerMonster(EntityEntryBuilder.create(), event, EntityFugu.class, "fugu", 13689788, 7046780, overworldSetA.toArray(new Biome[overworldSetA.size()]), Necropolis_of_Nostalgia.CONFIG.fuguSpawnWeight, 2, 3);
    }

    public static void registerTileEntity(Class<? extends TileEntity> entityClass, String name) {
        GameRegistry.registerTileEntity(entityClass, (ResourceLocation)new ResourceLocation("turtdance", name));
    }

    public static void registerMonster(EntityEntryBuilder builder, RegistryEvent.Register<EntityEntry> event, Class<? extends Entity> entityClass, String name, int mainColor, int subColor, Biome[] biomes, int weight, int min, int max) {
        builder.entity(entityClass);
        builder.id(new ResourceLocation("turtdance", name), NecropolisMobs.nextEntityId());
        builder.name(name);
        builder.egg(mainColor, subColor);
        builder.tracker(64, 1, true);
        builder.spawn(EnumCreatureType.MONSTER, weight, min, max, biomes);
        event.getRegistry().register((IForgeRegistryEntry)builder.build());
    }

    public static void registerNPC(EntityEntryBuilder builder, RegistryEvent.Register<EntityEntry> event, Class<? extends Entity> entityClass, String name, int mainColor, int subColor, Biome[] biomes, int weight, int min, int max) {
        builder.entity(entityClass);
        builder.id(new ResourceLocation("turtdance", name), NecropolisMobs.nextEntityId());
        builder.name(name);
        builder.egg(mainColor, subColor);
        builder.tracker(64, 1, true);
        builder.spawn(EnumCreatureType.CREATURE, weight, min, max, biomes);
        event.getRegistry().register((IForgeRegistryEntry)builder.build());
    }

    public static void registerEntity(RegistryEvent.Register<EntityEntry> event, Class<? extends EntityLiving> entityClass, String name, boolean addEgg, int mainColor, int subColor, int trackingDistance) {
        if (addEgg) {
            event.getRegistry().register((IForgeRegistryEntry)EntityEntryBuilder.create().entity(entityClass).id(new ResourceLocation("turtdance", name), NecropolisMobs.nextEntityId()).name(name).tracker(trackingDistance, 1, true).egg(mainColor, subColor).build());
        } else {
            event.getRegistry().register((IForgeRegistryEntry)EntityEntryBuilder.create().entity(entityClass).id(new ResourceLocation("turtdance", name), NecropolisMobs.nextEntityId()).name(name).tracker(trackingDistance, 1, true).build());
        }
    }

    public static void registerEntity(RegistryEvent.Register<EntityEntry> event, Class<? extends Entity> entityClass, String name, int mainColor, int subColor, int trackingDistance) {
        event.getRegistry().register((IForgeRegistryEntry)EntityEntryBuilder.create().entity(entityClass).id(new ResourceLocation("turtdance", name), NecropolisMobs.nextEntityId()).name(name).tracker(trackingDistance, 1, true).egg(mainColor, subColor).build());
    }

    private static int nextEntityId() {
        return nextEntityId++;
    }
}

