/*
 * Decompiled with CFR 0.152.
 */
package com.turtledove.necropolisofnostalgia.entity.enemies;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.turtledove.necropolisofnostalgia.Necropolis_of_Nostalgia;
import com.turtledove.necropolisofnostalgia.ai.AnimationABEatAI;
import com.turtledove.necropolisofnostalgia.ai.AnimationABJabAI;
import com.turtledove.necropolisofnostalgia.ai.AnimationABLeapAI;
import com.turtledove.necropolisofnostalgia.ai.AnimationABRushAI;
import com.turtledove.necropolisofnostalgia.ai.AnimationGenericAI;
import com.turtledove.necropolisofnostalgia.ai.EntityAIFaceOff;
import com.turtledove.necropolisofnostalgia.entity.NecropolisEntity;
import com.turtledove.necropolisofnostalgia.sound.NecropolisSounds;
import javax.annotation.Nullable;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.ilexiconn.llibrary.server.animation.AnimationHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityAxeBeak
extends NecropolisEntity {
    public static final Animation LEAP_ANIMATION = Animation.create((int)40);
    public static final Animation JAB_ANIMATION = Animation.create((int)29);
    public static final Animation HURT_ANIMATION = Animation.create((int)5);
    public static final Animation RUSH_ANIMATION = Animation.create((int)13);
    public static final Animation EAT_ANIMATION = Animation.create((int)100);
    private static final Animation[] ANIMATIONS = new Animation[]{JAB_ANIMATION, LEAP_ANIMATION, HURT_ANIMATION, RUSH_ANIMATION, EAT_ANIMATION};
    private double distToPlayer;
    private int maxDistanceForPlayer;
    private int jabAttempts;
    private int leapStrikeCooldown;
    private int jabStrikeCooldown;
    private boolean isAggro;

    public EntityAxeBeak(World worldin) {
        super(worldin);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.func_70105_a(0.7f, 1.7f);
        this.active = true;
        this.field_70178_ae = false;
        this.targetofmyrevenge = null;
        this.struckwhileGuarding = false;
        this.maxDistanceForPlayer = 20;
        this.distToPlayer = 3.0;
        this.leapStrikeCooldown = 0;
        this.jabAttempts = 0;
        this.jabStrikeCooldown = 0;
        this.isAggro = false;
        this.defense = 4;
        this.sDefense = 4;
    }

    public boolean isCreatureType(EnumCreatureType type, boolean forSpawnCount) {
        if (forSpawnCount && this.func_104002_bU()) {
            return false;
        }
        return type == EnumCreatureType.MONSTER;
    }

    @Override
    public boolean func_70601_bi() {
        return super.func_70601_bi();
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(Necropolis_of_Nostalgia.CONFIG.axebeakMaxHealth);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(12.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
    }

    protected void func_184651_r() {
        this.distToPlayer = 3.0;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, new AnimationABRushAI<EntityAxeBeak>(this, RUSH_ANIMATION));
        this.field_70714_bg.func_75776_a(1, new AnimationABJabAI<EntityAxeBeak>(this, JAB_ANIMATION));
        this.field_70714_bg.func_75776_a(1, new AnimationABLeapAI<EntityAxeBeak>(this, LEAP_ANIMATION));
        this.field_70714_bg.func_75776_a(1, new AnimationGenericAI<EntityAxeBeak>(this, HURT_ANIMATION));
        this.field_70714_bg.func_75776_a(1, new AnimationABEatAI<EntityAxeBeak>(this, EAT_ANIMATION));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFaceOff(this, 0.375, this.distToPlayer));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.1875));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 2.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            EntityPlayer closestEntity = this.field_70170_p.func_190525_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, (double)this.maxDistanceForPlayer, Predicates.and((Predicate)EntitySelectors.field_188444_d, (Predicate)EntitySelectors.func_191324_b((Entity)this)));
            if (closestEntity != null && closestEntity.func_70089_S()) {
                if (!this.isAggro) {
                    this.targetofmyrevenge = null;
                    this.active = false;
                    if (this.isValidLightLevel() && this.func_70685_l((Entity)closestEntity) || this.isRaidMob) {
                        this.isAggro = true;
                    } else {
                        return;
                    }
                }
                if (this.targetofmyrevenge == null) {
                    this.func_184185_a(NecropolisSounds.AB_ANGRY, 1.0f, 0.75f);
                }
                this.targetofmyrevenge = closestEntity;
                this.active = true;
                if (this.func_70685_l(this.targetofmyrevenge)) {
                    float dist = this.func_70032_d(this.targetofmyrevenge);
                    if (this.func_70090_H()) {
                        double slopeX = (this.targetofmyrevenge.field_70165_t - this.field_70165_t) / 4.0;
                        double slopeZ = (this.targetofmyrevenge.field_70161_v - this.field_70161_v) / 4.0;
                        double numerator = Math.sqrt(slopeX * slopeX + slopeZ * slopeZ) * 10.0;
                        this.field_70159_w = slopeX * 0.75 / numerator;
                        this.field_70179_y = slopeZ * 0.75 / numerator;
                    }
                    if ((double)dist < this.distToPlayer) {
                        if (this.getAnimation() == NO_ANIMATION) {
                            this.func_70661_as().func_75497_a(this.targetofmyrevenge, 0.05);
                            this.func_70671_ap().func_75651_a(this.targetofmyrevenge, 90.0f, 90.0f);
                        } else {
                            this.func_70661_as().func_75499_g();
                        }
                        if ((double)dist >= 2.5) {
                            if (this.getAnimation() == NO_ANIMATION && this.leapStrikeCooldown > 5) {
                                if (Math.random() < 0.4) {
                                    AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, RUSH_ANIMATION);
                                } else {
                                    AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, LEAP_ANIMATION);
                                }
                                this.leapStrikeCooldown = 0;
                            }
                        } else if ((double)dist < 2.5) {
                            if (this.getAnimation() == NO_ANIMATION && this.jabAttempts < 2 && this.jabStrikeCooldown >= 5) {
                                AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, JAB_ANIMATION);
                                ++this.jabAttempts;
                                this.jabStrikeCooldown = 0;
                            }
                            if (this.jabAttempts > 1 && this.getAnimation() == NO_ANIMATION) {
                                AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, LEAP_ANIMATION);
                                this.leapStrikeCooldown = 0;
                                this.jabAttempts = 0;
                            }
                        }
                        if (this.getAnimation() == NO_ANIMATION) {
                            ++this.leapStrikeCooldown;
                            ++this.jabStrikeCooldown;
                        }
                    }
                }
            } else {
                this.targetofmyrevenge = null;
                this.active = false;
                this.leapStrikeCooldown = 0;
                this.jabStrikeCooldown = 0;
                this.isAggro = false;
            }
        }
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemFood itemfood;
        ItemStack itemstack = player.func_184586_b(hand);
        if (!itemstack.func_190926_b() && !this.isAggro && !this.field_70170_p.field_72995_K && itemstack.func_77973_b() instanceof ItemFood && this.getAnimation() == NO_ANIMATION && (itemfood = (ItemFood)itemstack.func_77973_b()).func_77845_h()) {
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            this.func_70691_i(this.func_110138_aP());
            AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, EAT_ANIMATION);
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public void setAggroLevel(boolean val) {
        this.isAggro = val;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K) {
            if (source.equals(DamageSource.field_76379_h)) {
                return false;
            }
            if (source.func_76355_l() == "melee" || source.func_76346_g() instanceof EntityPlayer) {
                this.isAggro = true;
            }
            if (this.getAnimation() == NO_ANIMATION) {
                AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, HURT_ANIMATION);
                this.func_184185_a(NecropolisSounds.AB_GRUNT, 0.5f, 1.0f);
                this.leapStrikeCooldown = 0;
                this.jabStrikeCooldown = 0;
            }
            return super.func_70097_a(source, amount);
        }
        return false;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            this.dropExperience(8);
            this.func_70099_a(new ItemStack(Items.field_151008_G, 5, 0), 0.0f);
            this.func_70099_a(new ItemStack(Items.field_151076_bf, 1, 0), 0.0f);
        }
    }

    public Animation[] getAnimations() {
        return ANIMATIONS;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableList.field_186394_B;
    }

    protected SoundEvent func_184639_G() {
        return NecropolisSounds.AB_GRUNT;
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.field_187566_ao;
    }
}

