/*
 * Decompiled with CFR 0.152.
 */
package com.turtledove.necropolisofnostalgia.entity.enemies;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.turtledove.necropolisofnostalgia.Necropolis_of_Nostalgia;
import com.turtledove.necropolisofnostalgia.ai.EntityAISpiderFaceOff;
import com.turtledove.necropolisofnostalgia.entity.NecropolisEntity;
import com.turtledove.necropolisofnostalgia.packets.Player.PlayerParticlePacket;
import com.turtledove.necropolisofnostalgia.sound.NecropolisSounds;
import java.util.List;
import javax.annotation.Nullable;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateClimber;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityBabyNecropolisSpider
extends NecropolisEntity {
    private static final Animation[] ANIMATIONS = new Animation[0];
    private int maxDistanceForPlayer;
    private static final DataParameter<Byte> CLIMBING = EntityDataManager.func_187226_a(EntityBabyNecropolisSpider.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Boolean> IGNITED = EntityDataManager.func_187226_a(EntityBabyNecropolisSpider.class, (DataSerializer)DataSerializers.field_187198_h);
    private int leapCooldown;
    public boolean startExplosion;
    private int explosionCount;
    private int igniteCount;

    public EntityBabyNecropolisSpider(World worldin) {
        super(worldin);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.func_70105_a(0.8f, 0.8f);
        this.active = true;
        this.field_70178_ae = false;
        this.targetofmyrevenge = null;
        this.struckwhileGuarding = false;
        this.maxDistanceForPlayer = 20;
        this.defense = 20;
        this.sDefense = 20;
        this.elementWeakness[1] = 1;
        this.elementWeakness[4] = -1;
        this.elementWeakness[6] = -1;
        this.elementWeakness[7] = 1;
        this.leapCooldown = 21;
        this.startExplosion = false;
        this.explosionCount = 0;
        this.igniteCount = 0;
        this.setFoeType(1);
    }

    public boolean isCreatureType(EnumCreatureType type, boolean forSpawnCount) {
        if (forSpawnCount && this.func_104002_bU()) {
            return false;
        }
        return type == EnumCreatureType.MONSTER;
    }

    @Override
    public boolean func_70601_bi() {
        return super.func_70601_bi();
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(Necropolis_of_Nostalgia.CONFIG.babySpiderMaxHealth);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(12.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_70105_a(0.8f, 0.8f);
        this.field_70180_af.func_187214_a(CLIMBING, (Object)0);
        this.field_70180_af.func_187214_a(IGNITED, (Object)false);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAISpiderFaceOff(this, 0.3f, 3.0));
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.setBesideClimbableBlock(this.field_70123_F);
            EntityPlayer closestEntity = this.field_70170_p.func_190525_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, (double)this.maxDistanceForPlayer, Predicates.and((Predicate)EntitySelectors.field_188444_d, (Predicate)EntitySelectors.func_191324_b((Entity)this)));
            if (this.startExplosion) {
                if (this.explosionCount > 50) {
                    List swipeEnemies = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(4.0, 0.0, 4.0).func_72317_d(-1.6, 0.0, -1.6));
                    if (!swipeEnemies.isEmpty()) {
                        for (Entity targ : swipeEnemies) {
                            if (!(targ instanceof EntityPlayer)) continue;
                            targ.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 26.0f);
                            ((EntityPlayer)targ).func_70690_d(new PotionEffect(MobEffects.field_76436_u, 100));
                        }
                    }
                    for (int j = 0; j < 24; ++j) {
                        float f = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
                        float f1 = this.field_70146_Z.nextFloat() * 0.5f + 0.5f;
                        float f2 = MathHelper.func_76126_a((float)f) * 0.5f * 3.0f * f1;
                        float f3 = MathHelper.func_76134_b((float)f) * 0.5f * 3.0f * f1;
                        World world = this.field_70170_p;
                        double d0 = this.field_70165_t + (double)f2;
                        double d1 = this.field_70161_v + (double)f3;
                        Necropolis_of_Nostalgia.packetHandler.sendToAll(new PlayerParticlePacket(1, d0, this.field_70163_u, d1, 0.0, 0.0, 0.0));
                    }
                    this.func_184185_a(NecropolisSounds.BABY_SPIDER_GONE, 1.0f, 1.0f);
                    this.func_70106_y();
                    return;
                }
                if (this.explosionCount % 10 == 0) {
                    this.func_184185_a(NecropolisSounds.BABY_SPIDER_GROW, 1.0f, 1.0f);
                }
                this.func_70661_as().func_75499_g();
                this.func_70671_ap().func_75650_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, 30.0f, 30.0f);
                this.targetofmyrevenge = null;
                this.active = false;
                this.field_70159_w = 0.0;
                this.field_70179_y = 0.0;
                this.ignite();
                ++this.explosionCount;
                return;
            }
            if (closestEntity != null && closestEntity.func_70089_S()) {
                this.targetofmyrevenge = closestEntity;
                this.active = true;
                if (this.func_70685_l(this.targetofmyrevenge)) {
                    float dist;
                    if (this.func_70090_H()) {
                        double slopeX = (this.targetofmyrevenge.field_70165_t - this.field_70165_t) / 4.0;
                        double slopeZ = (this.targetofmyrevenge.field_70161_v - this.field_70161_v) / 4.0;
                        double numerator = Math.sqrt(slopeX * slopeX + slopeZ * slopeZ) * 10.0;
                        this.field_70159_w = slopeX * 0.75 / numerator;
                        this.field_70179_y = slopeZ * 0.75 / numerator;
                    }
                    if ((dist = this.func_70032_d(this.targetofmyrevenge)) <= 3.0f) {
                        this.func_70661_as().func_75499_g();
                        this.func_70671_ap().func_75651_a(this.targetofmyrevenge, 30.0f, 30.0f);
                        if (this.leapCooldown > 20) {
                            if (this.leapCooldown == 21) {
                                this.func_70661_as().func_75497_a(this.targetofmyrevenge, (double)0.3f);
                                ++this.leapCooldown;
                            } else if (this.func_70661_as().func_75500_f()) {
                                List swipeEnemies = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(2.0, 0.0, 2.0).func_72317_d(-0.8, 0.0, -0.8));
                                if (!swipeEnemies.isEmpty()) {
                                    for (Entity targ : swipeEnemies) {
                                        if (!(targ instanceof EntityPlayer)) continue;
                                        this.leapCooldown = 0;
                                        this.startExplosion = true;
                                        this.explosionCount = 0;
                                        return;
                                    }
                                } else {
                                    this.leapCooldown = 0;
                                }
                            }
                        } else {
                            this.func_70661_as().func_75499_g();
                            ++this.leapCooldown;
                        }
                    }
                }
            } else {
                this.targetofmyrevenge = null;
                this.active = false;
                this.explosionCount = 0;
                this.startExplosion = false;
                this.leapCooldown = 21;
            }
        } else {
            this.igniteCount = this.hasIgnited() ? ++this.igniteCount : 0;
        }
    }

    public float getIgniteRatio() {
        float iRatio = (float)this.igniteCount / 50.0f;
        if (iRatio > 1.0f) {
            return 1.0f;
        }
        return iRatio;
    }

    public boolean hasIgnited() {
        return (Boolean)this.field_70180_af.func_187225_a(IGNITED);
    }

    public void ignite() {
        this.field_70180_af.func_187227_b(IGNITED, (Object)true);
    }

    public void unignite() {
        this.field_70180_af.func_187227_b(IGNITED, (Object)false);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("ignited", this.hasIgnited());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74767_n("ignited")) {
            this.ignite();
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K) {
            return super.func_70097_a(source, amount);
        }
        return false;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            this.dropExperience(8);
            this.func_70099_a(new ItemStack(Items.field_151070_bp, 2, 0), 0.0f);
        }
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new PathNavigateClimber((EntityLiving)this, worldIn);
    }

    public void setBesideClimbableBlock(boolean climbing) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CLIMBING);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(CLIMBING, (Object)b0);
    }

    public boolean isBesideClimbableBlock() {
        return ((Byte)this.field_70180_af.func_187225_a(CLIMBING) & 1) != 0;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    public boolean func_70617_f_() {
        return this.isBesideClimbableBlock();
    }

    public void func_70110_aj() {
    }

    public Animation[] getAnimations() {
        return ANIMATIONS;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableList.field_191186_av;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187817_fK;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187821_fM;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187819_fL;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187823_fN, 0.5f, 1.0f);
    }
}

