/*
 * Decompiled with CFR 0.152.
 */
package com.turtledove.necropolisofnostalgia.entity.enemies;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.turtledove.necropolisofnostalgia.Necropolis_of_Nostalgia;
import com.turtledove.necropolisofnostalgia.ai.AnimationBooglinComboAI;
import com.turtledove.necropolisofnostalgia.ai.AnimationBooglinFlailAI;
import com.turtledove.necropolisofnostalgia.ai.AnimationBooglinFlipAI;
import com.turtledove.necropolisofnostalgia.ai.AnimationBooglinJabAI;
import com.turtledove.necropolisofnostalgia.ai.AnimationBooglinSweepAI;
import com.turtledove.necropolisofnostalgia.ai.AnimationGenericAI;
import com.turtledove.necropolisofnostalgia.ai.EntityAIFaceOff;
import com.turtledove.necropolisofnostalgia.entity.NecropolisEntity;
import com.turtledove.necropolisofnostalgia.sound.NecropolisSounds;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.ilexiconn.llibrary.server.animation.AnimationHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityBooglin
extends NecropolisEntity {
    public static final Animation CHARGE_ANIMATION = Animation.create((int)26);
    public static final Animation SWEEP_ANIMATION = Animation.create((int)30);
    public static final Animation FLIP_ANIMATION = Animation.create((int)20);
    public static final Animation FLAIL_ANIMATION = Animation.create((int)38);
    public static final Animation COMBO_ANIMATION = Animation.create((int)36);
    public static final Animation HURT_ANIMATION = Animation.create((int)5);
    public static final Animation BLOCK_40_ANIMATION = Animation.create((int)45);
    public static final Animation BLOCK_80_ANIMATION = Animation.create((int)85);
    public static final Animation MINE_ANIMATION = Animation.create((int)26);
    private static final Animation[] ANIMATIONS = new Animation[]{CHARGE_ANIMATION, SWEEP_ANIMATION, FLIP_ANIMATION, FLAIL_ANIMATION, MINE_ANIMATION, COMBO_ANIMATION, HURT_ANIMATION, BLOCK_40_ANIMATION, BLOCK_80_ANIMATION};
    private int maxDistanceForPlayer;
    private int jabCooldown;
    private int sweepCooldown;
    private ArrayList<BlockPos> minePath;
    private boolean isMining;
    private int mineProgress;

    public EntityBooglin(World worldin) {
        super(worldin);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.func_70105_a(0.7f, 1.7f);
        this.active = true;
        this.field_70178_ae = false;
        this.targetofmyrevenge = null;
        this.struckwhileGuarding = false;
        this.maxDistanceForPlayer = 20;
        this.minePath = new ArrayList();
        this.isMining = false;
        this.mineProgress = 0;
        this.defense = 12;
        this.sDefense = 6;
        this.elementWeakness[1] = -1;
        this.elementWeakness[2] = 1;
        this.elementWeakness[3] = -1;
        this.elementWeakness[4] = -1;
        this.jabCooldown = 70;
        this.sweepCooldown = 60;
        this.setFoeType(1);
    }

    public boolean isCreatureType(EnumCreatureType type, boolean forSpawnCount) {
        if (forSpawnCount && this.func_104002_bU()) {
            return false;
        }
        return type == EnumCreatureType.MONSTER;
    }

    @Override
    public boolean func_70601_bi() {
        return super.func_70601_bi();
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(Necropolis_of_Nostalgia.CONFIG.booglinMaxHealth);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(12.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, new AnimationBooglinComboAI<EntityBooglin>(this, COMBO_ANIMATION));
        this.field_70714_bg.func_75776_a(1, new AnimationBooglinJabAI<EntityBooglin>(this, CHARGE_ANIMATION));
        this.field_70714_bg.func_75776_a(1, new AnimationBooglinSweepAI<EntityBooglin>(this, SWEEP_ANIMATION));
        this.field_70714_bg.func_75776_a(1, new AnimationBooglinFlipAI<EntityBooglin>(this, FLIP_ANIMATION));
        this.field_70714_bg.func_75776_a(1, new AnimationBooglinFlailAI<EntityBooglin>(this, FLAIL_ANIMATION));
        this.field_70714_bg.func_75776_a(1, new AnimationGenericAI<EntityBooglin>(this, MINE_ANIMATION));
        this.field_70714_bg.func_75776_a(1, new AnimationGenericAI<EntityBooglin>(this, HURT_ANIMATION));
        this.field_70714_bg.func_75776_a(1, new AnimationGenericAI<EntityBooglin>(this, BLOCK_40_ANIMATION));
        this.field_70714_bg.func_75776_a(1, new AnimationGenericAI<EntityBooglin>(this, BLOCK_80_ANIMATION));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFaceOff(this, 0.3, 3.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.1875));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 2.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void func_70071_h_() {
        block32: {
            block33: {
                block35: {
                    block31: {
                        double tRand;
                        block36: {
                            block37: {
                                float dist;
                                block34: {
                                    super.func_70071_h_();
                                    if (this.field_70170_p.field_72995_K) return;
                                    EntityPlayer closestEntity = this.field_70170_p.func_190525_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, (double)this.maxDistanceForPlayer, Predicates.and((Predicate)EntitySelectors.field_188444_d, (Predicate)EntitySelectors.func_191324_b((Entity)this)));
                                    if (closestEntity == null || !closestEntity.func_70089_S()) break block32;
                                    this.targetofmyrevenge = closestEntity;
                                    this.active = true;
                                    if (!this.func_70685_l(this.targetofmyrevenge)) break block33;
                                    dist = this.func_70032_d(this.targetofmyrevenge);
                                    this.minePath.clear();
                                    this.mineProgress = 0;
                                    this.isMining = false;
                                    if (this.func_70090_H()) {
                                        double slopeX = (this.targetofmyrevenge.field_70165_t - this.field_70165_t) / 4.0;
                                        double slopeZ = (this.targetofmyrevenge.field_70161_v - this.field_70161_v) / 4.0;
                                        double numerator = Math.sqrt(slopeX * slopeX + slopeZ * slopeZ) * 10.0;
                                        this.field_70159_w = slopeX * 0.75 / numerator;
                                        this.field_70179_y = slopeZ * 0.75 / numerator;
                                    }
                                    if (!(dist < 3.0f)) return;
                                    if (this.isMining) return;
                                    if (this.getAnimation() == NO_ANIMATION || this.getAnimation() == BLOCK_40_ANIMATION || this.getAnimation() == BLOCK_80_ANIMATION) {
                                        double speed = 0.05;
                                        this.func_70661_as().func_75497_a(this.targetofmyrevenge, speed);
                                        this.func_70671_ap().func_75651_a(this.targetofmyrevenge, 90.0f, 90.0f);
                                    } else {
                                        this.func_70661_as().func_75499_g();
                                    }
                                    if (!((double)dist >= 2.5)) break block34;
                                    if (this.getAnimation() == NO_ANIMATION && this.jabCooldown > 5) {
                                        AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, CHARGE_ANIMATION);
                                        this.jabCooldown = 0;
                                        this.sweepCooldown = 6;
                                    }
                                    break block35;
                                }
                                if (!((double)dist < 2.5) || this.getAnimation() != NO_ANIMATION || this.sweepCooldown <= 4) break block35;
                                tRand = Math.random();
                                if (!((double)this.func_110143_aJ() < (double)this.func_110138_aP() * 0.7)) break block36;
                                if (!(tRand < 0.25)) break block37;
                                AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, FLIP_ANIMATION);
                                break block31;
                            }
                            if (tRand < 0.6) {
                                AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, COMBO_ANIMATION);
                                break block31;
                            } else if (tRand < 0.7) {
                                AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, SWEEP_ANIMATION);
                                break block31;
                            } else {
                                AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, FLAIL_ANIMATION);
                            }
                            break block31;
                        }
                        if (tRand < 0.3) {
                            AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, FLIP_ANIMATION);
                        } else if (tRand < 0.6) {
                            AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, FLAIL_ANIMATION);
                        } else if (tRand < 0.8) {
                            AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, SWEEP_ANIMATION);
                        } else if (tRand < 0.9) {
                            AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, BLOCK_40_ANIMATION);
                        } else {
                            AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, BLOCK_80_ANIMATION);
                        }
                    }
                    this.sweepCooldown = 0;
                }
                if (this.getAnimation() != NO_ANIMATION) {
                    if (this.getAnimation() != FLIP_ANIMATION) return;
                }
                ++this.sweepCooldown;
                ++this.jabCooldown;
                return;
            }
            if (!Necropolis_of_Nostalgia.CONFIG.booglinGrief) return;
            if (this.func_70661_as().func_75500_f() && !this.isMining) {
                int i;
                float dist = this.func_70032_d(this.targetofmyrevenge);
                if (!(dist < 15.0f)) return;
                int bPosX = this.func_180425_c().func_177958_n();
                int bPosY = this.func_180425_c().func_177956_o();
                int bPosZ = this.func_180425_c().func_177952_p();
                int tPosX = this.targetofmyrevenge.func_180425_c().func_177958_n();
                int tPosY = this.targetofmyrevenge.func_180425_c().func_177956_o();
                int tPosZ = this.targetofmyrevenge.func_180425_c().func_177952_p();
                if (Math.abs(tPosY - bPosY) > 1) {
                    return;
                }
                if (bPosX != tPosX) {
                    for (i = 0; i < Math.abs(bPosX - tPosX); ++i) {
                        int incr = i;
                        if (bPosX - tPosX > 0) {
                            incr *= -1;
                        }
                        this.minePath.add(new BlockPos(bPosX + incr, bPosY, bPosZ));
                    }
                }
                if (bPosZ != tPosZ) {
                    for (i = 0; i < Math.abs(bPosZ - tPosZ); ++i) {
                        int incrX = Math.abs(bPosX - tPosX);
                        if (bPosX - tPosX > 0) {
                            incrX *= -1;
                        }
                        int incr = i;
                        if (bPosZ - tPosZ > 0) {
                            incr *= -1;
                        }
                        this.minePath.add(new BlockPos(bPosX + incrX, bPosY, bPosZ + incr));
                    }
                }
                this.isMining = true;
                return;
            }
            if (!this.func_70661_as().func_75500_f()) return;
            if (!this.isMining) return;
            if (this.minePath.size() <= 1) {
                this.isMining = false;
                this.minePath.clear();
                this.mineProgress = 0;
                this.func_70661_as().func_75499_g();
                return;
            }
            if (this.mineProgress > 26) {
                if (this.field_70170_p.func_175623_d(this.minePath.get(0)) && this.field_70170_p.func_175623_d(this.minePath.get(0).func_177984_a())) {
                    this.minePath.remove(0);
                    this.func_70661_as().func_75492_a((double)this.minePath.get(0).func_177958_n(), (double)this.minePath.get(0).func_177956_o(), (double)this.minePath.get(0).func_177952_p(), 0.3);
                    this.mineProgress = 27;
                    return;
                }
                this.field_70170_p.func_175698_g(this.minePath.get(0));
                this.field_70170_p.func_175698_g(this.minePath.get(0).func_177984_a());
                this.func_184185_a(SoundEvents.field_187835_fT, 1.0f, 1.0f);
                this.func_184185_a(NecropolisSounds.BOOGLIN_DRILL_1, 0.5f, 1.0f);
                this.minePath.remove(0);
                this.func_70661_as().func_75492_a((double)this.minePath.get(0).func_177958_n(), (double)this.minePath.get(0).func_177956_o(), (double)this.minePath.get(0).func_177952_p(), 0.3);
                this.mineProgress = -1;
            } else if (this.mineProgress == 0) {
                if (this.getAnimation() != NO_ANIMATION) return;
                AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, MINE_ANIMATION);
            }
            ++this.mineProgress;
            return;
        }
        this.targetofmyrevenge = null;
        this.isMining = false;
        this.minePath.clear();
        this.mineProgress = 0;
        this.active = false;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.getAnimation() == BLOCK_40_ANIMATION || this.getAnimation() == BLOCK_80_ANIMATION) {
                this.func_184185_a(SoundEvents.field_187689_f, 0.5f, 1.4f);
                return false;
            }
            if (this.getAnimation() == NO_ANIMATION) {
                AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, HURT_ANIMATION);
                this.func_184185_a(NecropolisSounds.BOOGLIN_CRY, 0.7f, 1.5f);
                this.sweepCooldown = 0;
                this.jabCooldown = 0;
            }
            return super.func_70097_a(source, amount);
        }
        return false;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            this.dropExperience(8);
            this.func_70099_a(new ItemStack(Items.field_151042_j, 8, 0), 0.0f);
        }
    }

    public Animation[] getAnimations() {
        return ANIMATIONS;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableList.field_191186_av;
    }

    protected SoundEvent func_184639_G() {
        return NecropolisSounds.BOOGLIN_AMBIENT;
    }
}

