/*
 * Decompiled with CFR 0.152.
 */
package com.turtledove.necropolisofnostalgia.entity.enemies;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.turtledove.necropolisofnostalgia.Necropolis_of_Nostalgia;
import com.turtledove.necropolisofnostalgia.ai.AnimationFuguLeapAI;
import com.turtledove.necropolisofnostalgia.ai.AnimationFuguLeapFlailAI;
import com.turtledove.necropolisofnostalgia.ai.AnimationFuguPunchAI;
import com.turtledove.necropolisofnostalgia.ai.AnimationFuguTailAI;
import com.turtledove.necropolisofnostalgia.ai.AnimationGenericAI;
import com.turtledove.necropolisofnostalgia.ai.EntityAIFaceOff;
import com.turtledove.necropolisofnostalgia.entity.NecropolisEntity;
import com.turtledove.necropolisofnostalgia.sound.NecropolisSounds;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.ilexiconn.llibrary.server.animation.AnimationHandler;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityFugu
extends NecropolisEntity {
    private int attack_cooldown;
    public static final Animation PUNCH_ANIMATION = Animation.create((int)20);
    public static final Animation LEAP_ANIMATION = Animation.create((int)44);
    public static final Animation LEAP_FLAIL_ANIMATION = Animation.create((int)52);
    public static final Animation TAIL_ANIMATION = Animation.create((int)58);
    public static final Animation HURT_ANIMATION = Animation.create((int)5);
    private static final Animation[] ANIMATIONS = new Animation[]{PUNCH_ANIMATION, LEAP_ANIMATION, LEAP_FLAIL_ANIMATION, TAIL_ANIMATION, HURT_ANIMATION};
    private int maxDistanceForPlayer;

    public EntityFugu(World worldin) {
        super(worldin);
        this.func_70105_a(0.7f, 1.7f);
        this.active = true;
        this.field_70178_ae = false;
        this.defense = 20;
        this.sDefense = 20;
        this.maxDistanceForPlayer = 20;
        this.attack_cooldown = 0;
        this.elementWeakness[1] = -1;
        this.elementWeakness[2] = -1;
        this.elementWeakness[5] = 1;
        this.elementWeakness[6] = -1;
        this.elementWeakness[7] = 1;
        this.attack_cooldown = 0;
        this.setFoeType(2);
    }

    public boolean isCreatureType(EnumCreatureType type, boolean forSpawnCount) {
        if (forSpawnCount && this.func_104002_bU()) {
            return false;
        }
        return type == EnumCreatureType.MONSTER;
    }

    @Override
    public boolean func_70601_bi() {
        return super.func_70601_bi();
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(Necropolis_of_Nostalgia.CONFIG.fuguMaxHealth);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(12.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, new AnimationFuguPunchAI<EntityFugu>(this, PUNCH_ANIMATION));
        this.field_70714_bg.func_75776_a(1, new AnimationFuguLeapAI<EntityFugu>(this, LEAP_ANIMATION));
        this.field_70714_bg.func_75776_a(1, new AnimationFuguLeapFlailAI<EntityFugu>(this, LEAP_FLAIL_ANIMATION));
        this.field_70714_bg.func_75776_a(1, new AnimationFuguTailAI<EntityFugu>(this, TAIL_ANIMATION));
        this.field_70714_bg.func_75776_a(1, new AnimationGenericAI<EntityFugu>(this, HURT_ANIMATION));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFaceOff(this, 0.1875, 5.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.1875));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 3.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.func_70606_j(this.func_110143_aJ());
        }
        if (!this.field_70170_p.field_72995_K) {
            EntityPlayer closestEntity = this.field_70170_p.func_190525_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, (double)this.maxDistanceForPlayer, Predicates.and((Predicate)EntitySelectors.field_188444_d, (Predicate)EntitySelectors.func_191324_b((Entity)this)));
            if (closestEntity != null && closestEntity.func_70089_S()) {
                if (this.targetofmyrevenge == null && this.func_70685_l((Entity)closestEntity)) {
                    this.targetofmyrevenge = closestEntity;
                    this.active = true;
                }
                if (this.targetofmyrevenge == null) {
                    return;
                }
                if (this.func_70685_l(this.targetofmyrevenge)) {
                    float dist = this.func_70032_d(this.targetofmyrevenge);
                    if (this.func_70090_H()) {
                        double slopeX = (this.targetofmyrevenge.field_70165_t - this.field_70165_t) / 4.0;
                        double slopeZ = (this.targetofmyrevenge.field_70161_v - this.field_70161_v) / 4.0;
                        double numerator = Math.sqrt(slopeX * slopeX + slopeZ * slopeZ) * 10.0;
                        this.field_70159_w = slopeX * 0.75 / numerator;
                        this.field_70179_y = slopeZ * 0.75 / numerator;
                    }
                    if (dist <= 5.0f) {
                        if (this.getAnimation() == NO_ANIMATION || this.getAnimation() == LEAP_ANIMATION && this.getAnimationTick() < 8 || this.getAnimation() == LEAP_FLAIL_ANIMATION && this.getAnimationTick() < 8) {
                            double speed = 0.05;
                            if (dist > 2.0f) {
                                speed = 0.25;
                            }
                            if (this.getAnimation() == LEAP_ANIMATION || this.getAnimation() == LEAP_FLAIL_ANIMATION) {
                                speed = 0.05;
                            }
                            this.func_70661_as().func_75497_a(this.targetofmyrevenge, speed);
                            this.func_70671_ap().func_75651_a(this.targetofmyrevenge, 90.0f, 90.0f);
                        } else {
                            this.func_70661_as().func_75499_g();
                        }
                    }
                    if (dist <= 5.0f && this.getAnimation() == NO_ANIMATION) {
                        double tRand = Math.random();
                        if (this.attack_cooldown > 4) {
                            if (dist <= 2.0f) {
                                if (tRand < 0.4) {
                                    AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, PUNCH_ANIMATION);
                                } else if (tRand < 0.8) {
                                    AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, TAIL_ANIMATION);
                                } else {
                                    AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, LEAP_FLAIL_ANIMATION);
                                }
                            } else {
                                AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, LEAP_ANIMATION);
                            }
                            this.attack_cooldown = 0;
                        }
                    }
                    if (this.getAnimation() == NO_ANIMATION) {
                        ++this.attack_cooldown;
                    }
                }
            } else {
                this.targetofmyrevenge = null;
                this.active = false;
            }
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.getAnimation() == NO_ANIMATION) {
                AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, HURT_ANIMATION);
                float pitch = (float)Math.random() / 2.0f - 0.5f;
                this.func_184185_a(NecropolisSounds.FUGU_CRY, 0.7f, 1.0f + pitch);
                this.attack_cooldown = -4;
            }
            return super.func_70097_a(source, amount);
        }
        return false;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            this.dropExperience(30);
            this.func_70099_a(new ItemStack(Items.field_151115_aP, 4, 0), 0.0f);
        }
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187876_fn, 0.7f, 1.0f);
    }

    public Animation[] getAnimations() {
        return ANIMATIONS;
    }
}

