/*
 * Decompiled with CFR 0.152.
 */
package com.turtledove.necropolisofnostalgia.entity.enemies;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.turtledove.necropolisofnostalgia.Necropolis_of_Nostalgia;
import com.turtledove.necropolisofnostalgia.ai.AnimationBlockAI;
import com.turtledove.necropolisofnostalgia.ai.AnimationGenericAI;
import com.turtledove.necropolisofnostalgia.ai.AnimationLeapStrikeAI;
import com.turtledove.necropolisofnostalgia.ai.AnimationSpinAttackAI;
import com.turtledove.necropolisofnostalgia.ai.EntityAIFaceOff;
import com.turtledove.necropolisofnostalgia.entity.NecropolisEntity;
import com.turtledove.necropolisofnostalgia.sound.NecropolisSounds;
import javax.annotation.Nullable;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.ilexiconn.llibrary.server.animation.AnimationHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityNecropolisSkeleton
extends NecropolisEntity {
    public static final Animation RETALIATE_ANIMATION = Animation.create((int)67);
    public static final Animation SWING_ANIMATION = Animation.create((int)60);
    public static final Animation LEAP_ANIMATION = Animation.create((int)40);
    public static final Animation HURT_R_ANIMATION = Animation.create((int)5);
    public static final Animation HURT_L_ANIMATION = Animation.create((int)5);
    public static final Animation BLOCK_40_ANIMATION = Animation.create((int)45);
    public static final Animation BLOCK_80_ANIMATION = Animation.create((int)85);
    public static final Animation BLOCK_160_ANIMATION = Animation.create((int)165);
    private static final Animation[] ANIMATIONS = new Animation[]{RETALIATE_ANIMATION, SWING_ANIMATION, LEAP_ANIMATION, HURT_R_ANIMATION, HURT_L_ANIMATION, BLOCK_40_ANIMATION, BLOCK_80_ANIMATION, BLOCK_160_ANIMATION};
    protected float maxDistanceForPlayer;
    protected boolean isBlocking;
    protected boolean guard_broken;
    protected static int distToPlayer = 5;
    protected int guardCoolDown;
    protected int attackCoolDown;
    private double x;
    private double y;
    private double z;
    private static final DataParameter<Boolean> AGGRO = EntityDataManager.func_187226_a(EntityNecropolisSkeleton.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityNecropolisSkeleton(World worldin) {
        super(worldin);
        this.func_70105_a(0.7f, 1.7f);
        this.active = true;
        this.field_70178_ae = false;
        this.isBlocking = false;
        this.maxDistanceForPlayer = 20.0f;
        this.targetofmyrevenge = null;
        this.struckwhileGuarding = false;
        this.attackCoolDown = 0;
        this.elementWeakness[4] = -1;
        this.elementWeakness[6] = -1;
        this.elementWeakness[7] = 1;
        this.guard_broken = false;
        this.guardCoolDown = 0;
        this.defense = 5;
        this.sDefense = 3;
        this.needsDarkness = true;
    }

    public boolean isCreatureType(EnumCreatureType type, boolean forSpawnCount) {
        if (forSpawnCount && this.func_104002_bU()) {
            return false;
        }
        return type == EnumCreatureType.MONSTER;
    }

    @Override
    public boolean func_70601_bi() {
        return super.func_70601_bi();
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(Necropolis_of_Nostalgia.CONFIG.skeletonMaxHealth);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(12.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(AGGRO, (Object)false);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, new AnimationLeapStrikeAI<EntityNecropolisSkeleton>(this, LEAP_ANIMATION));
        this.field_70714_bg.func_75776_a(1, new AnimationSpinAttackAI<EntityNecropolisSkeleton>(this, SWING_ANIMATION));
        this.field_70714_bg.func_75776_a(1, new AnimationBlockAI<EntityNecropolisSkeleton>(this, RETALIATE_ANIMATION));
        this.field_70714_bg.func_75776_a(1, new AnimationGenericAI<EntityNecropolisSkeleton>(this, HURT_R_ANIMATION));
        this.field_70714_bg.func_75776_a(1, new AnimationGenericAI<EntityNecropolisSkeleton>(this, HURT_L_ANIMATION));
        this.field_70714_bg.func_75776_a(1, new AnimationGenericAI<EntityNecropolisSkeleton>(this, BLOCK_40_ANIMATION));
        this.field_70714_bg.func_75776_a(1, new AnimationGenericAI<EntityNecropolisSkeleton>(this, BLOCK_80_ANIMATION));
        this.field_70714_bg.func_75776_a(1, new AnimationGenericAI<EntityNecropolisSkeleton>(this, BLOCK_160_ANIMATION));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFaceOff(this, 0.1875, distToPlayer));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.1875));
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.func_70606_j(this.func_110143_aJ());
        }
        if (!this.field_70170_p.field_72995_K) {
            EntityPlayer closestEntity = this.field_70170_p.func_190525_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, (double)this.maxDistanceForPlayer, Predicates.and((Predicate)EntitySelectors.field_188444_d, (Predicate)EntitySelectors.func_191324_b((Entity)this)));
            if (closestEntity != null && closestEntity.func_70089_S()) {
                this.setAggro(true);
                if (this.targetofmyrevenge == null && this.func_70685_l((Entity)closestEntity)) {
                    this.func_184185_a(NecropolisSounds.SKELETON_DETECT, 1.0f, 1.0f);
                    this.targetofmyrevenge = closestEntity;
                    this.active = true;
                }
                if (this.targetofmyrevenge == null) {
                    return;
                }
                if (this.func_70685_l(this.targetofmyrevenge)) {
                    float dist = this.func_70032_d(this.targetofmyrevenge);
                    if (this.func_70090_H()) {
                        double slopeX = (this.targetofmyrevenge.field_70165_t - this.field_70165_t) / 4.0;
                        double slopeZ = (this.targetofmyrevenge.field_70161_v - this.field_70161_v) / 4.0;
                        double numerator = Math.sqrt(slopeX * slopeX + slopeZ * slopeZ) * 10.0;
                        this.field_70159_w = slopeX * 0.75 / numerator;
                        this.field_70179_y = slopeZ * 0.75 / numerator;
                    }
                    if (dist <= (float)distToPlayer) {
                        if (this.getAnimation() == NO_ANIMATION || this.getAnimation() == BLOCK_40_ANIMATION || this.getAnimation() == BLOCK_80_ANIMATION || this.getAnimation() == BLOCK_160_ANIMATION) {
                            double speed = 0.1875;
                            if (dist < 2.0f) {
                                speed = 0.01;
                            }
                            this.func_70661_as().func_75497_a(this.targetofmyrevenge, speed);
                            this.func_70671_ap().func_75651_a(this.targetofmyrevenge, 90.0f, 90.0f);
                        } else {
                            this.func_70661_as().func_75499_g();
                        }
                    }
                    if (dist <= (float)distToPlayer && this.attackCoolDown >= 5 && this.getAnimation() == NO_ANIMATION) {
                        if (dist >= (float)(distToPlayer - 1) && dist <= (float)distToPlayer && this.func_70685_l(this.targetofmyrevenge)) {
                            this.isBlocking = false;
                            double tRand = Math.random();
                            if (tRand < 0.4) {
                                if (tRand < 0.1) {
                                    AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, BLOCK_40_ANIMATION);
                                } else if (tRand < 0.3) {
                                    AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, BLOCK_80_ANIMATION);
                                } else {
                                    AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, BLOCK_160_ANIMATION);
                                }
                            } else {
                                AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, LEAP_ANIMATION);
                            }
                        } else {
                            this.isBlocking = false;
                            if (Math.random() < 0.3) {
                                AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, BLOCK_80_ANIMATION);
                            } else if (Math.random() < 0.6) {
                                AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, RETALIATE_ANIMATION);
                            } else {
                                AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, SWING_ANIMATION);
                            }
                            this.attackCoolDown = 0;
                        }
                    }
                    if (this.getAnimation() == NO_ANIMATION) {
                        ++this.attackCoolDown;
                    }
                }
            } else {
                this.setAggro(false);
                this.targetofmyrevenge = null;
                this.active = false;
                this.isBlocking = false;
                this.attackCoolDown = 0;
            }
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K) {
            if (source.equals(DamageSource.field_76369_e)) {
                return false;
            }
            if (this.getAnimation() == BLOCK_40_ANIMATION || this.getAnimation() == BLOCK_80_ANIMATION || this.getAnimation() == BLOCK_160_ANIMATION) {
                this.func_184185_a(SoundEvents.field_187689_f, 0.5f, 1.4f);
                return false;
            }
            if (this.getAnimation() == NO_ANIMATION) {
                this.func_184185_a(NecropolisSounds.SKELETON_DETECT, 0.5f, 1.0f);
                this.attackCoolDown = 0;
                if (Math.random() < 0.5) {
                    AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, HURT_L_ANIMATION);
                } else {
                    AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, HURT_R_ANIMATION);
                }
            }
            return super.func_70097_a(source, Math.max(1.0f, amount));
        }
        return false;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (cause.func_76346_g() instanceof EntityCreeper) {
            EntityCreeper entitycreeper = (EntityCreeper)cause.func_76346_g();
            if (entitycreeper.func_70830_n() && entitycreeper.func_70650_aV()) {
                entitycreeper.func_175493_co();
                this.func_70099_a(new ItemStack(Items.field_151144_bL, 1, 0), 0.0f);
            }
        } else if (!this.field_70170_p.field_72995_K) {
            this.dropExperience(12);
            this.func_70099_a(new ItemStack(Items.field_151103_aS, 2, 0), 0.0f);
        }
    }

    public Animation[] getAnimations() {
        return ANIMATIONS;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableList.field_186385_aj;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187854_fc;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187856_fd;
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.field_187868_fj;
    }

    public void setAggro(boolean isActive) {
        this.func_184212_Q().func_187227_b(AGGRO, (Object)isActive);
    }

    public boolean isAggro() {
        return (Boolean)this.func_184212_Q().func_187225_a(AGGRO);
    }
}

