/*
 * Decompiled with CFR 0.152.
 */
package com.turtledove.necropolisofnostalgia.entity.enemies;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.turtledove.necropolisofnostalgia.Necropolis_of_Nostalgia;
import com.turtledove.necropolisofnostalgia.ai.AnimationGenericAI;
import com.turtledove.necropolisofnostalgia.ai.AnimationSpiderLeap;
import com.turtledove.necropolisofnostalgia.ai.AnimationSpiderRampage;
import com.turtledove.necropolisofnostalgia.ai.AnimationSpiderRearJab;
import com.turtledove.necropolisofnostalgia.ai.EntityAISpiderFaceOff;
import com.turtledove.necropolisofnostalgia.entity.NecropolisEntity;
import com.turtledove.necropolisofnostalgia.entity.enemies.EntityBabyNecropolisSpider;
import com.turtledove.necropolisofnostalgia.sound.NecropolisSounds;
import javax.annotation.Nullable;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.ilexiconn.llibrary.server.animation.AnimationHandler;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateClimber;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityNecropolisSpider
extends NecropolisEntity {
    public static final Animation HANG_ANIMATION = Animation.create((int)5);
    public static final Animation RAMPAGE_ANIMATION = Animation.create((int)10);
    public static final Animation REAR_JAB_ANIMATION = Animation.create((int)26);
    public static final Animation LEAP_ANIMATION = Animation.create((int)18);
    public static final Animation HURT_ANIMATION = Animation.create((int)5);
    private static final Animation[] ANIMATIONS = new Animation[]{HANG_ANIMATION, RAMPAGE_ANIMATION, REAR_JAB_ANIMATION, LEAP_ANIMATION, HURT_ANIMATION};
    private int maxDistanceForPlayer;
    private BlockPos hangPos;
    private boolean isHanging;
    private int hangProgress;
    public boolean isAnimationEnded;
    private int attack_cooldown;
    private boolean laidEggs;
    private static final DataParameter<Byte> CLIMBING = EntityDataManager.func_187226_a(EntityNecropolisSpider.class, (DataSerializer)DataSerializers.field_187191_a);

    public EntityNecropolisSpider(World worldin) {
        super(worldin);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.func_70105_a(0.8f, 0.8f);
        this.active = true;
        this.field_70178_ae = false;
        this.targetofmyrevenge = null;
        this.struckwhileGuarding = false;
        this.maxDistanceForPlayer = 20;
        this.isHanging = false;
        this.hangProgress = 0;
        this.laidEggs = false;
        this.defense = 11;
        this.sDefense = 10;
        this.attack_cooldown = 0;
        this.isAnimationEnded = false;
        this.elementWeakness[1] = 1;
        this.elementWeakness[4] = -1;
        this.elementWeakness[6] = -1;
        this.elementWeakness[7] = 1;
        this.setFoeType(1);
    }

    public boolean isCreatureType(EnumCreatureType type, boolean forSpawnCount) {
        if (forSpawnCount && this.func_104002_bU()) {
            return false;
        }
        return type == EnumCreatureType.MONSTER;
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("laidEggs", this.laidEggs);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.laidEggs = compound.func_74767_n("laidEggs");
    }

    @Override
    public boolean func_70601_bi() {
        return super.func_70601_bi();
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(Necropolis_of_Nostalgia.CONFIG.spiderMaxHealth);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(12.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_70105_a(0.8f, 0.8f);
        this.field_70180_af.func_187214_a(CLIMBING, (Object)0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, new AnimationGenericAI<EntityNecropolisSpider>(this, HANG_ANIMATION));
        this.field_70714_bg.func_75776_a(1, new AnimationGenericAI<EntityNecropolisSpider>(this, HURT_ANIMATION));
        this.field_70714_bg.func_75776_a(1, new AnimationSpiderLeap<EntityNecropolisSpider>(this, LEAP_ANIMATION));
        this.field_70714_bg.func_75776_a(1, new AnimationSpiderRearJab<EntityNecropolisSpider>(this, REAR_JAB_ANIMATION));
        this.field_70714_bg.func_75776_a(1, new AnimationSpiderRampage<EntityNecropolisSpider>(this, RAMPAGE_ANIMATION));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAISpiderFaceOff(this, 0.375, 4.0));
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.setBesideClimbableBlock(this.field_70123_F);
            EntityPlayer closestEntity = this.field_70170_p.func_190525_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, (double)this.maxDistanceForPlayer, Predicates.and((Predicate)EntitySelectors.field_188444_d, (Predicate)EntitySelectors.func_191324_b((Entity)this)));
            if (closestEntity != null && closestEntity.func_70089_S()) {
                this.doSpiderLogic((Entity)closestEntity);
            } else if (this.isHanging) {
                AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, HANG_ANIMATION);
                if (this.hangProgress == 0) {
                    this.func_189654_d(true);
                    this.field_70159_w = 0.0;
                    this.field_70179_y = 0.0;
                    this.field_70181_x = 0.05;
                    ++this.hangProgress;
                } else if (this.func_180425_c().equals((Object)this.hangPos)) {
                    this.field_70159_w = 0.0;
                    this.field_70179_y = 0.0;
                    this.field_70181_x = 0.0;
                    if (this.field_70170_p.func_175623_d(this.hangPos.func_177984_a())) {
                        this.isHanging = false;
                        this.func_189654_d(false);
                        this.hangProgress = 0;
                    }
                } else {
                    this.field_70159_w = 0.0;
                    this.field_70179_y = 0.0;
                    this.field_70181_x = 0.05;
                    ++this.hangProgress;
                }
            } else {
                this.targetofmyrevenge = null;
                this.active = false;
                this.func_70661_as().func_75499_g();
                this.func_189654_d(false);
                this.attack_cooldown = 0;
                this.hangProgress = 0;
                if (!this.isHanging) {
                    this.isHanging = this.canHangHere();
                }
            }
            this.isAnimationEnded = false;
        }
    }

    private void doSpiderLogic(Entity closestEntity) {
        this.targetofmyrevenge = (EntityPlayer)closestEntity;
        if (this.func_70685_l(this.targetofmyrevenge)) {
            int i;
            int numChilds;
            float dist = this.func_70032_d(this.targetofmyrevenge);
            if (this.isHanging) {
                if (dist <= 4.0f) {
                    if (!this.laidEggs) {
                        numChilds = (int)(Math.random() * 3.0 + 2.0);
                        for (i = 0; i < numChilds; ++i) {
                            EntityBabyNecropolisSpider child_1 = new EntityBabyNecropolisSpider(this.field_70170_p);
                            child_1.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                            this.field_70170_p.func_72838_d((Entity)child_1);
                        }
                    }
                    this.laidEggs = true;
                    this.func_189654_d(false);
                    this.hangProgress = 0;
                    this.isHanging = false;
                } else {
                    AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, HANG_ANIMATION);
                }
            }
            if (this.func_70090_H()) {
                double slopeX = (this.targetofmyrevenge.field_70165_t - this.field_70165_t) / 4.0;
                double slopeZ = (this.targetofmyrevenge.field_70161_v - this.field_70161_v) / 4.0;
                double numerator = Math.sqrt(slopeX * slopeX + slopeZ * slopeZ) * 10.0;
                this.field_70159_w = slopeX * 0.75 / numerator;
                this.field_70179_y = slopeZ * 0.75 / numerator;
            }
            if (dist <= 4.0f) {
                if (!this.laidEggs) {
                    numChilds = (int)(Math.random() * 3.0 + 2.0);
                    for (i = 0; i < numChilds; ++i) {
                        EntityBabyNecropolisSpider child_1 = new EntityBabyNecropolisSpider(this.field_70170_p);
                        child_1.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                        this.field_70170_p.func_72838_d((Entity)child_1);
                    }
                }
                if (this.getAnimation() == NO_ANIMATION) {
                    double speed = 0.05;
                    this.func_70661_as().func_75497_a(this.targetofmyrevenge, speed);
                    this.func_70671_ap().func_75651_a(this.targetofmyrevenge, 90.0f, 90.0f);
                } else {
                    this.func_70661_as().func_75499_g();
                }
                if (this.getAnimation() == NO_ANIMATION && this.attack_cooldown > 4) {
                    double tRand = Math.random();
                    if (tRand < 0.2) {
                        AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, RAMPAGE_ANIMATION);
                    } else if (tRand < 0.6) {
                        AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, LEAP_ANIMATION);
                    } else {
                        AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, REAR_JAB_ANIMATION);
                    }
                    this.attack_cooldown = 0;
                }
                this.laidEggs = true;
            }
            if (this.getAnimation() == NO_ANIMATION) {
                ++this.attack_cooldown;
            }
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.getAnimation() == NO_ANIMATION) {
                AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, HURT_ANIMATION);
                this.func_184185_a(NecropolisSounds.SPIDER_CRY, 0.5f, 1.0f);
                this.attack_cooldown = 0;
            }
            return super.func_70097_a(source, amount);
        }
        return false;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            this.dropExperience(8);
            this.func_70099_a(new ItemStack(Items.field_151007_F, 7, 0), 0.0f);
        }
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new PathNavigateClimber((EntityLiving)this, worldIn);
    }

    public boolean canHangHere() {
        int ceiling = 40;
        if (this.field_70163_u > (double)(ceiling - 4)) {
            return false;
        }
        if (this.targetofmyrevenge != null) {
            return false;
        }
        int i = 0;
        for (i = 0; i < 8; ++i) {
            if (this.field_70170_p.func_175623_d(this.func_180425_c().func_177981_b(i))) continue;
            --i;
            break;
        }
        if (i < 4 || i == 8) {
            return false;
        }
        if (this.field_70163_u + (double)i > (double)ceiling) {
            return false;
        }
        this.hangPos = this.func_180425_c().func_177981_b(i);
        return true;
    }

    public void setBesideClimbableBlock(boolean climbing) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CLIMBING);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(CLIMBING, (Object)b0);
    }

    public boolean isBesideClimbableBlock() {
        return ((Byte)this.field_70180_af.func_187225_a(CLIMBING) & 1) != 0;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    public boolean func_70617_f_() {
        return this.isBesideClimbableBlock();
    }

    public void func_70110_aj() {
    }

    public Animation[] getAnimations() {
        return ANIMATIONS;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableList.field_191186_av;
    }

    protected SoundEvent func_184639_G() {
        return NecropolisSounds.SPIDER_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187821_fM;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187819_fL;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187823_fN, 0.5f, 1.0f);
    }
}

