/*
 * Decompiled with CFR 0.152.
 */
package com.turtledove.necropolisofnostalgia.entity.enemies;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.turtledove.necropolisofnostalgia.Necropolis_of_Nostalgia;
import com.turtledove.necropolisofnostalgia.ai.AnimationGenericAI;
import com.turtledove.necropolisofnostalgia.ai.AnimationVBDiveAI;
import com.turtledove.necropolisofnostalgia.ai.EntityAIBatFly;
import com.turtledove.necropolisofnostalgia.entity.NecropolisEntity;
import com.turtledove.necropolisofnostalgia.sound.NecropolisSounds;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.ilexiconn.llibrary.server.animation.AnimationHandler;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityVampireBat
extends NecropolisEntity {
    public static final Animation DIVE_ANIMATION = Animation.create((int)20);
    public static final Animation HURT_ANIMATION = Animation.create((int)15);
    private static final Animation[] ANIMATIONS = new Animation[]{DIVE_ANIMATION, HURT_ANIMATION};
    protected float maxDistanceForPlayer;
    private double tSpeed;
    private BlockPos spawnPosition;
    private int diveCooldown;

    public EntityVampireBat(World worldin) {
        super(worldin);
        this.func_70105_a(0.6f, 0.6f);
        this.active = true;
        this.field_70178_ae = false;
        this.maxDistanceForPlayer = 20.0f;
        this.targetofmyrevenge = null;
        this.struckwhileGuarding = false;
        this.tSpeed = 1.125;
        this.elementWeakness[6] = -1;
        this.elementWeakness[7] = 1;
        this.elementWeakness[4] = -1;
        this.defense = 8;
        this.sDefense = 7;
        this.func_189654_d(true);
        this.spawnPosition = this.func_180425_c();
        this.diveCooldown = 0;
        this.setFoeType(1);
    }

    public boolean isCreatureType(EnumCreatureType type, boolean forSpawnCount) {
        if (forSpawnCount && this.func_104002_bU()) {
            return false;
        }
        return type == EnumCreatureType.MONSTER;
    }

    @Override
    public boolean func_70601_bi() {
        return super.func_70601_bi();
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(Necropolis_of_Nostalgia.CONFIG.vampireBatMaxHealth);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(12.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_70105_a(0.6f, 0.6f);
    }

    protected void func_184651_r() {
        this.tSpeed = 1.125;
        this.field_70714_bg.func_75776_a(1, new AnimationVBDiveAI<EntityVampireBat>(this, DIVE_ANIMATION));
        this.field_70714_bg.func_75776_a(1, new AnimationGenericAI<EntityVampireBat>(this, HURT_ANIMATION));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIBatFly(this, this.tSpeed, 5.0));
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.func_70606_j(this.func_110143_aJ());
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_70674_bp();
            if (this.field_70173_aa % 45 == 0) {
                this.func_184185_a(SoundEvents.field_192796_et, 0.3f, 0.6f);
            }
            EntityPlayer closestEntity = this.field_70170_p.func_190525_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, (double)this.maxDistanceForPlayer, Predicates.and((Predicate)EntitySelectors.field_188444_d, (Predicate)EntitySelectors.func_191324_b((Entity)this)));
            float f = 0.91f;
            if (this.getAnimation() != HURT_ANIMATION) {
                if (this.field_70122_E) {
                    BlockPos underPos = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v));
                    IBlockState underState = this.field_70170_p.func_180495_p(underPos);
                    f = underState.func_177230_c().getSlipperiness(underState, (IBlockAccess)this.field_70170_p, underPos, (Entity)this) * 0.91f;
                }
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= (double)f;
                this.field_70181_x *= (double)f;
                this.field_70179_y *= (double)f;
            }
            if (!this.field_70170_p.func_175623_d(this.func_180425_c().func_177977_b()) && this.getAnimation() != HURT_ANIMATION) {
                this.field_70181_x = 0.3f;
            }
            if (closestEntity != null && closestEntity.func_70089_S()) {
                float dist;
                this.targetofmyrevenge = closestEntity;
                this.active = true;
                if (this.func_70685_l(this.targetofmyrevenge) && (dist = this.func_70032_d(this.targetofmyrevenge)) < 5.0f && this.getAnimation() == NO_ANIMATION) {
                    if (this.diveCooldown > 10) {
                        AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, DIVE_ANIMATION);
                        this.diveCooldown = 0;
                    }
                    ++this.diveCooldown;
                }
            } else {
                this.targetofmyrevenge = null;
                this.active = false;
                if (!(this.spawnPosition == null || this.field_70170_p.func_175623_d(this.spawnPosition) && this.spawnPosition.func_177956_o() >= 1)) {
                    this.spawnPosition = null;
                }
                if (this.spawnPosition == null || this.field_70146_Z.nextInt(30) == 0 || this.spawnPosition.func_177954_c((double)((int)this.field_70165_t), (double)((int)this.field_70163_u), (double)((int)this.field_70161_v)) < 4.0) {
                    this.spawnPosition = new BlockPos((int)this.field_70165_t + this.field_70146_Z.nextInt(7) - this.field_70146_Z.nextInt(7), (int)this.field_70163_u + this.field_70146_Z.nextInt(6) - 2, (int)this.field_70161_v + this.field_70146_Z.nextInt(7) - this.field_70146_Z.nextInt(7));
                }
                double d0 = (double)this.spawnPosition.func_177958_n() + 0.5 - this.field_70165_t;
                double d1 = (double)this.spawnPosition.func_177956_o() + 0.1 - this.field_70163_u;
                double d2 = (double)this.spawnPosition.func_177952_p() + 0.5 - this.field_70161_v;
                this.field_70159_w += (Math.signum(d0) * 0.5 - this.field_70159_w) * (double)0.1f;
                this.field_70181_x += (Math.signum(d1) * (double)0.7f - this.field_70181_x) * (double)0.1f;
                this.field_70179_y += (Math.signum(d2) * 0.5 - this.field_70179_y) * (double)0.1f;
                float g = (float)(MathHelper.func_181159_b((double)this.field_70179_y, (double)this.field_70159_w) * 57.29577951308232) - 90.0f;
                float f1 = MathHelper.func_76142_g((float)(g - this.field_70177_z));
                this.field_191988_bg = 0.5f;
                this.field_70177_z += f1;
            }
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K) {
            if (source.equals(DamageSource.field_76379_h)) {
                return false;
            }
            if (this.getAnimation() == NO_ANIMATION) {
                AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, HURT_ANIMATION);
                this.func_184185_a(NecropolisSounds.BAT_AMBIENT, 0.7f, 0.7f);
                this.diveCooldown = 0;
            }
            return super.func_70097_a(source, amount);
        }
        return false;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            this.dropExperience(24);
            this.func_70099_a(new ItemStack(Items.field_151116_aA, 4, 0), 0.0f);
        }
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    public boolean func_145773_az() {
        return true;
    }

    public Animation[] getAnimations() {
        return ANIMATIONS;
    }

    protected SoundEvent func_184639_G() {
        return NecropolisSounds.BAT_AMBIENT;
    }
}

