/*
 * Decompiled with CFR 0.152.
 */
package com.turtledove.necropolisofnostalgia.packets;

import com.turtledove.necropolisofnostalgia.packets.Log;
import com.turtledove.necropolisofnostalgia.packets.MessageHandler;
import com.turtledove.necropolisofnostalgia.packets.Player.PlayerParticlePacket;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public final class PacketHandler {
    private byte nextPacketID = 0;
    private SimpleNetworkWrapper wrapper;
    private String channelid;

    public PacketHandler(String channelid) {
        this.wrapper = NetworkRegistry.INSTANCE.newSimpleChannel(channelid);
        this.channelid = channelid;
    }

    public void registerPackets() {
        this.registerPacket(PlayerParticlePacket.class, new PlayerParticlePacket.Handler(), Side.CLIENT);
    }

    public boolean registerPacket(Class<? extends IMessage> packetClass, MessageHandler messageHandler, Side target) {
        if (this.nextPacketID == -1) {
            throw new IllegalStateException("Too many packets registered for channel " + this.channelid);
        }
        this.wrapper.registerMessage((IMessageHandler)messageHandler, packetClass, (int)this.nextPacketID, target);
        Log.debug("Registered packet class %s with handler class %s for the channel %s. Send direction: to %s. The discriminator is %s.", packetClass.getSimpleName(), messageHandler.getClass().getSimpleName(), this.channelid, target.name().toLowerCase(), this.nextPacketID);
        this.nextPacketID = (byte)(this.nextPacketID + 1);
        return true;
    }

    public void sendToAll(IMessage message) {
        this.wrapper.sendToAll(message);
    }

    public void sendTo(IMessage message, EntityPlayerMP player) {
        if (player.field_71135_a != null) {
            this.wrapper.sendTo(message, player);
        }
    }

    public void sendToAllAround(IMessage message, NetworkRegistry.TargetPoint point) {
        this.wrapper.sendToAllAround(message, point);
    }

    public void sendToAllAround(IMessage message, int dimension, double x, double y, double z, double range) {
        this.sendToAllAround(message, new NetworkRegistry.TargetPoint(dimension, x, y, z, range));
    }

    public void sendToAllAround(IMessage message, Entity entity, double range) {
        this.sendToAllAround(message, entity.field_71093_bK, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, range);
    }

    public void sendToServer(IMessage message) {
        this.wrapper.sendToServer(message);
    }

    public void sendToAllTracking(IMessage message, Entity entity) {
        this.wrapper.sendToAllTracking(message, entity);
    }
}

