/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.magistuarmory.effects.LacerationEffect;
import com.magistuarmory.item.ModItemTier;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class MedievalWeaponItem
extends SwordItem {
    private float baseAttackDamage;
    private float baseAttackSpeed;
    private boolean isSilver = false;
    private boolean isFlamebladed = false;

    public MedievalWeaponItem(String unlocName, Item.Properties build, IItemTier material, float baseAttackDamage, float materialFactor, float baseAttackSpeed) {
        super(material, 0, 0.0f, build);
        this.setRegistryName(unlocName);
        this.baseAttackDamage = baseAttackDamage + materialFactor * material.func_200929_c();
        this.baseAttackSpeed = baseAttackSpeed;
        if (this.func_200891_e() instanceof ModItemTier && ((ModItemTier)this.func_200891_e()).getMaterialName().equals("silver")) {
            this.isSilver = true;
        }
        if (unlocName.split("_")[1].equals("flamebladedsword")) {
            this.isFlamebladed = true;
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        if (slot == EquipmentSlotType.MAINHAND) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.baseAttackDamage, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)this.baseAttackSpeed, AttributeModifier.Operation.ADDITION));
            return builder.build();
        }
        return super.getAttributeModifiers(slot, stack);
    }

    public boolean func_77644_a(ItemStack p_77644_1_, LivingEntity p_77644_2_, LivingEntity p_77644_3_) {
        if (this.isSilver && p_77644_2_.func_70668_bt().equals(CreatureAttribute.field_223223_b_)) {
            p_77644_2_.func_70097_a(DamageSource.field_76376_m, this.baseAttackDamage + 3.0f);
        }
        if (this.isFlamebladed) {
            float damage = (float)((double)this.baseAttackDamage * (1.0 - Math.min(20.0, Math.max((double)(p_77644_2_.func_70658_aO() / 5), (double)p_77644_2_.func_70658_aO() - (double)this.baseAttackDamage / (p_77644_2_.func_233637_b_(Attributes.field_233827_j_) / 4.0 + 2.0))) / 25.0));
            p_77644_2_.func_195064_c(new EffectInstance((Effect)LacerationEffect.LACERATION.setDamage(damage), 300, 1, true, true, true));
        }
        return super.func_77644_a(p_77644_1_, p_77644_2_, p_77644_3_);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (this.isSilver) {
            tooltip.add((ITextComponent)new TranslationTextComponent("silvertools.hurt").func_240699_a_(TextFormatting.GREEN));
        }
        if (this.isFlamebladed) {
            tooltip.add((ITextComponent)new TranslationTextComponent("flamebladed.hurt").func_240699_a_(TextFormatting.BLUE));
        }
    }
}

