/*
 * Decompiled with CFR 0.152.
 */
package com.teamderpy.shouldersurfing.client;

import com.teamderpy.shouldersurfing.client.ShoulderRenderer;
import com.teamderpy.shouldersurfing.config.Config;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class ShoulderHelper {
    private static final ResourceLocation PULL_PROPERTY = new ResourceLocation("pull");
    private static final ResourceLocation THROWING_PROPERTY = new ResourceLocation("throwing");
    private static final ResourceLocation CHARGED_PROPERTY = new ResourceLocation("charged");

    public static ShoulderLook shoulderSurfingLook(Camera camera, Entity entity, float partialTicks, double distanceSq) {
        Vec3 cameraOffset = ShoulderHelper.calcCameraOffset(camera, ShoulderRenderer.getInstance().getCameraDistance());
        Vec3 headOffset = ShoulderHelper.calcRayTraceHeadOffset(camera, cameraOffset);
        Vec3 cameraPos = entity.m_20299_(partialTicks).m_82549_(cameraOffset);
        Vec3 viewVector = entity.m_20252_(partialTicks);
        if (Config.CLIENT.limitPlayerReach() && headOffset.m_82556_() < distanceSq) {
            distanceSq -= headOffset.m_82556_();
        }
        double distance = Math.sqrt(distanceSq) + cameraOffset.m_82554_(headOffset);
        Vec3 traceEnd = cameraPos.m_82549_(viewVector.m_82490_(distance));
        return new ShoulderLook(cameraPos, traceEnd, headOffset);
    }

    public static Vec3 calcCameraOffset(@Nonnull Camera camera, double distance) {
        double dX = (double)camera.m_253028_().x() * Config.CLIENT.getOffsetY() + (double)camera.m_252775_().x() * Config.CLIENT.getOffsetX() + (double)camera.m_253058_().x() * -Config.CLIENT.getOffsetZ();
        double dY = (double)camera.m_253028_().y() * Config.CLIENT.getOffsetY() + (double)camera.m_252775_().y() * Config.CLIENT.getOffsetX() + (double)camera.m_253058_().y() * -Config.CLIENT.getOffsetZ();
        double dZ = (double)camera.m_253028_().z() * Config.CLIENT.getOffsetY() + (double)camera.m_252775_().z() * Config.CLIENT.getOffsetX() + (double)camera.m_253058_().z() * -Config.CLIENT.getOffsetZ();
        return new Vec3(dX, dY, dZ).m_82541_().m_82490_(distance);
    }

    public static Vec3 calcRayTraceHeadOffset(@Nonnull Camera camera, Vec3 cameraOffset) {
        Vec3 lookVector = new Vec3(camera.m_253058_());
        return ShoulderHelper.calcPlaneWithLineIntersection(Vec3.f_82478_, lookVector, cameraOffset, lookVector);
    }

    public static Vec3 calcPlaneWithLineIntersection(Vec3 planePoint, Vec3 planeNormal, Vec3 linePoint, Vec3 lineNormal) {
        double distance = (planeNormal.m_82526_(planePoint) - planeNormal.m_82526_(linePoint)) / planeNormal.m_82526_(lineNormal);
        return linePoint.m_82549_(lineNormal.m_82490_(distance));
    }

    public static boolean isHoldingSpecialItem() {
        Entity cameraEntity = Minecraft.m_91087_().f_91075_;
        if (cameraEntity instanceof Player) {
            Player player = (Player)cameraEntity;
            List<? extends String> overrides = Config.CLIENT.getAdaptiveCrosshairItems();
            Item current = player.m_21211_().m_41720_();
            if (ItemProperties.m_117829_((Item)current, (ResourceLocation)PULL_PROPERTY) != null || ItemProperties.m_117829_((Item)current, (ResourceLocation)THROWING_PROPERTY) != null) {
                return true;
            }
            if (overrides.contains(BuiltInRegistries.f_257033_.m_7981_((Object)current).toString())) {
                return true;
            }
            for (ItemStack stack : player.m_6167_()) {
                Item item = stack.m_41720_();
                if (ItemProperties.m_117829_((Item)item, (ResourceLocation)CHARGED_PROPERTY) != null) {
                    return true;
                }
                if (!overrides.contains(BuiltInRegistries.f_257033_.m_7981_((Object)item).toString())) continue;
                return true;
            }
        }
        return false;
    }

    public record ShoulderLook(Vec3 cameraPos, Vec3 traceEndPos, Vec3 headOffset) {
    }
}

