/*
 * Decompiled with CFR 0.152.
 */
package com.teamderpy.shouldersurfing.compatibility;

import com.teamderpy.shouldersurfing.client.ShoulderHelper;
import com.teamderpy.shouldersurfing.client.ShoulderInstance;
import com.teamderpy.shouldersurfing.config.Config;
import java.util.function.Predicate;
import mcp.mobius.waila.api.IObjectPicker;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.plugin.core.pick.ObjectPicker;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ShoulderSurfingWailaPlugin
implements IWailaPlugin {
    public void register(IRegistrar registrar) {
        registrar.replacePicker((IObjectPicker)new ShoulderSurfingObjectPicker());
    }

    private static class ShoulderSurfingObjectPicker
    implements IObjectPicker {
        private ShoulderSurfingObjectPicker() {
        }

        public HitResult pick(Minecraft mc, double maxDistance, float partialTick, IPluginConfig config) {
            if (ShoulderInstance.getInstance().doShoulderSurfing() && !Config.CLIENT.getCrosshairType().isDynamic()) {
                EntityHitResult entityHit;
                Entity camera = mc.m_91288_();
                if (camera == null) {
                    return IObjectPicker.MISS;
                }
                ShoulderHelper.ShoulderLook look = ShoulderHelper.shoulderSurfingLook(mc.f_91063_.m_109153_(), camera, partialTick, maxDistance * maxDistance);
                ClipContext.Fluid fluidContext = config.getBoolean(WailaConstants.CONFIG_SHOW_FLUID) ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE;
                BlockHitResult blockHit = camera.f_19853_.m_45547_(new ClipContext(look.cameraPos(), look.traceEndPos(), ClipContext.Block.OUTLINE, fluidContext, camera));
                if (config.getBoolean(WailaConstants.CONFIG_SHOW_ENTITY) && (entityHit = ProjectileUtil.m_37287_((Entity)camera, (Vec3)look.cameraPos(), (Vec3)look.traceEndPos(), (AABB)new AABB(look.cameraPos(), look.traceEndPos()), (Predicate)EntitySelector.f_20402_, (double)0.0)) != null) {
                    if (HitResult.Type.MISS.equals((Object)blockHit.m_6662_())) {
                        return entityHit;
                    }
                    double blockDistance = blockHit.m_82450_().m_82557_(look.cameraPos());
                    double entityDistance = entityHit.m_82450_().m_82557_(look.cameraPos());
                    if (entityDistance < blockDistance) {
                        return entityHit;
                    }
                }
                return blockHit;
            }
            return ObjectPicker.INSTANCE.pick(mc, maxDistance, partialTick, config);
        }
    }
}

