/*
 * Decompiled with CFR 0.152.
 */
package acbl;

import acbl.api.IAssassinLevel;
import acbl.capability.CapabilityLoader;
import acbl.capability.IExp;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class AssassinLevelHelper
implements IAssassinLevel {
    double melee;
    double health;
    double ranged;
    double stealth;
    EntityPlayer player;

    public AssassinLevelHelper(EntityPlayer player) {
        this.player = player;
        if (player.hasCapability(CapabilityLoader.assassinLevel, null)) {
            IExp exp = (IExp)player.getCapability(CapabilityLoader.assassinLevel, null);
            NBTTagCompound nbt = exp.geter();
            this.melee = nbt.func_74769_h("melee");
            this.health = nbt.func_74769_h("health");
            this.ranged = nbt.func_74769_h("ranged");
            this.stealth = nbt.func_74769_h("stealth");
        }
    }

    @Override
    public long getLevel() {
        double exp;
        long level = 0L;
        for (exp = this.getExp(); exp >= (double)(2L * level + 7L) && level <= 15L; exp -= (double)(2L * level + 7L), ++level) {
        }
        while (exp >= (double)(5L * level - 38L) && level <= 30L && level > 15L) {
            exp -= (double)(5L * level - 38L);
            ++level;
        }
        while (exp >= (double)(9L * level - 158L) && level > 30L) {
            exp -= (double)(9L * level - 158L);
            ++level;
        }
        return level;
    }

    @Override
    public double getExp() {
        return this.melee + this.health + this.ranged + this.stealth;
    }

    @Override
    public ITextComponent getType() {
        if (this.melee > this.health && this.melee > this.ranged && this.melee > this.stealth) {
            return new TextComponentTranslation("melee", new Object[0]);
        }
        if (this.health > this.melee && this.health > this.ranged && this.health > this.stealth) {
            return new TextComponentTranslation("health", new Object[0]);
        }
        if (this.ranged > this.health && this.ranged > this.melee && this.ranged > this.stealth) {
            return new TextComponentTranslation("ranged", new Object[0]);
        }
        if (this.stealth > this.health && this.stealth > this.ranged && this.stealth > this.melee) {
            return new TextComponentTranslation("stealth", new Object[0]);
        }
        return new TextComponentTranslation("balance", new Object[0]);
    }

    @Override
    public void increaseExp(IAssassinLevel.ExpType type, double basevalue, int level) {
        if (this.player.hasCapability(CapabilityLoader.assassinLevel, null)) {
            IExp exp = (IExp)this.player.getCapability(CapabilityLoader.assassinLevel, null);
            switch (type) {
                case MELEE: {
                    exp.setMelee(this.melee + (this.getLevel() <= (long)level ? basevalue : basevalue * ((double)level / (double)this.getLevel())));
                    break;
                }
                case HEALTH: {
                    exp.setHealth(this.health + (this.getLevel() <= (long)level ? basevalue : basevalue * ((double)level / (double)this.getLevel())));
                    break;
                }
                case RANGED: {
                    exp.setRanged(this.ranged + (this.getLevel() <= (long)level ? basevalue : basevalue * ((double)level / (double)this.getLevel())));
                    break;
                }
                case STEALTH: {
                    exp.setStealth(this.stealth + (this.getLevel() <= (long)level ? basevalue : basevalue * ((double)level / (double)this.getLevel())));
                    break;
                }
            }
        }
    }

    public ITextComponent getGrade() {
        long level = this.getLevel();
        if (level <= 3L) {
            return new TextComponentTranslation("recruit1", new Object[0]);
        }
        if (level <= 6L) {
            return new TextComponentTranslation("recruit2", new Object[0]);
        }
        if (level <= 9L) {
            return new TextComponentTranslation("recruit3", new Object[0]);
        }
        if (level <= 13L) {
            return new TextComponentTranslation("trainee1", new Object[0]);
        }
        if (level <= 16L) {
            return new TextComponentTranslation("trainee2", new Object[0]);
        }
        if (level <= 19L) {
            return new TextComponentTranslation("trainee3", new Object[0]);
        }
        if (level <= 23L) {
            return new TextComponentTranslation("apprentice1", new Object[0]);
        }
        if (level <= 26L) {
            return new TextComponentTranslation("apprentice2", new Object[0]);
        }
        if (level <= 29L) {
            return new TextComponentTranslation("apprentice3", new Object[0]);
        }
        if (level <= 33L) {
            return new TextComponentTranslation("soldier1", new Object[0]);
        }
        if (level <= 36L) {
            return new TextComponentTranslation("soldier2", new Object[0]);
        }
        if (level <= 39L) {
            return new TextComponentTranslation("soldier3", new Object[0]);
        }
        if (level <= 43L) {
            return new TextComponentTranslation("enforcer1", new Object[0]);
        }
        if (level <= 46L) {
            return new TextComponentTranslation("enforcer2", new Object[0]);
        }
        if (level <= 49L) {
            return new TextComponentTranslation("enforcer3", new Object[0]);
        }
        if (level <= 53L) {
            return new TextComponentTranslation("veteran1", new Object[0]);
        }
        if (level <= 56L) {
            return new TextComponentTranslation("veteran2", new Object[0]);
        }
        if (level <= 59L) {
            return new TextComponentTranslation("veteran3", new Object[0]);
        }
        if (level <= 63L) {
            return new TextComponentTranslation("officer1", new Object[0]);
        }
        if (level <= 66L) {
            return new TextComponentTranslation("officer2", new Object[0]);
        }
        if (level <= 69L) {
            return new TextComponentTranslation("officer3", new Object[0]);
        }
        if (level <= 73L) {
            return new TextComponentTranslation("champion1", new Object[0]);
        }
        if (level <= 76L) {
            return new TextComponentTranslation("champion2", new Object[0]);
        }
        if (level <= 79L) {
            return new TextComponentTranslation("champion3", new Object[0]);
        }
        if (level <= 83L) {
            return new TextComponentTranslation("assassin1", new Object[0]);
        }
        if (level <= 86L) {
            return new TextComponentTranslation("assassin2", new Object[0]);
        }
        if (level <= 89L) {
            return new TextComponentTranslation("assassin3", new Object[0]);
        }
        if (level <= 93L) {
            return new TextComponentTranslation("master1", new Object[0]);
        }
        if (level <= 96L) {
            return new TextComponentTranslation("master2", new Object[0]);
        }
        if (level <= 99L) {
            return new TextComponentTranslation("master3", new Object[0]);
        }
        if (level >= 100L) {
            return new TextComponentTranslation("legend", new Object[0]);
        }
        return null;
    }
}

