/*
 * Decompiled with CFR 0.152.
 */
package acbl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class RangeHelper {
    public List<Entity> getEntitiesInSphere(float range, @Nullable Entity entity, BlockPos pos, World world) {
        ArrayList list = Lists.newArrayList();
        AxisAlignedBB aabb = new AxisAlignedBB(pos.func_177963_a((double)(-range), (double)(-range), (double)(-range)), pos.func_177963_a((double)range, (double)range, (double)range));
        Iterator iterator = world.func_72839_b(entity, aabb).iterator();
        while (iterator.hasNext()) {
            Vec3d vec1 = new Vec3d((Vec3i)pos);
            Entity e = (Entity)iterator.next();
            Vec3d vec2 = new Vec3d((Vec3i)e.func_180425_c());
            Vec3d rangeVec = vec1.func_178788_d(vec2);
            if (!(rangeVec.func_72433_c() <= (double)range)) continue;
            list.add(e);
        }
        return list;
    }

    public List<Entity> getEntitiesInHollowSphere(float smallRange, float bigRange, @Nullable Entity entity, BlockPos pos, World world) {
        List<Entity> list = this.getEntitiesInSphere(bigRange, entity, pos, world);
        AxisAlignedBB aabb = new AxisAlignedBB(pos.func_177963_a((double)(-bigRange), (double)(-bigRange), (double)(-bigRange)), pos.func_177963_a((double)bigRange, (double)bigRange, (double)bigRange));
        Iterator iterator = world.func_72839_b(entity, aabb).iterator();
        while (iterator.hasNext()) {
            Vec3d vec1 = new Vec3d((Vec3i)pos);
            Entity e = (Entity)iterator.next();
            Vec3d vec2 = new Vec3d((Vec3i)e.func_180425_c());
            Vec3d rangeVec = vec1.func_178788_d(vec2);
            if (!(rangeVec.func_72433_c() <= (double)bigRange) || !(rangeVec.func_72433_c() > (double)smallRange)) continue;
            list.add(e);
        }
        return list;
    }

    public boolean isWithinDistance(float range, BlockPos pos1, BlockPos pos2) {
        Vec3d vec1 = new Vec3d((Vec3i)pos1);
        Vec3d vec2 = new Vec3d((Vec3i)pos2);
        Vec3d rangeVec = vec1.func_178788_d(vec2);
        return rangeVec.func_72433_c() <= (double)range;
    }
}

