/*
 * Decompiled with CFR 0.152.
 */
package acbl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.BlockRedstoneLight;

public class ReflectionHelper {
    private static Map<MethodDescriptor, Method> methodsCache = new HashMap<MethodDescriptor, Method>();
    private static Map<FieldDescriptor, Field> fieldsCache = new HashMap<FieldDescriptor, Field>();
    private static int environment = 0;

    private static Class<?>[] getParameterTypes(Object[] param) {
        Class[] cls = new Class[param.length];
        for (int i = 0; i < param.length; ++i) {
            cls[i] = param[i].getClass();
            if (cls[i] == Integer.class) {
                cls[i] = Integer.TYPE;
                continue;
            }
            if (cls[i] == Double.class) {
                cls[i] = Double.TYPE;
                continue;
            }
            if (cls[i] == Boolean.class) {
                cls[i] = Boolean.TYPE;
                continue;
            }
            if (cls[i] == Float.class) {
                cls[i] = Float.TYPE;
                continue;
            }
            if (cls[i] == Character.class) {
                cls[i] = Character.TYPE;
                continue;
            }
            if (cls[i] == Long.class) {
                cls[i] = Long.TYPE;
                continue;
            }
            if (cls[i] == Short.class) {
                cls[i] = Short.TYPE;
                continue;
            }
            if (cls[i] != Byte.class) continue;
            cls[i] = Byte.TYPE;
        }
        return cls;
    }

    public static <T> T method(Class<?> cls, String mcp, String srg, Object object, Object ... param) throws ReflectiveOperationException {
        String name = srg;
        if (environment == 0) {
            name = mcp;
        }
        Class<?>[] pt = ReflectionHelper.getParameterTypes(param);
        MethodDescriptor md = new MethodDescriptor(cls, name, pt);
        Method m = null;
        if (methodsCache.containsKey(md)) {
            m = methodsCache.get(md);
        } else {
            m = cls.getDeclaredMethod(name, pt);
            m.setAccessible(true);
            methodsCache.put(md, m);
        }
        return (T)m.invoke(object, param);
    }

    public static <T> T method(Class<?> cls, String mcp, String srg, Object object, Class<?>[] paramTypes, Object ... param) throws ReflectiveOperationException {
        String name = srg;
        if (environment == 0) {
            name = mcp;
        }
        Class<?>[] pt = paramTypes;
        MethodDescriptor md = new MethodDescriptor(cls, name, pt);
        Method m = null;
        if (methodsCache.containsKey(md)) {
            m = methodsCache.get(md);
        } else {
            m = cls.getDeclaredMethod(name, pt);
            m.setAccessible(true);
            methodsCache.put(md, m);
        }
        return (T)m.invoke(object, param);
    }

    public static <T> T getField(Class<?> cls, String mcp, String srg, Object object) throws ReflectiveOperationException {
        String name = srg;
        if (environment == 0) {
            name = mcp;
        }
        FieldDescriptor md = new FieldDescriptor(cls, name);
        Field f = null;
        if (fieldsCache.containsKey(md)) {
            f = fieldsCache.get(md);
        } else {
            f = cls.getDeclaredField(name);
            f.setAccessible(true);
            fieldsCache.put(md, f);
        }
        return (T)f.get(object);
    }

    public static <T> void setField(Class<?> cls, String mcp, String srg, Object object, Object value) throws ReflectiveOperationException {
        String name = srg;
        if (environment == 0) {
            name = mcp;
        }
        FieldDescriptor md = new FieldDescriptor(cls, name);
        Field f = null;
        if (fieldsCache.containsKey(md)) {
            f = fieldsCache.get(md);
        } else {
            f = cls.getDeclaredField(name);
            f.setAccessible(true);
            fieldsCache.put(md, f);
        }
        f.set(object, value);
    }

    static {
        Class<BlockRedstoneLight> cls = BlockRedstoneLight.class;
        Field f = cls.getDeclaredFields()[0];
        if (f.getName().contains("field")) {
            environment = 1;
        }
    }

    private static class FieldDescriptor {
        Class<?> cls;
        String name;

        public FieldDescriptor(Class<?> cls, String name) {
            this.cls = cls;
            this.name = name;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.cls == null ? 0 : this.cls.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FieldDescriptor other = (FieldDescriptor)obj;
            if (this.cls == null ? other.cls != null : !this.cls.equals(other.cls)) {
                return false;
            }
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }
    }

    private static class MethodDescriptor {
        Class<?> cls;
        String name;
        Class<?>[] param;

        public MethodDescriptor(Class<?> cls, String name, Class<?>[] param) {
            this.cls = cls;
            this.name = name;
            this.param = param;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.cls == null ? 0 : this.cls.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + Arrays.hashCode(this.param);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MethodDescriptor other = (MethodDescriptor)obj;
            if (this.cls == null ? other.cls != null : !this.cls.equals(other.cls)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return Arrays.equals(this.param, other.param);
        }
    }
}

