/*
 * Decompiled with CFR 0.152.
 */
package acbl.gui;

import acbl.ACBL;
import acbl.FightWineHelper;
import java.util.Random;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketCustomSound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ContainerSingleWineGame
extends Container {
    public int totalA;
    public int totalNPC;
    public double totalnowNPC;
    public double totalnowA;
    public double nowA;
    public double protecttimeA;
    public double instaltimeA;
    public double lefttime;
    public double righttime;
    int difficulty = new Random().nextInt(3) + 1;
    boolean isPlayerWin = false;
    public FightWineHelper helper = new FightWineHelper();
    EntityPlayer player;
    public BetTypes types;

    public ContainerSingleWineGame(EntityPlayer playerIn) {
        this.helper.initialization(this.difficulty, true, null, playerIn.func_110124_au().toString());
        this.player = playerIn;
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return true;
    }

    public void func_75142_b() {
        super.func_75142_b();
        this.totalA = this.helper.totalA;
        this.totalNPC = this.helper.totalNPC;
        this.totalnowNPC = this.helper.totalnowNPC;
        this.protecttimeA = this.helper.protecttimeA;
        this.instaltimeA = this.helper.instaltimeA;
        this.lefttime = this.helper.lefttime;
        this.righttime = this.helper.righttime;
        this.totalnowA = this.helper.totalnowA;
        this.nowA = this.helper.nowA;
        if (this.player instanceof EntityPlayerMP) {
            this.helper.onPlayerUpdate(null, this.player.func_110124_au().toString(), true, (EntityPlayerMP)this.player);
        }
        this.helper.onNPCUpdate();
        if (this.helper.totalA == 0) {
            try {
                switch (this.types) {
                    case IRON_NUGGET: {
                        this.player.field_71071_by.func_70441_a(new ItemStack(Items.field_191525_da, 6));
                        this.player.func_145747_a((ITextComponent)new TextComponentTranslation("win", new Object[0]));
                        this.isPlayerWin = true;
                        break;
                    }
                    case GOLD_INGOT: {
                        this.player.field_71071_by.func_70441_a(new ItemStack(Items.field_151043_k, 4));
                        this.player.func_145747_a((ITextComponent)new TextComponentTranslation("win", new Object[0]));
                        this.isPlayerWin = true;
                        break;
                    }
                    case EMERALD: {
                        this.player.field_71071_by.func_70441_a(new ItemStack(Items.field_151166_bC, 2));
                        this.player.func_145747_a((ITextComponent)new TextComponentTranslation("win", new Object[0]));
                        this.isPlayerWin = true;
                        break;
                    }
                }
                this.player.func_71053_j();
                this.func_75134_a(this.player);
            }
            catch (Exception e) {
                this.player.func_145747_a((ITextComponent)new TextComponentTranslation("error", new Object[0]));
                ACBL.logger.error("An unknown error has occurred!");
                e.printStackTrace();
            }
        } else if (this.helper.totalNPC == 0) {
            this.player.func_71053_j();
            this.func_75134_a(this.player);
            this.player.func_145747_a((ITextComponent)new TextComponentTranslation("lose", new Object[0]));
        }
        for (IContainerListener listener : this.field_75149_d) {
            listener.func_71112_a((Container)this, 0, (int)this.nowA);
            listener.func_71112_a((Container)this, 1, (int)this.instaltimeA);
            listener.func_71112_a((Container)this, 2, (int)this.protecttimeA);
            listener.func_71112_a((Container)this, 3, this.totalA);
            listener.func_71112_a((Container)this, 4, this.totalNPC);
            listener.func_71112_a((Container)this, 5, (int)this.lefttime);
            listener.func_71112_a((Container)this, 6, (int)this.righttime);
            listener.func_71112_a((Container)this, 7, (int)this.totalnowA);
            listener.func_71112_a((Container)this, 8, (int)this.totalnowNPC);
        }
    }

    public void func_75137_b(int id, int data) {
        super.func_75137_b(id, data);
        switch (id) {
            case 0: {
                this.nowA = data;
                break;
            }
            case 1: {
                this.instaltimeA = data;
                break;
            }
            case 2: {
                this.protecttimeA = data;
                break;
            }
            case 3: {
                this.totalA = data;
                break;
            }
            case 4: {
                this.totalNPC = data;
                break;
            }
            case 5: {
                this.lefttime = data;
                break;
            }
            case 6: {
                this.righttime = data;
                break;
            }
            case 7: {
                this.totalnowA = data;
                break;
            }
            case 8: {
                this.totalnowNPC = data;
                break;
            }
        }
    }

    public void func_75134_a(EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        if (playerIn instanceof EntityPlayerMP) {
            if (this.isPlayerWin) {
                ((EntityPlayerMP)playerIn).field_71135_a.func_147359_a((Packet)new SPacketCustomSound("minecraft:ui.toast.challenge_complete", SoundCategory.PLAYERS, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, 1.0f, 1.0f));
            } else {
                ((EntityPlayerMP)playerIn).field_71135_a.func_147359_a((Packet)new SPacketCustomSound("minecraft:entity.witch.ambient", SoundCategory.PLAYERS, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, 1.0f, 1.0f));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class Gui
    extends GuiContainer {
        public static final ResourceLocation TEXTURE = new ResourceLocation("acbl", "textures/gui/container/wine_game.png");

        public Gui(EntityPlayer playerIn) {
            super((Container)new ContainerSingleWineGame(playerIn));
            this.field_146999_f = 248;
            this.field_147000_g = 166;
        }

        protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
            int offsetX = (this.field_146294_l - this.field_146999_f) / 2;
            int offsetY = (this.field_146295_m - this.field_147000_g) / 2;
            this.func_73729_b(offsetX, offsetY, 0, 0, this.field_146999_f, this.field_147000_g);
            ContainerSingleWineGame game = (ContainerSingleWineGame)this.field_147002_h;
            this.func_73729_b(offsetX + 33, offsetY + 127, 0, 219, (int)(182.0 * (game.nowA / 100.0)), 5);
            this.func_73729_b(offsetX + 33, offsetY + 127, 0, 224, (int)(182.0 * (game.instaltimeA / 60.0)), 5);
            this.func_73729_b(offsetX + 33, offsetY + 127, 0, 229, (int)(182.0 * (game.protecttimeA / 60.0)), 5);
            this.func_73729_b(offsetX + 9, offsetY + 26 + 18 * (5 - game.totalNPC), 182, 166, 16, 18 * game.totalNPC);
            this.func_73729_b(offsetX + 223, offsetY + 26 + 18 * (5 - game.totalA), 198, 166, 16, 18 * game.totalA);
            this.func_73729_b(offsetX + 30, offsetY + 44 + (int)(53.0 * (1.0 - game.totalnowNPC / 100.0)), 49, 166 + (int)(53.0 * (1.0 - game.totalnowNPC / 100.0)), 49, (int)(53.0 * (game.totalnowNPC / 100.0)));
            this.func_73729_b(offsetX + 169, offsetY + 44 + (int)(53.0 * (1.0 - game.totalnowA / 100.0)), 0, 166 + (int)(53.0 * (1.0 - game.totalnowA / 100.0)), 49, (int)(53.0 * (game.totalnowA / 100.0)));
            this.func_73729_b(offsetX + 84, offsetY + 65 + (int)(32.0 * (1.0 - game.lefttime / 60.0)), 114, 166 + (int)(32.0 * (1.0 - game.lefttime / 60.0)), 32, (int)(32.0 * (game.lefttime / 60.0) + 1.0));
            this.func_73729_b(offsetX + 132, offsetY + 65 + (int)(32.0 * (1.0 - game.righttime / 60.0)), 147, 166 + (int)(32.0 * (1.0 - game.righttime / 60.0)), 32, (int)(32.0 * (game.righttime / 60.0) + 1.0));
        }

        protected void func_146979_b(int mouseX, int mouseY) {
            ContainerSingleWineGame game = (ContainerSingleWineGame)this.field_147002_h;
            String title = I18n.func_135052_a((String)"container.wine_game.title", (Object[])new Object[0]);
            this.field_146289_q.func_78276_b(title, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(title) / 2, 5, 0x404040);
            String instal = I18n.func_135052_a((String)"container.wine_game.instal", (Object[])new Object[0]);
            if (game.instaltimeA > 0.0) {
                this.field_146289_q.func_78276_b(instal, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(instal) / 2, 118, 0x404040);
            }
            String protect = I18n.func_135052_a((String)"container.wine_game.protect", (Object[])new Object[0]);
            if (game.protecttimeA > 0.0) {
                this.field_146289_q.func_78276_b(protect, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(protect) / 2, 118, 0x404040);
            }
            String left = I18n.func_135052_a((String)"container.wine_game.left", (Object[])new Object[0]);
            if (game.lefttime > 0.0) {
                this.field_146289_q.func_78276_b(left, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(left) / 2, 107, 0x404040);
            }
            String right = I18n.func_135052_a((String)"container.wine_game.right", (Object[])new Object[0]);
            if (game.righttime > 0.0) {
                this.field_146289_q.func_78276_b(right, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(right) / 2, 107, 0x404040);
            }
        }

        public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
            this.func_146276_q_();
            super.func_73863_a(mouseX, mouseY, partialTicks);
            this.func_191948_b(mouseX, mouseY);
        }
    }

    public static enum BetTypes {
        IRON_NUGGET,
        GOLD_INGOT,
        EMERALD;

    }
}

