/*
 * Decompiled with CFR 0.152.
 */
package acbl.recipes;

import acbl.gui.InventoryForgingCraftingTable;
import acbl.item.ItemLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.common.Optional;

public class ForgingCraftingTableRecipeLoader {
    public static final List<ForgingCraftingTableRecipe> RECIPES = new ArrayList<ForgingCraftingTableRecipe>();

    public static ItemStack getResult(InventoryForgingCraftingTable inv) {
        for (ForgingCraftingTableRecipe c : RECIPES) {
            if (!c.matches(inv)) continue;
            return c.result;
        }
        return ItemStack.field_190927_a;
    }

    public ForgingCraftingTableRecipeLoader() {
        RECIPES.add(new ForgingCraftingTableRecipeShaped(new ItemStack(ItemLoader.butcher), "  BCA", " B AB", "  A  ", " A   ", "A    ", Character.valueOf('A'), "logWood", Character.valueOf('B'), Items.field_151042_j, Character.valueOf('C'), Items.field_151043_k));
        RECIPES.add(new ForgingCraftingTableRecipeShaped(new ItemStack(ItemLoader.judge), "   AA", "  AAA", "  AA ", " A   ", "A    ", Character.valueOf('A'), Items.field_151043_k));
        RECIPES.add(new ForgingCraftingTableRecipeShaped(new ItemStack(ItemLoader.starAndMoon), "   AA", "  AAA", "  AA ", " A   ", "A    ", Character.valueOf('A'), Items.field_151042_j));
        RECIPES.add(new ForgingCraftingTableRecipeShaped(new ItemStack(ItemLoader.spike), "     ", "   B ", " BB  ", " AB  ", "     ", Character.valueOf('A'), Items.field_151055_y, Character.valueOf('B'), Items.field_151042_j));
        RECIPES.add(new ForgingCraftingTableRecipeShaped(new ItemStack(ItemLoader.darts, 2), "     ", "   B ", "  B  ", " A   ", "     ", Character.valueOf('A'), Items.field_151055_y, Character.valueOf('B'), Items.field_151042_j));
        RECIPES.add(new ForgingCraftingTableRecipeShaped(new ItemStack(ItemLoader.frenchScimitar), "     ", "   BB", "  B  ", " B   ", "A    ", Character.valueOf('A'), Items.field_151043_k, Character.valueOf('B'), Items.field_151042_j));
        RECIPES.add(new ForgingCraftingTableRecipeShaped(new ItemStack(ItemLoader.venetianLongsword), "    A", "   A ", "A A  ", " A   ", "A A  ", Character.valueOf('A'), Items.field_151042_j));
        RECIPES.add(new ForgingCraftingTableRecipeShaped(new ItemStack(ItemLoader.captainsSword), "    B", "   B ", "  B  ", "AB   ", "CA   ", Character.valueOf('A'), Items.field_151043_k, Character.valueOf('B'), Items.field_151042_j, Character.valueOf('C'), Items.field_151137_ax));
        RECIPES.add(new ForgingCraftingTableRecipeShaped(new ItemStack(ItemLoader.assassinsTomahawk), " BB  ", " B A ", "  AB ", " A   ", "A    ", Character.valueOf('A'), Items.field_151055_y, Character.valueOf('B'), Items.field_151042_j));
        RECIPES.add(new ForgingCraftingTableRecipeShaped(new ItemStack(ItemLoader.reaper), "    B", "    B", "  BB ", " A   ", "A    ", Character.valueOf('A'), Items.field_151055_y, Character.valueOf('B'), "ingotBronze"));
    }

    @Optional.Interface(modid="jei", iface="mezz.jei.api.recipe.IRecipeWrapper", striprefs=true)
    public static class ForgingCraftingTableRecipeShaped
    extends ForgingCraftingTableRecipe
    implements IRecipeWrapper {
        public Ingredient[] ingredients;
        public int sx = 0;
        public int sy = 0;

        public ForgingCraftingTableRecipeShaped(ItemStack result, Object ... args) {
            super(result);
            int i;
            for (int i2 = 0; i2 < args.length && args[i2] instanceof String; ++i2) {
                ++this.sx;
                this.sy = ((String)args[i2]).length();
            }
            String[] temp = new String[this.sx];
            for (int i3 = 0; i3 < this.sx; ++i3) {
                temp[i3] = (String)args[i3];
            }
            HashMap<Character, Ingredient> map = new HashMap<Character, Ingredient>();
            map.put(Character.valueOf(' '), Ingredient.field_193370_a);
            for (i = this.sx; i < args.length; i += 2) {
                map.put((Character)args[i], CraftingHelper.getIngredient((Object)args[i + 1]));
            }
            this.ingredients = new Ingredient[this.sx * this.sy];
            for (i = 0; i < this.sx; ++i) {
                for (int j = 0; j < this.sy; ++j) {
                    this.ingredients[i * this.sy + j] = (Ingredient)map.get(Character.valueOf(temp[i].charAt(j)));
                }
            }
        }

        @Override
        public boolean matches(InventoryForgingCraftingTable inv) {
            for (int i = 0; i < this.sx; ++i) {
                for (int j = 0; j < this.sy; ++j) {
                    if (this.ingredients[i * this.sy + j].apply(inv.func_70463_b(i, j))) continue;
                    return false;
                }
            }
            return true;
        }

        public void getIngredients(IIngredients ingredients) {
            ArrayList<List<ItemStack>> in = new ArrayList<List<ItemStack>>();
            for (int i = 0; i < 5; ++i) {
                for (int j = 0; j < 5; ++j) {
                    in.add(Arrays.asList(this.ingredients[i * 5 + j].func_193365_a()));
                }
            }
            ingredients.setInputLists(VanillaTypes.ITEM, in);
            ingredients.setOutput(VanillaTypes.ITEM, (Object)this.result);
        }
    }

    public static abstract class ForgingCraftingTableRecipe {
        protected ItemStack result;

        public ForgingCraftingTableRecipe(ItemStack result) {
            this.result = result;
        }

        public ItemStack getResult() {
            return this.result;
        }

        public abstract boolean matches(InventoryForgingCraftingTable var1);
    }
}

