/*
 * Decompiled with CFR 0.152.
 */
package acbl;

import acbl.api.IAssassinLevel;
import acbl.capability.CapabilityLoader;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.LazyOptional;

public class AssassinLevelHelper
implements IAssassinLevel {
    double melee;
    double health;
    double ranged;
    double stealth;
    PlayerEntity player;

    public AssassinLevelHelper(PlayerEntity player) {
        this.player = player;
        LazyOptional exp = player.getCapability(CapabilityLoader.ASSASSIN_LEVEL, null);
        exp.ifPresent(l -> {
            CompoundNBT nbt = l.geter();
            this.melee = nbt.func_74769_h("melee");
            this.health = nbt.func_74769_h("health");
            this.ranged = nbt.func_74769_h("ranged");
            this.stealth = nbt.func_74769_h("stealth");
        });
    }

    @Override
    public long getLevel() {
        double exp;
        long level = 0L;
        for (exp = this.getExp(); exp >= (double)(2L * level + 7L) && level <= 15L; exp -= (double)(2L * level + 7L), ++level) {
        }
        while (exp >= (double)(5L * level - 38L) && level <= 30L && level > 15L) {
            exp -= (double)(5L * level - 38L);
            ++level;
        }
        while (exp >= (double)(9L * level - 158L) && level > 30L) {
            exp -= (double)(9L * level - 158L);
            ++level;
        }
        return level;
    }

    @Override
    public double getExp() {
        return this.melee + this.health + this.ranged + this.stealth;
    }

    @Override
    public ITextComponent getType() {
        if (this.melee > this.health && this.melee > this.ranged && this.melee > this.stealth) {
            return new TranslationTextComponent("melee");
        }
        if (this.health > this.melee && this.health > this.ranged && this.health > this.stealth) {
            return new TranslationTextComponent("health");
        }
        if (this.ranged > this.health && this.ranged > this.melee && this.ranged > this.stealth) {
            return new TranslationTextComponent("ranged");
        }
        if (this.stealth > this.health && this.stealth > this.ranged && this.stealth > this.melee) {
            return new TranslationTextComponent("stealth");
        }
        return new TranslationTextComponent("balance");
    }

    @Override
    public void increaseExp(IAssassinLevel.ExpType type, double basevalue, int level) {
        LazyOptional exp = this.player.getCapability(CapabilityLoader.ASSASSIN_LEVEL, null);
        exp.ifPresent(l -> {
            switch (type) {
                case MELEE: {
                    l.setMelee(this.melee + (this.getLevel() <= (long)level ? basevalue : basevalue * ((double)level / (double)this.getLevel())));
                    break;
                }
                case HEALTH: {
                    l.setHealth(this.health + (this.getLevel() <= (long)level ? basevalue : basevalue * ((double)level / (double)this.getLevel())));
                    break;
                }
                case RANGED: {
                    l.setRanged(this.ranged + (this.getLevel() <= (long)level ? basevalue : basevalue * ((double)level / (double)this.getLevel())));
                    break;
                }
                case STEALTH: {
                    l.setStealth(this.stealth + (this.getLevel() <= (long)level ? basevalue : basevalue * ((double)level / (double)this.getLevel())));
                    break;
                }
            }
        });
    }

    public ITextComponent getGrade() {
        long level = this.getLevel();
        if (level <= 3L) {
            return new TranslationTextComponent("recruit1");
        }
        if (level <= 6L) {
            return new TranslationTextComponent("recruit2");
        }
        if (level <= 9L) {
            return new TranslationTextComponent("recruit3");
        }
        if (level <= 13L) {
            return new TranslationTextComponent("trainee1");
        }
        if (level <= 16L) {
            return new TranslationTextComponent("trainee2");
        }
        if (level <= 19L) {
            return new TranslationTextComponent("trainee3");
        }
        if (level <= 23L) {
            return new TranslationTextComponent("apprentice1");
        }
        if (level <= 26L) {
            return new TranslationTextComponent("apprentice2");
        }
        if (level <= 29L) {
            return new TranslationTextComponent("apprentice3");
        }
        if (level <= 33L) {
            return new TranslationTextComponent("soldier1");
        }
        if (level <= 36L) {
            return new TranslationTextComponent("soldier2");
        }
        if (level <= 39L) {
            return new TranslationTextComponent("soldier3");
        }
        if (level <= 43L) {
            return new TranslationTextComponent("enforcer1");
        }
        if (level <= 46L) {
            return new TranslationTextComponent("enforcer2");
        }
        if (level <= 49L) {
            return new TranslationTextComponent("enforcer3");
        }
        if (level <= 53L) {
            return new TranslationTextComponent("veteran1");
        }
        if (level <= 56L) {
            return new TranslationTextComponent("veteran2");
        }
        if (level <= 59L) {
            return new TranslationTextComponent("veteran3");
        }
        if (level <= 63L) {
            return new TranslationTextComponent("officer1");
        }
        if (level <= 66L) {
            return new TranslationTextComponent("officer2");
        }
        if (level <= 69L) {
            return new TranslationTextComponent("officer3");
        }
        if (level <= 73L) {
            return new TranslationTextComponent("champion1");
        }
        if (level <= 76L) {
            return new TranslationTextComponent("champion2");
        }
        if (level <= 79L) {
            return new TranslationTextComponent("champion3");
        }
        if (level <= 83L) {
            return new TranslationTextComponent("assassin1");
        }
        if (level <= 86L) {
            return new TranslationTextComponent("assassin2");
        }
        if (level <= 89L) {
            return new TranslationTextComponent("assassin3");
        }
        if (level <= 93L) {
            return new TranslationTextComponent("master1");
        }
        if (level <= 96L) {
            return new TranslationTextComponent("master2");
        }
        if (level <= 99L) {
            return new TranslationTextComponent("master3");
        }
        if (level >= 100L) {
            return new TranslationTextComponent("legend");
        }
        return null;
    }
}

