/*
 * Decompiled with CFR 0.152.
 */
package acbl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class RangeHelper {
    public List<Entity> getEntitiesInSphere(float range, @Nullable Entity entity, BlockPos pos, World world) {
        ArrayList list = Lists.newArrayList();
        AxisAlignedBB aabb = new AxisAlignedBB((BlockPos)pos.func_239590_i_().func_189532_c((double)((float)pos.func_177958_n() - range), (double)((float)pos.func_177956_o() - range), (double)((float)pos.func_177952_p() - range)), (BlockPos)pos.func_239590_i_().func_189532_c((double)((float)pos.func_177958_n() + range), (double)((float)pos.func_177956_o() + range), (double)((float)pos.func_177952_p() + range)));
        for (Entity e : world.func_72839_b(entity, aabb)) {
            Vector3d vec2;
            Vector3d vec1 = new Vector3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            Vector3d rangeVec = vec1.func_178788_d(vec2 = new Vector3d(e.func_226277_ct_(), e.func_226278_cu_(), e.func_226281_cx_()));
            if (!(rangeVec.func_72433_c() <= (double)range)) continue;
            list.add(e);
        }
        return list;
    }

    public List<Entity> getEntitiesInHollowSphere(float smallRange, float bigRange, @Nullable Entity entity, BlockPos pos, World world) {
        List<Entity> list = this.getEntitiesInSphere(bigRange, entity, pos, world);
        AxisAlignedBB aabb = new AxisAlignedBB((BlockPos)pos.func_239590_i_().func_189532_c((double)((float)pos.func_177958_n() - bigRange), (double)((float)pos.func_177956_o() - bigRange), (double)((float)pos.func_177952_p() - bigRange)), (BlockPos)pos.func_239590_i_().func_189532_c((double)((float)pos.func_177958_n() + bigRange), (double)((float)pos.func_177956_o() + bigRange), (double)((float)pos.func_177952_p() + bigRange)));
        for (Entity e : world.func_72839_b(entity, aabb)) {
            Vector3d vec2;
            Vector3d vec1 = new Vector3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            Vector3d rangeVec = vec1.func_178788_d(vec2 = new Vector3d(e.func_226277_ct_(), e.func_226278_cu_(), e.func_226281_cx_()));
            if (!(rangeVec.func_72433_c() <= (double)bigRange) || !(rangeVec.func_72433_c() > (double)smallRange)) continue;
            list.add(e);
        }
        return list;
    }

    public boolean isWithinDistance(float range, BlockPos pos1, BlockPos pos2) {
        Vector3d vec2;
        Vector3d vec1 = new Vector3d((double)pos1.func_177958_n(), (double)pos1.func_177956_o(), (double)pos1.func_177952_p());
        Vector3d rangeVec = vec1.func_178788_d(vec2 = new Vector3d((double)pos2.func_177958_n(), (double)pos2.func_177956_o(), (double)pos2.func_177952_p()));
        return rangeVec.func_72433_c() <= (double)range;
    }
}

