/*
 * Decompiled with CFR 0.152.
 */
package acbl.capability;

import acbl.capability.AssassinLevelProvider;
import acbl.capability.CapabilityLoader;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class CommonEventHandler {
    @SubscribeEvent
    public static void onAttachCapabilityEvent(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (entity instanceof PlayerEntity) {
            event.addCapability(new ResourceLocation("acbl", "assassin_exp"), (ICapabilityProvider)new AssassinLevelProvider());
        }
    }

    @SubscribeEvent
    public static void onPlayerCloned(PlayerEvent.Clone event) {
        if (!event.isWasDeath()) {
            LazyOptional oldSpeedCap = event.getOriginal().getCapability(CapabilityLoader.ASSASSIN_LEVEL);
            LazyOptional newSpeedCap = event.getPlayer().getCapability(CapabilityLoader.ASSASSIN_LEVEL);
            if (oldSpeedCap.isPresent() && newSpeedCap.isPresent()) {
                newSpeedCap.ifPresent(newCap -> oldSpeedCap.ifPresent(oldCap -> newCap.deserializeNBT(oldCap.serializeNBT())));
            }
        }
    }
}

