/*
 * Decompiled with CFR 0.152.
 */
package acbl.common;

import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigLoader {
    public static ForgeConfigSpec COMMON_CONFIG;
    public static ForgeConfigSpec.BooleanValue isDrop;
    public static ForgeConfigSpec.BooleanValue isTemplarsAttackMonsters;
    public static ForgeConfigSpec.BooleanValue isSpawnInTheWild;
    public static ForgeConfigSpec.BooleanValue canAttackCreateModePlayer;
    public static ForgeConfigSpec.BooleanValue isGenerateChest;
    public static ForgeConfigSpec.BooleanValue isGenerateWineBarrel;
    public static ForgeConfigSpec.IntValue edenApples;
    public static ForgeConfigSpec.IntValue edenShrouds;
    public static ForgeConfigSpec.IntValue edenSwords;
    public static ForgeConfigSpec.IntValue saffOfHermes;
    public static ForgeConfigSpec.IntValue spearOfLeonidas;
    public static ForgeConfigSpec.IntValue poseidonsTrident;
    public static ForgeConfigSpec.IntValue mjolnir;
    public static ForgeConfigSpec.IntValue campTimes;
    public static ForgeConfigSpec.IntValue barrelTimes;
    public static ForgeConfigSpec.DoubleValue generationProbability;

    static {
        ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
        COMMON_BUILDER.comment("General settings").push("general");
        isDrop = COMMON_BUILDER.comment("Set whether items will drop when using the Apples of Eden.").define("IsDrop(B)", true);
        isTemplarsAttackMonsters = COMMON_BUILDER.comment("Set whether the Templars will attack monsters.").define("IsTemplarsAttackMonsters(B)", false);
        isSpawnInTheWild = COMMON_BUILDER.comment("Set whether the Templars will spawn in the wild.").define("IsSpawnInTheWild(B)", true);
        canAttackCreateModePlayer = COMMON_BUILDER.comment("Set whether the sword of Eden can attack players in creative mode.").define("CanAttackCreateModePlayer(B)", true);
        isGenerateChest = COMMON_BUILDER.comment("If set to true, armor stand will not be generated in the dungeon but chest.").define("IsGenerateChest(B)", false);
        isGenerateWineBarrel = COMMON_BUILDER.comment("Set whether Drinkers and Wine Barrels will spawn in the world.").define("IsGenerateWineBarrel(B)", true);
        edenApples = COMMON_BUILDER.comment("Set the maximum number of Eden Apples that this world can generate.").defineInRange("EdenApples(I)", 5, 0, Integer.MAX_VALUE);
        edenShrouds = COMMON_BUILDER.comment("Set the maximum number of Eden Shrouds that this world can generate.").defineInRange("EdenShrouds(I)", 2, 0, Integer.MAX_VALUE);
        edenSwords = COMMON_BUILDER.comment("Set the maximum number of Eden Swords that this world can generate.").defineInRange("EdenSwords(I)", 1, 0, Integer.MAX_VALUE);
        saffOfHermes = COMMON_BUILDER.comment("Set the maximum number of Saff of Hermes that this world can generate.").defineInRange("SaffOfHermes(I)", 1, 0, Integer.MAX_VALUE);
        spearOfLeonidas = COMMON_BUILDER.comment("Set the maximum number of Spear of Leonidas that this world can generate.").defineInRange("SpearOfLeonidas(I)", 1, 0, Integer.MAX_VALUE);
        poseidonsTrident = COMMON_BUILDER.comment("Set the maximum number of Poseidons Trident that this world can generate.").defineInRange("PoseidonsTrident(I)", 1, 0, Integer.MAX_VALUE);
        mjolnir = COMMON_BUILDER.comment("Set the maximum number of Mjolnir that this world can generate.").defineInRange("Mjolnir(I)", 1, 0, Integer.MAX_VALUE);
        campTimes = COMMON_BUILDER.comment("Set the number of attempts to generate a Templar Camp each chunk.").defineInRange("CampTimes(I)", 3, 0, Integer.MAX_VALUE);
        barrelTimes = COMMON_BUILDER.comment("Set the number of attempts to generate a Drinker and a Wine Barrel each chunk.").defineInRange("BarrelTimes(I)", 7, 0, Integer.MAX_VALUE);
        generationProbability = COMMON_BUILDER.comment("Set the probability of each chunk TRYING to generate a Templar camp.").defineInRange("GenerationProbability(D)", 0.8, 0.0, 1.0);
        COMMON_BUILDER.pop();
        COMMON_CONFIG = COMMON_BUILDER.build();
    }
}

