/*
 * Decompiled with CFR 0.152.
 */
package acbl.item.pieceofeden;

import acbl.common.ConfigLoader;
import acbl.common.ItemGroupLoader;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class ItemEdenSword
extends Item {
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;
    public static Attribute damage = new RangedAttribute("attribute.eden_sword", 0.0, 0.0, Double.MAX_VALUE);
    public static Attribute passArmor = new RangedAttribute("attribute.pass_armor", 0.0, 0.0, Double.MAX_VALUE);
    public static Attribute abyss = new RangedAttribute("attribute.abyss", 0.0, 0.0, Double.MAX_VALUE);

    public ItemEdenSword() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(ItemGroupLoader.tabACBL));
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)passArmor, (Object)new AttributeModifier(UUID.fromString("28dc82e9-8c00-4d1c-8391-b7cb4b01bd8c"), "Weapon modifier", 616.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)damage, (Object)new AttributeModifier(Item.field_111210_e, "Weapon modifier", 232.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)abyss, (Object)new AttributeModifier(UUID.fromString("25afeae7-38ed-4ca2-b77a-6db694ecb465"), "Weapon modifier", 0.3333333333333333, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity player, Hand handIn) {
        ItemStack itemstack = player.func_184586_b(handIn);
        Random rand = new Random();
        double d1 = player.func_226277_ct_() + (rand.nextDouble() - 0.5) * 16.0;
        double d2 = MathHelper.func_151237_a((double)(player.func_226278_cu_() + (double)(rand.nextInt(16) - 8)), (double)0.0, (double)(worldIn.func_234938_ad_() - 1));
        double d3 = player.func_226281_cx_() + (rand.nextDouble() - 0.5) * 16.0;
        player.func_213373_a(d1, d2, d3, false);
        player.func_184811_cZ().func_185145_a((Item)this, 60);
        return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
    }

    @Nonnull
    public Multimap<Attribute, AttributeModifier> func_111205_h(EquipmentSlotType equipmentSlot) {
        return equipmentSlot == EquipmentSlotType.MAINHAND ? this.defaultModifiers : super.func_111205_h(equipmentSlot);
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        Multimap multimap = stack.func_111283_C(EquipmentSlotType.MAINHAND);
        if (target == null) {
            return false;
        }
        if (attacker.field_70170_p.field_72995_K) {
            return false;
        }
        target.func_70097_a(new EntityDamageSource("player", (Entity)attacker).func_76348_h().func_76359_i().func_151518_m(), 616.0f);
        this.attack(stack, target, (Multimap<Attribute, AttributeModifier>)multimap, damage, new DamageSource("eden").func_76348_h().func_76359_i().func_151518_m(), attacker);
        this.drainHealth(target);
        return false;
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity entity) {
        PlayerEntity victim;
        Multimap multimap = stack.func_111283_C(EquipmentSlotType.MAINHAND);
        if (!entity.field_70170_p.field_72995_K && entity instanceof PlayerEntity && (victim = (PlayerEntity)entity).func_184812_l_() && !victim.field_70128_L && victim.func_110143_aJ() > 0.0f && ((Boolean)ConfigLoader.canAttackCreateModePlayer.get()).booleanValue()) {
            victim.func_70097_a(new EntityDamageSource("player", (Entity)player).func_76348_h().func_76359_i().func_151518_m(), 616.0f);
            this.attack(stack, (LivingEntity)victim, (Multimap<Attribute, AttributeModifier>)multimap, damage, new DamageSource("eden").func_76348_h().func_76359_i().func_151518_m(), (LivingEntity)player);
            this.drainHealth((LivingEntity)victim);
            return true;
        }
        return false;
    }

    private void drainHealth(LivingEntity target) {
        double l = 0.0;
        ModifiableAttributeInstance a = target.func_233645_dx_().func_233779_a_(Attributes.field_233818_a_);
        AttributeModifier attr = a.func_111127_a(UUID.fromString("019ad91f-7288-4a0a-8a4b-23913e9fe341"));
        if (attr != null && (l = attr.func_111164_d()) == -1.0) {
            return;
        }
        if ((l -= 0.3333333432674408) < -1.0) {
            l = -1.0;
        }
        HashMultimap multimap = HashMultimap.create();
        multimap.put((Object)Attributes.field_233818_a_, (Object)new AttributeModifier(UUID.fromString("019ad91f-7288-4a0a-8a4b-23913e9fe341"), "Abyss Soul", l, AttributeModifier.Operation.MULTIPLY_TOTAL));
        target.func_233645_dx_().func_233793_b_((Multimap)multimap);
        if (l <= -1.0) {
            target.func_110142_aN().func_94547_a(new DamageSource("magic").func_76348_h().func_76359_i().func_151518_m(), target.func_110143_aJ(), target.func_110143_aJ());
            target.func_70606_j(0.0f);
            target.func_70645_a(new DamageSource("magic").func_76348_h().func_76359_i().func_151518_m());
            target.field_70725_aQ = 0;
            target.func_225653_b_(target.func_226277_ct_(), -114514.0, target.func_226281_cx_());
        }
    }

    public void attack(ItemStack stack, LivingEntity target, Multimap<Attribute, AttributeModifier> multimap, Attribute attribute, DamageSource source, LivingEntity attacker) {
        float amount = this.getAmount(stack, target, multimap, attribute);
        if (amount > 0.0f) {
            target.field_70737_aN = 0;
            target.func_70097_a(source, amount *= new Random().nextFloat());
        }
    }

    public float getAmount(ItemStack stack, LivingEntity target, Multimap<Attribute, AttributeModifier> multimap, Attribute attribute) {
        float amount = 0.0f;
        Collection gsd = multimap.get((Object)attribute);
        if (gsd != null) {
            for (AttributeModifier t : gsd) {
                float d0 = (float)t.func_111164_d();
                if (t.func_111167_a() == Item.field_111210_e) {
                    d0 = (float)((double)d0 + (double)EnchantmentHelper.func_152377_a((ItemStack)stack, (CreatureAttribute)target.func_70668_bt()));
                }
                amount += d0;
            }
        }
        return amount;
    }
}

