/*
 * Decompiled with CFR 0.152.
 */
package dqu.additionaladditions;

import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dqu.additionaladditions.AdditionalAdditions;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.fabricmc.loader.api.FabricLoader;

public class Config {
    public static final int VERSION = 1;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String PATH = FabricLoader.getInstance().getConfigDir().resolve("additional-additions-config.json").toString();
    private static final File DBFILE = new File(PATH);
    private static JsonObject db = new JsonObject();

    public static void load() {
        if (!DBFILE.exists()) {
            db.addProperty("version", (Number)1);
            db.addProperty("FoodItems", Boolean.valueOf(true));
            db.addProperty("WateringCan", Boolean.valueOf(true));
            db.addProperty("RoseGold", Boolean.valueOf(true));
            db.addProperty("Ropes", Boolean.valueOf(true));
            db.addProperty("EnchantmentPrecision", Boolean.valueOf(true));
            db.addProperty("Wrench", Boolean.valueOf(true));
            db.addProperty("CopperPatina", Boolean.valueOf(true));
            db.addProperty("AmethystLamp", Boolean.valueOf(true));
            db.addProperty("Crossbows", Boolean.valueOf(true));
            Config.save();
        }
        try {
            BufferedReader bufferedReader = Files.newReader((File)DBFILE, (Charset)StandardCharsets.UTF_8);
            db = (JsonObject)GSON.fromJson((Reader)bufferedReader, JsonObject.class);
        }
        catch (Exception e) {
            AdditionalAdditions.LOGGER.error(e.getMessage());
            AdditionalAdditions.LOGGER.error("Unable to load configuration file!");
        }
    }

    private static void save() {
        try {
            BufferedWriter bufferedWriter = Files.newWriter((File)DBFILE, (Charset)StandardCharsets.UTF_8);
            String json = GSON.toJson((JsonElement)db);
            bufferedWriter.write(json);
            bufferedWriter.close();
        }
        catch (Exception e) {
            AdditionalAdditions.LOGGER.error(e.getMessage());
            AdditionalAdditions.LOGGER.error("Unable to save configuration file!");
        }
    }

    public static boolean get(String key) {
        if (!DBFILE.exists()) {
            AdditionalAdditions.LOGGER.error("Unable to get key as file doesn't exist?!");
            return false;
        }
        return db.get(key).getAsBoolean();
    }
}

