/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.util;

import com.anthonyhilyard.iceberg.events.RenderTooltipEvents;
import com.anthonyhilyard.iceberg.util.GuiHelper;
import com.anthonyhilyard.iceberg.util.StringRecomposer;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.client.rendering.v1.TooltipComponentCallback;
import net.minecraft.class_1159;
import net.minecraft.class_1269;
import net.minecraft.class_1799;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraft.class_768;
import net.minecraft.class_918;

public class Tooltips {
    private static boolean initialized = false;
    private static class_918 itemRenderer = null;

    private static void init(class_310 minecraft) {
        itemRenderer = minecraft.method_1480();
        initialized = true;
    }

    public static void renderItemTooltip(class_1799 stack, class_4587 poseStack, TooltipInfo info, class_768 rect, int screenWidth, int screenHeight, int backgroundColor, int borderColorStart, int borderColorEnd) {
        Tooltips.renderItemTooltip(stack, poseStack, info, rect, screenWidth, screenHeight, backgroundColor, borderColorStart, borderColorEnd, false);
    }

    public static void renderItemTooltip(class_1799 stack, class_4587 poseStack, TooltipInfo info, class_768 rect, int screenWidth, int screenHeight, int backgroundColor, int borderColorStart, int borderColorEnd, boolean comparison) {
        Tooltips.renderItemTooltip(stack, poseStack, info, rect, screenWidth, screenHeight, backgroundColor, borderColorStart, borderColorEnd, comparison, false);
    }

    public static void renderItemTooltip(class_1799 stack, class_4587 poseStack, TooltipInfo info, class_768 rect, int screenWidth, int screenHeight, int backgroundColor, int borderColorStart, int borderColorEnd, boolean comparison, boolean constrain) {
        Tooltips.renderItemTooltip(stack, poseStack, info, rect, screenWidth, screenHeight, backgroundColor, backgroundColor, borderColorStart, borderColorEnd, comparison, constrain, false, 0);
    }

    public static void renderItemTooltip(class_1799 stack, class_4587 poseStack, TooltipInfo info, class_768 rect, int screenWidth, int screenHeight, int backgroundColorStart, int backgroundColorEnd, int borderColorStart, int borderColorEnd, boolean comparison, boolean constrain, boolean centeredTitle, int index) {
        int componentNumber;
        if (info.components.isEmpty()) {
            return;
        }
        if (!initialized) {
            Tooltips.init(class_310.method_1551());
        }
        if (centeredTitle) {
            info = new TooltipInfo(Tooltips.centerTitle(info.getComponents(), info.getFont(), rect.method_3319()), info.getFont());
        }
        int rectX = rect.method_3321() + 4;
        int rectY = rect.method_3322() + 4;
        RenderTooltipEvents.PreExtResult preResult = ((RenderTooltipEvents.PreExt)RenderTooltipEvents.PREEXT.invoker()).onPre(stack, info.getComponents(), poseStack, rectX, rectY, screenWidth, screenHeight, info.getFont(), comparison, index);
        if (preResult.result() != class_1269.field_5811) {
            return;
        }
        rectX = preResult.x();
        rectY = preResult.y();
        screenWidth = preResult.screenWidth();
        screenHeight = preResult.screenHeight();
        info.setFont(preResult.font());
        poseStack.method_22903();
        int zLevel = 400;
        float f = Tooltips.itemRenderer.field_4730;
        Tooltips.itemRenderer.field_4730 = 400.0f;
        class_1159 mat = poseStack.method_23760().method_23761();
        RenderTooltipEvents.ColorExtResult colors = ((RenderTooltipEvents.ColorExt)RenderTooltipEvents.COLOREXT.invoker()).onColor(stack, info.components, poseStack, rectX, rectY, info.getFont(), backgroundColorStart, backgroundColorEnd, borderColorStart, borderColorEnd, comparison, index);
        backgroundColorStart = colors.backgroundStart();
        backgroundColorEnd = colors.backgroundEnd();
        borderColorStart = colors.borderStart();
        borderColorEnd = colors.borderEnd();
        GuiHelper.drawGradientRect(mat, 400, rectX - 3, rectY - 4, rectX + rect.method_3319() + 3, rectY - 3, backgroundColorStart, backgroundColorStart);
        GuiHelper.drawGradientRect(mat, 400, rectX - 3, rectY + rect.method_3320() + 3, rectX + rect.method_3319() + 3, rectY + rect.method_3320() + 4, backgroundColorEnd, backgroundColorEnd);
        GuiHelper.drawGradientRect(mat, 400, rectX - 3, rectY - 3, rectX + rect.method_3319() + 3, rectY + rect.method_3320() + 3, backgroundColorStart, backgroundColorEnd);
        GuiHelper.drawGradientRect(mat, 400, rectX - 4, rectY - 3, rectX - 3, rectY + rect.method_3320() + 3, backgroundColorStart, backgroundColorEnd);
        GuiHelper.drawGradientRect(mat, 400, rectX + rect.method_3319() + 3, rectY - 3, rectX + rect.method_3319() + 4, rectY + rect.method_3320() + 3, backgroundColorStart, backgroundColorEnd);
        GuiHelper.drawGradientRect(mat, 400, rectX - 3, rectY - 3 + 1, rectX - 3 + 1, rectY + rect.method_3320() + 3 - 1, borderColorStart, borderColorEnd);
        GuiHelper.drawGradientRect(mat, 400, rectX + rect.method_3319() + 2, rectY - 3 + 1, rectX + rect.method_3319() + 3, rectY + rect.method_3320() + 3 - 1, borderColorStart, borderColorEnd);
        GuiHelper.drawGradientRect(mat, 400, rectX - 3, rectY - 3, rectX + rect.method_3319() + 3, rectY - 3 + 1, borderColorStart, borderColorStart);
        GuiHelper.drawGradientRect(mat, 400, rectX - 3, rectY + rect.method_3320() + 2, rectX + rect.method_3319() + 3, rectY + rect.method_3320() + 3, borderColorEnd, borderColorEnd);
        class_4597.class_4598 renderType = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
        poseStack.method_22904(0.0, 0.0, 400.0);
        int tooltipTop = rectY;
        for (componentNumber = 0; componentNumber < info.getComponents().size(); ++componentNumber) {
            class_5684 textComponent = info.getComponents().get(componentNumber);
            textComponent.method_32665(info.getFont(), rectX, tooltipTop, mat, renderType);
            tooltipTop += textComponent.method_32661() + (componentNumber == 0 ? 2 : 0);
        }
        renderType.method_22993();
        poseStack.method_22909();
        tooltipTop = rectY;
        for (componentNumber = 0; componentNumber < info.getComponents().size(); ++componentNumber) {
            class_5684 imageComponent = info.getComponents().get(componentNumber);
            imageComponent.method_32666(info.getFont(), rectX, tooltipTop, poseStack, itemRenderer, 400);
            tooltipTop += imageComponent.method_32661() + (componentNumber == 0 ? 2 : 0);
        }
        Tooltips.itemRenderer.field_4730 = f;
        ((RenderTooltipEvents.PostExt)RenderTooltipEvents.POSTEXT.invoker()).onPost(stack, info.getComponents(), poseStack, rectX, rectY, info.getFont(), rect.method_3319(), rect.method_3320(), comparison, index);
    }

    private static class_5684 getClientComponent(class_5632 componentData) {
        class_5684 result = null;
        try {
            result = class_5684.method_32663((class_5632)componentData);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (result == null) {
            result = ((TooltipComponentCallback)TooltipComponentCallback.EVENT.invoker()).getComponent(componentData);
        }
        try {
            result = (class_5684)componentData;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (result == null) {
            throw new IllegalArgumentException("Unknown TooltipComponent");
        }
        return result;
    }

    public static List<class_5684> gatherTooltipComponents(class_1799 stack, List<? extends class_5348> textElements, Optional<class_5632> itemComponent, int mouseX, int screenWidth, int screenHeight, class_327 forcedFont, class_327 fallbackFont, int maxWidth) {
        return Tooltips.gatherTooltipComponents(stack, textElements, itemComponent, mouseX, screenWidth, screenHeight, forcedFont, fallbackFont, maxWidth, 0);
    }

    public static List<class_5684> gatherTooltipComponents(class_1799 stack, List<? extends class_5348> textElements, Optional<class_5632> itemComponent, int mouseX, int screenWidth, int screenHeight, class_327 forcedFont, class_327 fallbackFont, int maxWidth, int index) {
        class_327 font = forcedFont == null ? fallbackFont : forcedFont;
        List elements = textElements.stream().map(Either::left).collect(Collectors.toCollection(ArrayList::new));
        itemComponent.ifPresent(c -> elements.add(1, Either.right((Object)c)));
        RenderTooltipEvents.GatherResult eventResult = ((RenderTooltipEvents.Gather)RenderTooltipEvents.GATHER.invoker()).onGather(stack, screenWidth, screenHeight, elements, maxWidth, index);
        if (eventResult.result() != class_1269.field_5811) {
            return List.of();
        }
        int tooltipTextWidth = eventResult.tooltipElements().stream().mapToInt(either -> (Integer)either.map(arg_0 -> ((class_327)font).method_27525(arg_0), component -> 0)).max().orElse(0);
        boolean needsWrap = false;
        int tooltipX = mouseX + 12;
        if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
            tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
            needsWrap = true;
        }
        if (eventResult.maxWidth() > 0 && tooltipTextWidth > eventResult.maxWidth()) {
            tooltipTextWidth = eventResult.maxWidth();
            needsWrap = true;
        }
        int tooltipTextWidthFinal = tooltipTextWidth;
        if (needsWrap) {
            return eventResult.tooltipElements().stream().flatMap(either -> (Stream)either.map(text -> font.method_1728(text, tooltipTextWidthFinal).stream().map(class_5684::method_32662), component -> Stream.of(Tooltips.getClientComponent(component)))).toList();
        }
        return eventResult.tooltipElements().stream().map(either -> (class_5684)either.map(text -> class_5684.method_32662((class_5481)(text instanceof class_2561 ? ((class_2561)text).method_30937() : class_2477.method_10517().method_30934(text))), Tooltips::getClientComponent)).toList();
    }

    public static class_768 calculateRect(class_1799 stack, class_4587 poseStack, List<class_5684> components, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth, class_327 font) {
        return Tooltips.calculateRect(stack, poseStack, components, mouseX, mouseY, screenWidth, screenHeight, maxTextWidth, font, 0, false);
    }

    public static class_768 calculateRect(class_1799 stack, class_4587 poseStack, List<class_5684> components, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth, class_327 font, int minWidth, boolean centeredTitle) {
        int tooltipHeight;
        class_768 rect = new class_768(0, 0, 0, 0);
        if (components == null || components.isEmpty() || stack == null) {
            return rect;
        }
        RenderTooltipEvents.PreExtResult preResult = ((RenderTooltipEvents.PreExt)RenderTooltipEvents.PREEXT.invoker()).onPre(stack, components, poseStack, mouseX, mouseY, screenWidth, screenHeight, font, false, 0);
        if (preResult.result() != class_1269.field_5811) {
            return rect;
        }
        mouseX = preResult.x();
        mouseY = preResult.y();
        screenWidth = preResult.screenWidth();
        screenHeight = preResult.screenHeight();
        font = preResult.font();
        int tooltipTextWidth = minWidth;
        int n = tooltipHeight = components.size() == 1 ? -2 : 0;
        if (centeredTitle) {
            components = Tooltips.centerTitle(components, font, minWidth);
        }
        for (class_5684 component : components) {
            int componentWidth = component.method_32664(font);
            if (componentWidth > tooltipTextWidth) {
                tooltipTextWidth = componentWidth;
            }
            tooltipHeight += component.method_32661();
        }
        int tooltipX = mouseX + 12;
        int tooltipY = mouseY - 12;
        if (tooltipX + tooltipTextWidth > screenWidth) {
            tooltipX -= 28 + tooltipTextWidth;
        }
        if (tooltipY + tooltipHeight + 6 > screenHeight) {
            tooltipY = screenHeight - tooltipHeight - 6;
        }
        rect = new class_768(tooltipX - 2, tooltipY - 4, tooltipTextWidth, tooltipHeight);
        return rect;
    }

    public static List<class_5684> centerTitle(List<class_5684> components, class_327 font, int minWidth) {
        int tooltipWidth = minWidth;
        for (class_5684 clienttooltipcomponent : components) {
            if (clienttooltipcomponent == null) {
                return components;
            }
            int componentWidth = clienttooltipcomponent.method_32664(font);
            if (componentWidth <= tooltipWidth) continue;
            tooltipWidth = componentWidth;
        }
        List<class_5348> recomposedLines = StringRecomposer.recompose(List.of(components.get(0)));
        if (recomposedLines.isEmpty()) {
            return components;
        }
        ArrayList<class_5684> result = new ArrayList<class_5684>(components);
        class_5481 title = class_2477.method_10517().method_30934(recomposedLines.get(0));
        class_5481 space = class_5481.method_30747((String)" ", (class_2583)class_2583.field_24360);
        while (((class_5684)result.get(0)).method_32664(font) < tooltipWidth && (title = class_5481.method_30755(List.of(space, title, space))) != null) {
            result.set(0, class_5684.method_32662((class_5481)title));
        }
        return result;
    }

    public static class TooltipInfo {
        private int tooltipWidth = 0;
        private int titleLines = 1;
        private class_327 font;
        private List<class_5684> components = new ArrayList<class_5684>();

        public TooltipInfo(List<class_5684> components, class_327 font) {
            this.components = components;
            this.font = font;
        }

        public int getTooltipWidth() {
            return this.tooltipWidth;
        }

        public int getTitleLines() {
            return this.titleLines;
        }

        public class_327 getFont() {
            return this.font;
        }

        public List<class_5684> getComponents() {
            return this.components;
        }

        public void setFont(class_327 font) {
            this.font = font;
        }

        public int getMaxLineWidth() {
            int width = 0;
            for (class_5684 component : this.components) {
                int textLineWidth = component.method_32664(this.font);
                if (textLineWidth <= width) continue;
                width = textLineWidth;
            }
            return width;
        }
    }
}

