/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.util;

import com.anthonyhilyard.iceberg.util.ItemColor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;

public class Selectors {
    private static Map<String, Rarity> rarities = new HashMap<String, Rarity>(){
        {
            this.put("common", Rarity.COMMON);
            this.put("uncommon", Rarity.UNCOMMON);
            this.put("rare", Rarity.RARE);
            this.put("epic", Rarity.EPIC);
        }
    };
    private static Map<String, BiPredicate<Tag, String>> nbtComparators = new HashMap<String, BiPredicate<Tag, String>>(){
        {
            this.put("=", (tag, value) -> tag.m_7916_().contentEquals((CharSequence)value));
            this.put("!=", (tag, value) -> !tag.m_7916_().contentEquals((CharSequence)value));
            this.put(">", (tag, value) -> {
                try {
                    double parsedValue = Double.valueOf(value);
                    if (tag instanceof NumericTag) {
                        return ((NumericTag)tag).m_7061_() > parsedValue;
                    }
                    return false;
                }
                catch (Exception e) {
                    return false;
                }
            });
            this.put("<", (tag, value) -> {
                try {
                    double parsedValue = Double.valueOf(value);
                    if (tag instanceof NumericTag) {
                        return ((NumericTag)tag).m_7061_() < parsedValue;
                    }
                    return false;
                }
                catch (Exception e) {
                    return false;
                }
            });
        }
    };

    public static boolean validateSelector(String value) {
        if (value.startsWith("$")) {
            return ResourceLocation.m_135830_((String)value.substring(1));
        }
        if (value.startsWith("@")) {
            return value.substring(1).matches("^[a-z][a-z0-9_-]{1,63}$");
        }
        if (value.startsWith("!")) {
            return rarities.keySet().contains(value.substring(1).toLowerCase());
        }
        if (value.startsWith("#")) {
            return TextColor.m_131268_((String)value) != null;
        }
        if (value.startsWith("%") || value.startsWith("^")) {
            return true;
        }
        if (value.startsWith("&")) {
            return true;
        }
        return value == null || value == "" || ResourceLocation.m_135830_((String)value);
    }

    public static boolean itemMatches(ItemStack item, String selector) {
        String itemResourceLocation = item.m_41720_().getRegistryName().toString();
        if (selector.equals(itemResourceLocation) || selector.equals(itemResourceLocation.replace("minecraft:", ""))) {
            return true;
        }
        if (selector.startsWith("#")) {
            TextColor entryColor = TextColor.m_131268_((String)selector);
            if (entryColor != null && entryColor.equals((Object)ItemColor.getColorForItem(item, TextColor.m_131266_((int)0xFFFFFF)))) {
                return true;
            }
        } else if (selector.startsWith("!")) {
            if (item.m_41791_() == rarities.get(selector.substring(1))) {
                return true;
            }
        } else if (selector.startsWith("@")) {
            if (itemResourceLocation.startsWith(selector.substring(1) + ":")) {
                return true;
            }
        } else if (selector.startsWith("$")) {
            if (ItemTags.m_13193_().m_7689_(new ResourceLocation(selector.substring(1))).m_6497_().contains(item.m_41720_())) {
                return true;
            }
        } else if (selector.startsWith("%")) {
            if (item.m_41611_().getString().contains(selector.substring(1))) {
                return true;
            }
        } else if (selector.startsWith("^")) {
            Minecraft mc = Minecraft.m_91087_();
            List lines = item.m_41651_((Player)mc.f_91074_, (TooltipFlag)TooltipFlag.Default.ADVANCED);
            Object tooltipText = "";
            for (int n = 1; n < lines.size(); ++n) {
                tooltipText = (String)tooltipText + ((Component)lines.get(n)).getString() + "\n";
            }
            if (((String)tooltipText).contains(selector.substring(1))) {
                return true;
            }
        } else if (selector.startsWith("&")) {
            Tag matchedTag;
            String tagName = selector.substring(1);
            String tagValue = null;
            BiPredicate<Tag, String> valueChecker = null;
            for (String comparator : nbtComparators.keySet()) {
                if (!tagName.contains(comparator)) continue;
                valueChecker = nbtComparators.get(comparator);
                String[] components = tagName.split(comparator);
                tagName = components[0];
                if (components.length <= 1) break;
                tagValue = components[1];
                break;
            }
            if ((matchedTag = Selectors.getSubtag(item.m_41783_(), tagName)) != null) {
                if (tagValue == null) {
                    return true;
                }
                if (valueChecker != null) {
                    return valueChecker.test(matchedTag, tagValue);
                }
            }
        }
        return false;
    }

    private static Tag getSubtag(CompoundTag tag, String key) {
        if (tag == null) {
            return null;
        }
        if (tag.m_128441_(key)) {
            return tag.m_128423_(key);
        }
        for (String innerKey : tag.m_128431_()) {
            Tag innerTag;
            if (tag.m_128435_(innerKey) != 10 || (innerTag = Selectors.getSubtag(tag.m_128469_(innerKey), key)) == null) continue;
            return innerTag;
        }
        return null;
    }
}

