/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.mixin;

import com.anthonyhilyard.iceberg.config.IcebergConfigSpec;
import com.electronwill.nightconfig.core.AbstractConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.mrcrayfish.configured.util.ConfigHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ConfigHelper.class})
public class ConfiguredConfigHelperMixin {
    @Inject(method={"gatherAllConfigValues(Lnet/minecraftforge/fml/config/ModConfig;)Ljava/util/List;"}, at={@At(value="HEAD")}, cancellable=true, remap=false, require=0)
    private static void gatherAllConfigValuesIcebergSupport(ModConfig config, CallbackInfoReturnable<List<?>> info) {
        IConfigSpec iConfigSpec = config.getSpec();
        if (iConfigSpec instanceof IcebergConfigSpec) {
            IcebergConfigSpec icebergConfigSpec = (IcebergConfigSpec)iConfigSpec;
            ArrayList values = new ArrayList();
            ConfiguredConfigHelperMixin.gatherValuesFromIcebergConfig(icebergConfigSpec.getValues(), icebergConfigSpec, values);
            info.setReturnValue(values);
        }
    }

    private static void gatherValuesFromIcebergConfig(UnmodifiableConfig config, IcebergConfigSpec spec, List<Pair<ForgeConfigSpec.ConfigValue<?>, ForgeConfigSpec.ValueSpec>> values) {
        config.valueMap().forEach((s, o) -> {
            if (o instanceof AbstractConfig) {
                ConfiguredConfigHelperMixin.gatherValuesFromIcebergConfig((UnmodifiableConfig)o, spec, values);
            } else if (o instanceof ForgeConfigSpec.ConfigValue) {
                ForgeConfigSpec.ConfigValue configValue = (ForgeConfigSpec.ConfigValue)o;
                ForgeConfigSpec.ValueSpec valueSpec = (ForgeConfigSpec.ValueSpec)spec.getRaw(configValue.getPath());
                values.add(Pair.of((Object)configValue, (Object)valueSpec));
            }
        });
    }
}

