/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.mixin;

import com.anthonyhilyard.iceberg.Loader;
import com.anthonyhilyard.iceberg.config.IcebergConfigSpec;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mrcrayfish.configured.client.screen.ConfigScreen;
import com.mrcrayfish.configured.client.screen.ListMenuScreen;
import com.mrcrayfish.configured.client.screen.ModConfigSelectionScreen;
import com.mrcrayfish.configured.client.screen.WorldSelectionScreen;
import com.mrcrayfish.configured.client.screen.widget.IconButton;
import com.mrcrayfish.configured.util.ConfigHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.narration.ScreenNarrationCollector;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.unsafe.UnsafeHacks;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ModConfigSelectionScreen.FileItem.class})
public class ConfiguredModConfigSelectionScreenMixin {
    @Shadow(aliases={"this$0"}, remap=false)
    @Final
    ModConfigSelectionScreen this$0;
    @Shadow(remap=false)
    @Final
    protected ModConfig config;
    @Shadow(remap=false)
    @Final
    protected Component title;

    @Shadow(remap=false)
    private boolean hasRequiredPermission() {
        return true;
    }

    @Inject(method={"createModifyButton"}, at={@At(value="HEAD")}, remap=false, cancellable=true, require=0)
    private void createModifyButton(ModConfig config, CallbackInfoReturnable<Button> info) {
        if (config.getSpec() instanceof IcebergConfigSpec) {
            Minecraft minecraft = Minecraft.m_91087_();
            boolean serverConfig = config.getType() == ModConfig.Type.SERVER && Minecraft.m_91087_().f_91073_ == null;
            String langKey = serverConfig ? "configured.gui.select_world" : "configured.gui.modify";
            ResourceLocation backgroundTemp = null;
            try {
                Field backgroundField = ListMenuScreen.class.getDeclaredField("background");
                backgroundField.setAccessible(true);
                backgroundTemp = (ResourceLocation)backgroundField.get(this.this$0);
            }
            catch (Exception e) {
                Loader.LOGGER.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
            ResourceLocation background = backgroundTemp;
            info.setReturnValue((Object)new IconButton(0, 0, serverConfig ? 44 : 33, 0, serverConfig ? 80 : 60, (Component)Component.m_237115_((String)langKey), onPress -> {
                if (!(!ConfigScreen.isPlayingGame() || this.config.getType() != ModConfig.Type.SERVER || ConfigHelper.isConfiguredInstalledOnServer() && this.hasRequiredPermission())) {
                    return;
                }
                if (serverConfig) {
                    minecraft.m_91152_((Screen)new WorldSelectionScreen((Screen)this.this$0, background, config, this.title));
                } else {
                    ModList.get().getModContainerById(config.getModId()).ifPresent(container -> {
                        try {
                            ConfigScreen configScreen = (ConfigScreen)UnsafeHacks.newInstance(ConfigScreen.class);
                            Field titleField = Screen.class.getDeclaredField("f_96539_");
                            Field childrenField = Screen.class.getDeclaredField("f_96540_");
                            Field narratablesField = Screen.class.getDeclaredField("f_169368_");
                            Field renderablesField = Screen.class.getDeclaredField("f_169369_");
                            Field narrationStateField = Screen.class.getDeclaredField("f_169375_");
                            Field parentField = configScreen.getClass().getSuperclass().getDeclaredField("parent");
                            Field backgroundField = configScreen.getClass().getSuperclass().getDeclaredField("background");
                            Field itemHeightField = configScreen.getClass().getSuperclass().getDeclaredField("itemHeight");
                            titleField.setAccessible(true);
                            childrenField.setAccessible(true);
                            narratablesField.setAccessible(true);
                            renderablesField.setAccessible(true);
                            narrationStateField.setAccessible(true);
                            parentField.setAccessible(true);
                            backgroundField.setAccessible(true);
                            itemHeightField.setAccessible(true);
                            titleField.set(configScreen, Component.m_237113_((String)container.getModInfo().getDisplayName()));
                            childrenField.set(configScreen, Lists.newArrayList());
                            narratablesField.set(configScreen, Lists.newArrayList());
                            renderablesField.set(configScreen, Lists.newArrayList());
                            narrationStateField.set(configScreen, new ScreenNarrationCollector());
                            parentField.set(configScreen, this.this$0);
                            backgroundField.set(configScreen, background);
                            itemHeightField.set(configScreen, 24);
                            ForgeConfigSpec dummySpec = new ForgeConfigSpec.Builder().build();
                            FieldUtils.writeDeclaredField((Object)configScreen, (String)"folderEntry", (Object)((Object)new IcebergFolderEntry(configScreen, List.of(), ((IcebergConfigSpec)config.getSpec()).getValues(), dummySpec, (IcebergConfigSpec)config.getSpec())), (boolean)true);
                            FieldUtils.writeDeclaredField((Object)configScreen, (String)"config", (Object)config, (boolean)true);
                            minecraft.m_91152_((Screen)configScreen);
                        }
                        catch (Exception e) {
                            Loader.LOGGER.error(ExceptionUtils.getStackTrace((Throwable)e));
                        }
                    });
                }
            }, (button, poseStack, mouseX, mouseY) -> {
                if (button.m_198029_()) {
                    if (ConfigScreen.isPlayingGame() && !ConfigHelper.isConfiguredInstalledOnServer()) {
                        this.this$0.m_96617_(poseStack, minecraft.f_91062_.m_92923_((FormattedText)Component.m_237115_((String)"configured.gui.not_installed").m_130940_(ChatFormatting.RED), Math.max(this.this$0.f_96543_ / 2 - 43, 170)), mouseX, mouseY);
                    } else if (!this.hasRequiredPermission()) {
                        this.this$0.m_96617_(poseStack, minecraft.f_91062_.m_92923_((FormattedText)Component.m_237115_((String)"configured.gui.no_permission").m_130940_(ChatFormatting.RED), Math.max(this.this$0.f_96543_ / 2 - 43, 170)), mouseX, mouseY);
                    }
                }
            }));
        }
    }

    public class IcebergFolderEntry
    extends ConfigScreen.FolderEntry {
        private IcebergConfigSpec icebergConfigSpec;
        private ForgeConfigSpec spec;
        private ConfigScreen configScreen;
        private UnmodifiableConfig config;
        private final List<String> path;

        public IcebergFolderEntry(ConfigScreen configScreen, List<String> path, UnmodifiableConfig config, ForgeConfigSpec spec, IcebergConfigSpec icebergSpec) {
            ConfigScreen configScreen2 = configScreen;
            Objects.requireNonNull(configScreen2);
            super(configScreen2, path, config, spec);
            this.icebergConfigSpec = icebergSpec;
            this.spec = spec;
            this.configScreen = configScreen;
            this.config = config;
            this.path = path;
            this.init();
        }

        private void init() {
            try {
                Field entriesField = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField("entries");
                entriesField.setAccessible(true);
                ImmutableList.Builder builder = ImmutableList.builder();
                this.config.valueMap().forEach((key, value) -> {
                    ForgeConfigSpec.ConfigValue configValue;
                    ForgeConfigSpec.ValueSpec valueSpec;
                    ForgeConfigSpec.ValueSpec valueSpec2;
                    if (value instanceof ForgeConfigSpec.ValueSpec && (valueSpec2 = (ForgeConfigSpec.ValueSpec)value).getDefault() instanceof UnmodifiableConfig) {
                        value = valueSpec2.getDefault();
                    }
                    if (value instanceof UnmodifiableConfig) {
                        ArrayList<String> path = new ArrayList<String>(this.path);
                        path.add((String)key);
                        builder.add((Object)new IcebergFolderEntry(this.configScreen, path, (UnmodifiableConfig)value, this.spec, this.icebergConfigSpec));
                    } else if (value instanceof ForgeConfigSpec.ConfigValue && (valueSpec = (ForgeConfigSpec.ValueSpec)this.icebergConfigSpec.getRaw((configValue = (ForgeConfigSpec.ConfigValue)value).getPath())) != null) {
                        ConfigScreen configScreen = this.configScreen;
                        Objects.requireNonNull(configScreen);
                        builder.add((Object)new ConfigScreen.ValueEntry(configScreen, configValue, valueSpec));
                    }
                });
                entriesField.set((Object)this, builder.build());
            }
            catch (Exception e) {
                Loader.LOGGER.error(ExceptionUtils.getStackTrace((Throwable)e));
                return;
            }
        }
    }
}

