/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.util;

import com.anthonyhilyard.iceberg.events.GatherComponentsExtEvent;
import com.anthonyhilyard.iceberg.events.RenderTooltipExtEvent;
import com.anthonyhilyard.iceberg.util.GuiHelper;
import com.anthonyhilyard.iceberg.util.StringRecomposer;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.datafixers.util.Either;
import com.mojang.math.Matrix4f;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class Tooltips {
    private static final FormattedCharSequence SPACE = FormattedCharSequence.m_13714_((String)" ", (Style)Style.f_131099_);
    private static ItemRenderer itemRenderer = null;

    public static void renderItemTooltip(@Nonnull ItemStack stack, PoseStack poseStack, TooltipInfo info, Rect2i rect, int screenWidth, int screenHeight, int backgroundColor, int borderColorStart, int borderColorEnd) {
        Tooltips.renderItemTooltip(stack, poseStack, info, rect, screenWidth, screenHeight, backgroundColor, borderColorStart, borderColorEnd, false);
    }

    public static void renderItemTooltip(@Nonnull ItemStack stack, PoseStack poseStack, TooltipInfo info, Rect2i rect, int screenWidth, int screenHeight, int backgroundColor, int borderColorStart, int borderColorEnd, boolean comparison) {
        Tooltips.renderItemTooltip(stack, poseStack, info, rect, screenWidth, screenHeight, backgroundColor, borderColorStart, borderColorEnd, comparison, false);
    }

    public static void renderItemTooltip(@Nonnull ItemStack stack, PoseStack poseStack, TooltipInfo info, Rect2i rect, int screenWidth, int screenHeight, int backgroundColor, int borderColorStart, int borderColorEnd, boolean comparison, boolean constrain) {
        Tooltips.renderItemTooltip(stack, poseStack, info, rect, screenWidth, screenHeight, backgroundColor, backgroundColor, borderColorStart, borderColorEnd, comparison, constrain, false, 0);
    }

    public static void renderItemTooltip(@Nonnull ItemStack stack, PoseStack poseStack, TooltipInfo info, Rect2i rect, int screenWidth, int screenHeight, int backgroundColorStart, int backgroundColorEnd, int borderColorStart, int borderColorEnd, boolean comparison, boolean constrain, boolean centeredTitle, int index) {
        int componentNumber;
        int rectY;
        int rectX;
        RenderTooltipExtEvent.Pre preEvent;
        if (info.getComponents().isEmpty()) {
            return;
        }
        if (itemRenderer == null) {
            itemRenderer = Minecraft.m_91087_().m_91291_();
        }
        if (centeredTitle) {
            info = new TooltipInfo(Tooltips.centerTitle(info.getComponents(), info.getFont(), rect.m_110090_()), info.getFont());
        }
        if (MinecraftForge.EVENT_BUS.post((Event)(preEvent = new RenderTooltipExtEvent.Pre(stack, poseStack, rectX = rect.m_110085_() + 4, rectY = rect.m_110086_() + 4, screenWidth, screenHeight, info.getFont(), info.getComponents(), comparison, index)))) {
            return;
        }
        rectX = preEvent.getX();
        rectY = preEvent.getY();
        screenWidth = preEvent.getScreenWidth();
        screenHeight = preEvent.getScreenHeight();
        info.setFont(preEvent.getFont());
        poseStack.m_85836_();
        int zLevel = 400;
        float f = Tooltips.itemRenderer.f_115093_;
        Tooltips.itemRenderer.f_115093_ = 400.0f;
        Matrix4f mat = poseStack.m_85850_().m_85861_();
        RenderTooltipExtEvent.Color colorEvent = new RenderTooltipExtEvent.Color(stack, poseStack, rectX, rectY, info.getFont(), backgroundColorStart, backgroundColorEnd, borderColorStart, borderColorEnd, info.getComponents(), comparison, index);
        MinecraftForge.EVENT_BUS.post((Event)colorEvent);
        backgroundColorStart = colorEvent.getBackgroundStart();
        backgroundColorEnd = colorEvent.getBackgroundEnd();
        borderColorStart = colorEvent.getBorderStart();
        borderColorEnd = colorEvent.getBorderEnd();
        GuiHelper.drawGradientRect(mat, 400, rectX - 3, rectY - 4, rectX + rect.m_110090_() + 3, rectY - 3, backgroundColorStart, backgroundColorStart);
        GuiHelper.drawGradientRect(mat, 400, rectX - 3, rectY + rect.m_110091_() + 3, rectX + rect.m_110090_() + 3, rectY + rect.m_110091_() + 4, backgroundColorEnd, backgroundColorEnd);
        GuiHelper.drawGradientRect(mat, 400, rectX - 3, rectY - 3, rectX + rect.m_110090_() + 3, rectY + rect.m_110091_() + 3, backgroundColorStart, backgroundColorEnd);
        GuiHelper.drawGradientRect(mat, 400, rectX - 4, rectY - 3, rectX - 3, rectY + rect.m_110091_() + 3, backgroundColorStart, backgroundColorEnd);
        GuiHelper.drawGradientRect(mat, 400, rectX + rect.m_110090_() + 3, rectY - 3, rectX + rect.m_110090_() + 4, rectY + rect.m_110091_() + 3, backgroundColorStart, backgroundColorEnd);
        GuiHelper.drawGradientRect(mat, 400, rectX - 3, rectY - 3 + 1, rectX - 3 + 1, rectY + rect.m_110091_() + 3 - 1, borderColorStart, borderColorEnd);
        GuiHelper.drawGradientRect(mat, 400, rectX + rect.m_110090_() + 2, rectY - 3 + 1, rectX + rect.m_110090_() + 3, rectY + rect.m_110091_() + 3 - 1, borderColorStart, borderColorEnd);
        GuiHelper.drawGradientRect(mat, 400, rectX - 3, rectY - 3, rectX + rect.m_110090_() + 3, rectY - 3 + 1, borderColorStart, borderColorStart);
        GuiHelper.drawGradientRect(mat, 400, rectX - 3, rectY + rect.m_110091_() + 2, rectX + rect.m_110090_() + 3, rectY + rect.m_110091_() + 3, borderColorEnd, borderColorEnd);
        MultiBufferSource.BufferSource renderType = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        poseStack.m_85837_(0.0, 0.0, 400.0);
        int tooltipTop = rectY;
        for (componentNumber = 0; componentNumber < info.getComponents().size(); ++componentNumber) {
            ClientTooltipComponent textComponent = info.getComponents().get(componentNumber);
            textComponent.m_142440_(preEvent.getFont(), rectX, tooltipTop, mat, renderType);
            tooltipTop += textComponent.m_142103_() + (componentNumber == 0 ? 2 : 0);
        }
        renderType.m_109911_();
        poseStack.m_85849_();
        tooltipTop = rectY;
        for (componentNumber = 0; componentNumber < info.getComponents().size(); ++componentNumber) {
            ClientTooltipComponent imageComponent = info.getComponents().get(componentNumber);
            imageComponent.m_183452_(preEvent.getFont(), rectX, tooltipTop, poseStack, itemRenderer, 400);
            tooltipTop += imageComponent.m_142103_() + (componentNumber == 0 ? 2 : 0);
        }
        Tooltips.itemRenderer.f_115093_ = f;
        RenderTooltipExtEvent.Post postEvent = new RenderTooltipExtEvent.Post(stack, poseStack, rectX, rectY, info.getFont(), rect.m_110090_(), rect.m_110091_(), info.getComponents(), comparison, index);
        MinecraftForge.EVENT_BUS.post((Event)postEvent);
    }

    public static List<ClientTooltipComponent> gatherTooltipComponents(ItemStack stack, List<? extends FormattedText> textElements, Optional<TooltipComponent> itemComponent, int mouseX, int screenWidth, int screenHeight, @Nullable Font forcedFont, Font fallbackFont, int maxWidth) {
        return Tooltips.gatherTooltipComponents(stack, textElements, itemComponent, mouseX, screenWidth, screenHeight, forcedFont, fallbackFont, maxWidth, 0);
    }

    public static List<ClientTooltipComponent> gatherTooltipComponents(ItemStack stack, List<? extends FormattedText> textElements, Optional<TooltipComponent> itemComponent, int mouseX, int screenWidth, int screenHeight, @Nullable Font forcedFont, Font fallbackFont, int maxWidth, int index) {
        Font font = ForgeHooksClient.getTooltipFont((Font)forcedFont, (ItemStack)stack, (Font)fallbackFont);
        List elements = textElements.stream().map(Either::left).collect(Collectors.toCollection(ArrayList::new));
        itemComponent.ifPresent(c -> elements.add(1, Either.right((Object)c)));
        GatherComponentsExtEvent event = new GatherComponentsExtEvent(stack, screenWidth, screenHeight, elements, maxWidth, index);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return List.of();
        }
        int tooltipTextWidth = event.getTooltipElements().stream().mapToInt(either -> (Integer)either.map(arg_0 -> ((Font)font).m_92852_(arg_0), component -> 0)).max().orElse(0);
        boolean needsWrap = false;
        int tooltipX = mouseX + 12;
        if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
            tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
            needsWrap = true;
        }
        if (event.getMaxWidth() > 0 && tooltipTextWidth > event.getMaxWidth()) {
            tooltipTextWidth = event.getMaxWidth();
            needsWrap = true;
        }
        int tooltipTextWidthFinal = tooltipTextWidth;
        if (needsWrap) {
            return event.getTooltipElements().stream().flatMap(either -> (Stream)either.map(text -> font.m_92923_(text, tooltipTextWidthFinal).stream().map(ClientTooltipComponent::m_169948_), component -> Stream.of(ClientTooltipComponent.m_169950_((TooltipComponent)component)))).toList();
        }
        return event.getTooltipElements().stream().map(either -> (ClientTooltipComponent)either.map(text -> ClientTooltipComponent.m_169948_((FormattedCharSequence)(text instanceof Component ? ((Component)text).m_7532_() : Language.m_128107_().m_5536_(text))), ClientTooltipComponent::m_169950_)).toList();
    }

    public static Rect2i calculateRect(ItemStack stack, PoseStack poseStack, List<ClientTooltipComponent> components, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth, Font font) {
        return Tooltips.calculateRect(stack, poseStack, components, mouseX, mouseY, screenWidth, screenHeight, maxTextWidth, font, 0, false);
    }

    public static Rect2i calculateRect(ItemStack stack, PoseStack poseStack, List<ClientTooltipComponent> components, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth, Font font, int minWidth, boolean centeredTitle) {
        int tooltipHeight;
        Rect2i rect = new Rect2i(0, 0, 0, 0);
        if (components == null || components.isEmpty() || stack == null) {
            return rect;
        }
        RenderTooltipEvent.Pre event = new RenderTooltipEvent.Pre(stack, poseStack, mouseX, mouseY, screenWidth, screenHeight, font, components);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return rect;
        }
        mouseX = event.getX();
        mouseY = event.getY();
        screenWidth = event.getScreenWidth();
        screenHeight = event.getScreenHeight();
        font = event.getFont();
        int tooltipTextWidth = minWidth;
        int n = tooltipHeight = components.size() == 1 ? -2 : 0;
        if (centeredTitle) {
            components = Tooltips.centerTitle(components, font, minWidth);
        }
        for (ClientTooltipComponent component : components) {
            int componentWidth = component.m_142069_(event.getFont());
            if (componentWidth > tooltipTextWidth) {
                tooltipTextWidth = componentWidth;
            }
            tooltipHeight += component.m_142103_();
        }
        int tooltipX = mouseX + 12;
        int tooltipY = mouseY - 12;
        if (tooltipX + tooltipTextWidth > screenWidth) {
            tooltipX -= 28 + tooltipTextWidth;
        }
        if (tooltipY + tooltipHeight + 6 > screenHeight) {
            tooltipY = screenHeight - tooltipHeight - 6;
        }
        rect = new Rect2i(tooltipX - 2, tooltipY - 4, tooltipTextWidth, tooltipHeight);
        return rect;
    }

    public static List<ClientTooltipComponent> centerTitle(List<ClientTooltipComponent> components, Font font, int minWidth) {
        int tooltipWidth = minWidth;
        for (ClientTooltipComponent clienttooltipcomponent : components) {
            if (clienttooltipcomponent == null) {
                return components;
            }
            int componentWidth = clienttooltipcomponent.m_142069_(font);
            if (componentWidth <= tooltipWidth) continue;
            tooltipWidth = componentWidth;
        }
        List<FormattedText> recomposedLines = StringRecomposer.recompose(List.of(components.get(0)));
        if (recomposedLines.isEmpty()) {
            return components;
        }
        ArrayList<ClientTooltipComponent> result = new ArrayList<ClientTooltipComponent>(components);
        FormattedCharSequence title = Language.m_128107_().m_5536_(recomposedLines.get(0));
        while (((ClientTooltipComponent)result.get(0)).m_142069_(font) < tooltipWidth && (title = FormattedCharSequence.m_13744_(List.of(SPACE, title, SPACE))) != null) {
            result.set(0, ClientTooltipComponent.m_169948_((FormattedCharSequence)title));
        }
        return result;
    }

    public static class TooltipInfo {
        private int tooltipWidth = 0;
        private int titleLines = 1;
        private Font font;
        private List<ClientTooltipComponent> components = new ArrayList<ClientTooltipComponent>();

        public TooltipInfo(List<ClientTooltipComponent> components, Font font) {
            this.components = components;
            this.font = font;
        }

        public int getTooltipWidth() {
            return this.tooltipWidth;
        }

        public int getTooltipHeight() {
            return this.components.size() > this.titleLines ? this.components.size() * 10 + 2 : 8;
        }

        public int getTitleLines() {
            return this.titleLines;
        }

        public Font getFont() {
            return this.font;
        }

        public List<ClientTooltipComponent> getComponents() {
            return this.components;
        }

        public void setFont(Font font) {
            this.font = font;
        }

        public int getMaxLineWidth() {
            return this.getMaxLineWidth(0);
        }

        public int getMaxLineWidth(int minWidth) {
            int textWidth = minWidth;
            for (ClientTooltipComponent component : this.components) {
                int componentWidth = component.m_142069_(this.font);
                if (componentWidth <= textWidth) continue;
                textWidth = componentWidth;
            }
            return textWidth;
        }
    }
}

