/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.gui.config.widgets;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4069;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5481;
import net.minecraft.class_5499;
import net.minecraft.class_5676;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraftforge.client.gui.config.widgets.ConfigGuiWidgetFactory;
import net.minecraftforge.client.gui.config.widgets.SpecificationData;
import net.minecraftforge.client.gui.config.widgets.ValueManager;
import net.minecraftforge.client.gui.widget.ColoredEditBox;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.mixin.client.accessor.AbstractWidgetAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigGuiWidget
implements class_4069,
class_5499,
class_6379 {
    @Nullable
    private class_364 focused;
    @Nullable
    private class_6379 lastNarratable;
    private boolean dragging;
    @NotNull
    private final ForgeConfigSpec.ValueSpec spec;
    @NotNull
    private final ValueManager valueManager;

    protected ConfigGuiWidget(@NotNull ForgeConfigSpec.ValueSpec spec, @NotNull ValueManager valueManager) {
        this.spec = spec;
        this.valueManager = valueManager;
    }

    public boolean method_25397() {
        return this.dragging;
    }

    public void method_25398(boolean isDragging) {
        this.dragging = isDragging;
    }

    @Nullable
    public class_364 method_25399() {
        return this.focused;
    }

    public void method_25395(@Nullable class_364 newFocus) {
        this.focused = newFocus;
    }

    public void method_37020(@NotNull class_6382 output) {
        List<? extends class_6379> narratables = this.narratables();
        class_437.class_6390 searchResult = class_437.method_37061(narratables, (class_6379)this.lastNarratable);
        if (searchResult != null) {
            if (searchResult.field_33827.method_37028()) {
                this.lastNarratable = searchResult.field_33825;
            }
            if (narratables.size() > 1) {
                output.method_37034(class_6381.field_33789, (class_2561)class_2561.method_43469((String)"narrator.position.object_list", (Object[])new Object[]{searchResult.field_33826 + 1, narratables.size()}));
                if (searchResult.field_33827 == class_6379.class_6380.field_33786) {
                    output.method_37034(class_6381.field_33791, (class_2561)class_2561.method_43471((String)"narration.component_list.usage"));
                }
            }
            searchResult.field_33825.method_37020(output.method_37031());
        }
    }

    @NotNull
    public ForgeConfigSpec.ValueSpec getSpec() {
        return this.spec;
    }

    @NotNull
    public ValueManager getValueManager() {
        return this.valueManager;
    }

    public abstract boolean isValid();

    protected abstract void setValue(@NotNull Object var1);

    public abstract Object getValue();

    public abstract List<? extends class_6379> narratables();

    public abstract void render(class_4587 var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8, float var9);

    public class_2561 getError() {
        return this.spec.getError(this.getValue());
    }

    public void resetToDefault() {
        this.setValue(this.getSpec().getDefault());
        this.valueManager.setter().accept(this.getValue());
    }

    public void resetToInitial() {
        this.setValue(this.getValueManager().initial().get());
        this.valueManager.setter().accept(this.getValue());
    }

    @NotNull
    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33785;
    }

    public static class NumberWidget<T extends Number>
    extends EditBoxBasedWidget {
        public static ConfigGuiWidgetFactory INTEGER = (value, valueSpec, valueManager, spec, name) -> {
            if (value instanceof ForgeConfigSpec.IntValue) {
                return new NumberWidget<Integer>(valueSpec, valueManager, spec, name, Integer::parseInt);
            }
            throw new IllegalArgumentException("The given config value for path: " + String.join((CharSequence)".", value.getPath()) + " is not an Integer value!");
        };
        public static ConfigGuiWidgetFactory LONG = (value, valueSpec, valueManager, spec, name) -> {
            if (value instanceof ForgeConfigSpec.LongValue) {
                return new NumberWidget<Long>(valueSpec, valueManager, spec, name, Long::parseLong);
            }
            throw new IllegalArgumentException("The given config value for path: " + String.join((CharSequence)".", value.getPath()) + " is not a Long value!");
        };
        public static ConfigGuiWidgetFactory DOUBLE = (value, valueSpec, valueManager, spec, name) -> {
            if (value instanceof ForgeConfigSpec.DoubleValue) {
                return new NumberWidget<Double>(valueSpec, valueManager, spec, name, Double::parseDouble);
            }
            throw new IllegalArgumentException("The given config value for path: " + String.join((CharSequence)".", value.getPath()) + " is not a Double value!");
        };
        private final Function<String, T> parser;

        public NumberWidget(ForgeConfigSpec.ValueSpec spec, ValueManager valueManager, SpecificationData specificationData, class_2561 name, Function<String, T> parser) {
            super(spec, valueManager, specificationData, name);
            this.parser = parser;
        }

        @Override
        protected void onInput(String input) {
            if (this.isValid(input)) {
                this.getValueManager().setter().accept(this.parser.apply(input));
            }
        }

        @Override
        public Object getValue() {
            try {
                return this.parser.apply(this.getEditBox().method_1882());
            }
            catch (NumberFormatException e) {
                return super.getValue();
            }
        }

        @Override
        protected boolean isValid(String value) {
            try {
                return this.isValid((Number)this.parser.apply(value));
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        private boolean isValid(T value) {
            return this.getSpec().test(value);
        }
    }

    public static class EditBoxBasedWidget
    extends ConfigGuiWidget {
        public static ConfigGuiWidgetFactory SIMPLE = (value, valueSpec, valueManager, spec, name) -> {
            try {
                return new EditBoxBasedWidget(valueSpec, valueManager, spec, name);
            }
            catch (ClassCastException ex) {
                throw new IllegalArgumentException("The given config value for path: " + String.join((CharSequence)".", value.getPath()) + " is not a Text value!", ex);
            }
        };
        private final class_342 editBox;

        protected EditBoxBasedWidget( @NotNull ForgeConfigSpec.ValueSpec spec, @NotNull ValueManager valueManager, @NotNull SpecificationData specificationData, @NotNull class_2561 name) {
            super(spec, valueManager);
            this.editBox = new ColoredEditBox(class_310.method_1551().field_1772, 0, 0, 68, 20, name){

                @Override
                public int getBorderColor() {
                    return this.isValid() ? super.getBorderColor() : 0x55FF0000;
                }

                @Override
                public int getBorderColorFocused() {
                    return this.isValid() ? super.getBorderColor() : -65536;
                }
            };
            this.editBox.method_1852(valueManager.getter().get().toString());
            this.editBox.method_1863(this::onInput);
            this.editBox.field_22763 = !specificationData.isSynced();
            this.editBox.method_1888(this.editBox.field_22763);
        }

        public class_342 getEditBox() {
            return this.editBox;
        }

        @Override
        public boolean isValid() {
            return this.isValid(this.editBox.method_1882());
        }

        @Override
        public void render(class_4587 poseStack, int top, int left, int maxWidth, int maxHeight, int mouseX, int mouseY, boolean isHovered, float partialTick) {
            this.editBox.method_25358(maxWidth - 4);
            ((AbstractWidgetAccessor)this.editBox).setHeight(maxHeight);
            this.editBox.field_22760 = left + 2;
            this.editBox.field_22761 = top;
            this.editBox.method_25394(poseStack, mouseX, mouseY, partialTick);
        }

        @Override
        public List<? extends class_6379> narratables() {
            return Collections.singletonList(this.editBox);
        }

        @NotNull
        public List<class_5481> method_31047() {
            return Collections.emptyList();
        }

        @NotNull
        public List<? extends class_364> method_25396() {
            return Collections.singletonList(this.editBox);
        }

        @Override
        public Object getValue() {
            return this.getEditBox().method_1882();
        }

        @Override
        protected void setValue(@NotNull Object value) {
            this.editBox.method_1852(value.toString());
        }

        protected boolean isValid(String value) {
            return this.getSpec().test(value);
        }

        protected void onInput(String input) {
            if (this.isValid(input)) {
                this.getValueManager().setter().accept(input);
            }
        }
    }

    public static class EnumWidget<T extends Enum<T>>
    extends ConfigGuiWidget {
        public static ConfigGuiWidgetFactory FACTORY = (value, valueSpec, valueManager, spec, name) -> {
            if (value instanceof ForgeConfigSpec.EnumValue) {
                ForgeConfigSpec.EnumValue enumConfigValue = (ForgeConfigSpec.EnumValue)value;
                return new EnumWidget(enumConfigValue, valueSpec, valueManager, spec, name);
            }
            throw new IllegalArgumentException("The given config value for path: " + String.join((CharSequence)".", value.getPath()) + " is not an enum value!");
        };
        private final class_5676<T> enumButton;

        public EnumWidget(ForgeConfigSpec.EnumValue<T> value, ForgeConfigSpec.ValueSpec spec, ValueManager valueManager, SpecificationData specificationData, class_2561 name) {
            super(spec, valueManager);
            this.enumButton = class_5676.method_32606(t -> class_2561.method_43470((String)t.name())).method_32620(List.of((Enum[])value.getEnumClass().getEnumConstants())).method_32616().method_32623(class_5676::method_32611).method_32619((Object)((Enum)valueManager.getter().get())).method_32617(0, 0, 68, 20, name, (button, newValue) -> valueManager.setter().accept(newValue));
            this.enumButton.field_22763 = !specificationData.isSynced();
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        protected void setValue(@NotNull Object value) {
            this.enumButton.method_32605((Object)((Enum)value));
        }

        @Override
        public Object getValue() {
            return this.enumButton.method_32603();
        }

        @Override
        public List<? extends class_6379> narratables() {
            return Collections.singletonList(this.enumButton);
        }

        @Override
        public void render(class_4587 poseStack, int top, int left, int maxWidth, int maxHeight, int mouseX, int mouseY, boolean isHovered, float partialTick) {
            this.enumButton.method_25358(maxWidth);
            ((AbstractWidgetAccessor)this.enumButton).setHeight(maxHeight);
            this.enumButton.field_22760 = left;
            this.enumButton.field_22761 = top;
            this.enumButton.method_25394(poseStack, mouseX, mouseY, partialTick);
        }

        @NotNull
        public List<class_5481> method_31047() {
            return this.enumButton.method_31047();
        }

        @NotNull
        public List<? extends class_364> method_25396() {
            return Collections.singletonList(this.enumButton);
        }
    }

    public static class BooleanWidget
    extends ConfigGuiWidget {
        public static ConfigGuiWidgetFactory FACTORY = (value, valueSpec, valueManager, spec, name) -> {
            if (value instanceof ForgeConfigSpec.BooleanValue) {
                return new BooleanWidget(valueSpec, valueManager, spec, name);
            }
            throw new IllegalArgumentException("The given config value for path: " + String.join((CharSequence)".", value.getPath()) + " is not a boolean value!");
        };
        private final class_5676<Boolean> checkbox;

        public BooleanWidget(ForgeConfigSpec.ValueSpec spec, ValueManager valueManager, SpecificationData specificationData, class_2561 name) {
            super(spec, valueManager);
            this.checkbox = class_5676.method_32613((boolean)((Boolean)valueManager.getter().get())).method_32616().method_32623(class_5676::method_32611).method_32617(0, 0, 68, 20, name, (button, value) -> valueManager.setter().accept(value));
            this.checkbox.field_22763 = !specificationData.isSynced();
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        protected void setValue(@NotNull Object value) {
            this.checkbox.method_32605((Object)((Boolean)value));
        }

        @Override
        public Object getValue() {
            return this.checkbox.method_32603();
        }

        @Override
        public List<? extends class_6379> narratables() {
            return Collections.singletonList(this.checkbox);
        }

        @Override
        public void render(class_4587 poseStack, int top, int left, int maxWidth, int maxHeight, int mouseX, int mouseY, boolean isHovered, float partialTick) {
            this.checkbox.method_25358(maxWidth);
            ((AbstractWidgetAccessor)this.checkbox).setHeight(maxHeight);
            this.checkbox.field_22760 = left;
            this.checkbox.field_22761 = top;
            this.checkbox.method_25394(poseStack, mouseX, mouseY, partialTick);
        }

        @NotNull
        public List<class_5481> method_31047() {
            return this.checkbox.method_31047();
        }

        @NotNull
        public List<? extends class_364> method_25396() {
            return Collections.singletonList(this.checkbox);
        }
    }
}

