/*
 * Decompiled with CFR 0.152.
 */
package fuzs.forgeconfigapiport.impl;

import com.mojang.brigadier.CommandDispatcher;
import fuzs.forgeconfigapiport.api.config.v2.ForgeConfigPaths;
import fuzs.forgeconfigapiport.impl.config.ForgeConfigApiPortConfig;
import fuzs.forgeconfigapiport.impl.network.config.ConfigSync;
import java.util.List;
import java.util.concurrent.Future;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.ArgumentTypeRegistry;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerLoginConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerLoginNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2314;
import net.minecraft.class_2319;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.server.command.ConfigCommand;
import net.minecraftforge.server.command.EnumArgument;
import net.minecraftforge.server.command.ModIdArgument;
import org.apache.commons.lang3.tuple.Pair;

public class ForgeConfigAPIPortFabric
implements ModInitializer {
    private static final class_2960 BEFORE_PHASE = new class_2960("forgeconfigapiport", "before");
    private static final class_2960 AFTER_PHASE = new class_2960("forgeconfigapiport", "after");

    public void onInitialize() {
        ForgeConfigAPIPortFabric.registerServerLoginNetworking();
        ForgeConfigAPIPortFabric.registerArgumentTypes();
        ForgeConfigAPIPortFabric.registerHandlers();
    }

    private static void registerServerLoginNetworking() {
        ServerLoginConnectionEvents.QUERY_START.register((handler2, server2, sender, synchronizer2) -> {
            List<Pair<String, class_2540>> pairs = ConfigSync.onSyncConfigs();
            for (Pair<String, class_2540> pair : pairs) {
                synchronizer2.waitFor((Future)server2.method_20493(() -> sender.sendPacket(ConfigSync.SYNC_CONFIGS_CHANNEL, (class_2540)pair.getValue())));
            }
            synchronizer2.waitFor((Future)server2.method_20493(() -> sender.sendPacket(ConfigSync.ESTABLISH_MODDED_CONNECTION_CHANNEL, PacketByteBufs.create())));
        });
        ServerLoginNetworking.registerGlobalReceiver((class_2960)ConfigSync.SYNC_CONFIGS_CHANNEL, (server1, handler1, understood1, buf1, synchronizer1, responseSender1) -> ConfigSync.onSyncConfigs(server1, handler1, understood1, buf1));
        ServerLoginNetworking.registerGlobalReceiver((class_2960)ConfigSync.ESTABLISH_MODDED_CONNECTION_CHANNEL, (server, handler, understood, buf, synchronizer, responseSender) -> ConfigSync.onEstablishModdedConnection(server, handler, understood, buf));
    }

    private static void registerArgumentTypes() {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT && !((Boolean)ForgeConfigApiPortConfig.INSTANCE.getValue("disableConfigCommand")).booleanValue()) {
            ArgumentTypeRegistry.registerArgumentType((class_2960)new class_2960("forgeconfigapiport", "enum"), EnumArgument.class, new EnumArgument.Info());
            ArgumentTypeRegistry.registerArgumentType((class_2960)new class_2960("forgeconfigapiport", "modid"), ModIdArgument.class, (class_2314)class_2319.method_41999(ModIdArgument::modIdArgument));
        }
    }

    private static void registerHandlers() {
        ServerLifecycleEvents.SERVER_STARTING.addPhaseOrdering(BEFORE_PHASE, Event.DEFAULT_PHASE);
        ServerLifecycleEvents.SERVER_STARTING.register(BEFORE_PHASE, server -> ConfigTracker.INSTANCE.loadConfigs(ModConfig.Type.SERVER, ForgeConfigPaths.INSTANCE.getServerConfigDirectory(server)));
        ServerLifecycleEvents.SERVER_STOPPED.addPhaseOrdering(Event.DEFAULT_PHASE, AFTER_PHASE);
        ServerLifecycleEvents.SERVER_STOPPED.register(AFTER_PHASE, server -> ConfigTracker.INSTANCE.unloadConfigs(ModConfig.Type.SERVER, ForgeConfigPaths.INSTANCE.getServerConfigDirectory(server)));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            if (environment != class_2170.class_5364.field_25420 && !((Boolean)ForgeConfigApiPortConfig.INSTANCE.getValue("disableConfigCommand")).booleanValue()) {
                ConfigCommand.register((CommandDispatcher<class_2168>)dispatcher);
            }
        });
    }
}

