/*
 * Decompiled with CFR 0.152.
 */
package fuzs.forgeconfigapiport.impl.integration.configured;

import com.mrcrayfish.configured.api.IConfigValue;
import fuzs.forgeconfigapiport.impl.util.ReflectionHelperV2;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ForgeValue<T>
implements IConfigValue<T> {
    public final ForgeConfigSpec.ConfigValue<T> configValue;
    public final ForgeConfigSpec.ValueSpec valueSpec;
    protected final T initialValue;
    protected T value;
    protected Pair<T, T> range;
    protected class_2561 validationHint;

    public ForgeValue(ForgeConfigSpec.ConfigValue<T> configValue, ForgeConfigSpec.ValueSpec valueSpec) {
        this.configValue = configValue;
        this.valueSpec = valueSpec;
        this.initialValue = configValue.get();
        this.set(configValue.get());
    }

    public T get() {
        return this.value;
    }

    public void set(T value) {
        this.value = value;
    }

    public boolean isDefault() {
        return Objects.equals(this.get(), this.valueSpec.getDefault());
    }

    public boolean isChanged() {
        return !Objects.equals(this.get(), this.initialValue);
    }

    public void restore() {
        this.set(this.getDefault());
    }

    public T getDefault() {
        return (T)this.valueSpec.getDefault();
    }

    public boolean isValid(T value) {
        return this.valueSpec.test(value);
    }

    @Nullable
    public class_2561 getComment() {
        String rawComment = this.valueSpec.getComment();
        String key = this.getTranslationKey() + ".tooltip";
        if (class_1074.method_4663((String)key)) {
            class_5250 comment = class_2561.method_43471((String)key);
            if (rawComment != null) {
                int rangeIndex = rawComment.indexOf("Range: ");
                int allowedValIndex = rawComment.indexOf("Allowed Values: ");
                if (rangeIndex >= 0 || allowedValIndex >= 0) {
                    comment.method_10852((class_2561)class_2561.method_43470((String)rawComment.substring(Math.max(rangeIndex, allowedValIndex) - 1)));
                }
            }
            return comment;
        }
        return rawComment != null ? class_2561.method_43470((String)rawComment) : null;
    }

    public String getTranslationKey() {
        return this.valueSpec.getTranslationKey();
    }

    @Nullable
    public class_2561 getValidationHint() {
        if (this.validationHint == null) {
            this.loadRange();
            if (this.range != null && this.range.getLeft() != null && this.range.getRight() != null) {
                this.validationHint = class_2561.method_43469((String)"configured.validator.range_hint", (Object[])new Object[]{this.range.getLeft().toString(), this.range.getRight().toString()});
            }
        }
        return this.validationHint;
    }

    public String getName() {
        return ForgeValue.lastValue(this.configValue.getPath(), "");
    }

    public void cleanCache() {
        this.configValue.clearCache();
    }

    public boolean requiresWorldRestart() {
        return this.valueSpec.needsWorldRestart();
    }

    public boolean requiresGameRestart() {
        return false;
    }

    public static <V> V lastValue(List<V> list, V defaultValue) {
        if (list.size() > 0) {
            return list.get(list.size() - 1);
        }
        return defaultValue;
    }

    public void loadRange() {
        if (this.range == null) {
            try {
                Optional range = ReflectionHelperV2.getValue(ForgeConfigSpec.ValueSpec.class, "range", this.valueSpec);
                if (range.isPresent()) {
                    Class<?> rangeClass = Class.forName("net.minecraftforge.common.ForgeConfigSpec$Range");
                    Object min = ReflectionHelperV2.getValue(rangeClass, "min", range.get()).get();
                    Object max = ReflectionHelperV2.getValue(rangeClass, "max", range.get()).get();
                    this.range = Pair.of(min, max);
                    return;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            this.range = Pair.of(null, null);
        }
    }
}

