/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.mojang.logging.LogUtils;
import fuzs.forgeconfigapiport.impl.core.CommonAbstractions;
import java.nio.file.Path;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraftforge.fml.config.ModConfig;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class ConfigTracker {
    private static final Logger LOGGER = LogUtils.getLogger();
    static final Marker CONFIG = MarkerFactory.getMarker((String)"CONFIG");
    public static final ConfigTracker INSTANCE = new ConfigTracker();
    private final ConcurrentHashMap<String, ModConfig> fileMap = new ConcurrentHashMap();
    private final EnumMap<ModConfig.Type, Set<ModConfig>> configSets = new EnumMap(ModConfig.Type.class);
    private final ConcurrentHashMap<String, Map<ModConfig.Type, ModConfig>> configsByMod = new ConcurrentHashMap();

    private ConfigTracker() {
        this.configSets.put(ModConfig.Type.CLIENT, Collections.synchronizedSet(new LinkedHashSet()));
        this.configSets.put(ModConfig.Type.COMMON, Collections.synchronizedSet(new LinkedHashSet()));
        this.configSets.put(ModConfig.Type.SERVER, Collections.synchronizedSet(new LinkedHashSet()));
    }

    void trackConfig(ModConfig config) {
        if (this.fileMap.containsKey(config.getFileName())) {
            LOGGER.error(CONFIG, "Detected config file conflict {} between {} and {}", new Object[]{config.getFileName(), this.fileMap.get(config.getFileName()).getModId(), config.getModId()});
            throw new RuntimeException("Config conflict detected!");
        }
        this.fileMap.put(config.getFileName(), config);
        this.configSets.get((Object)config.getType()).add(config);
        this.configsByMod.computeIfAbsent(config.getModId(), k -> new EnumMap(ModConfig.Type.class)).put(config.getType(), config);
        LOGGER.debug(CONFIG, "Config file {} for {} tracking", (Object)config.getFileName(), (Object)config.getModId());
        this.loadTrackedConfig(config);
    }

    private void loadTrackedConfig(ModConfig config) {
        if (config.getType() == ModConfig.Type.CLIENT) {
            this.openConfig(config, CommonAbstractions.INSTANCE.getClientConfigDirectory());
        } else if (config.getType() == ModConfig.Type.COMMON) {
            this.openConfig(config, CommonAbstractions.INSTANCE.getCommonConfigDirectory());
        }
    }

    public void loadConfigs(ModConfig.Type type, Path configBasePath) {
        LOGGER.debug(CONFIG, "Loading configs type {}", (Object)type);
        this.configSets.get((Object)type).forEach(config -> this.openConfig((ModConfig)config, configBasePath));
    }

    public void unloadConfigs(ModConfig.Type type, Path configBasePath) {
        LOGGER.debug(CONFIG, "Unloading configs type {}", (Object)type);
        this.configSets.get((Object)type).forEach(config -> this.closeConfig((ModConfig)config, configBasePath));
    }

    private void openConfig(ModConfig config, Path configBasePath) {
        LOGGER.trace(CONFIG, "Loading config file type {} at {} for {}", new Object[]{config.getType(), config.getFileName(), config.getModId()});
        CommentedFileConfig configData = config.getHandler().reader(configBasePath).apply(config);
        config.setConfigData((CommentedConfig)configData);
        CommonAbstractions.INSTANCE.fireConfigLoading(config.getModId(), config);
        config.save();
    }

    private void closeConfig(ModConfig config, Path configBasePath) {
        if (config.getConfigData() != null) {
            LOGGER.trace(CONFIG, "Closing config file type {} at {} for {}", new Object[]{config.getType(), config.getFileName(), config.getModId()});
            config.getHandler().unload(configBasePath, config);
            CommonAbstractions.INSTANCE.fireConfigUnloading(config.getModId(), config);
            config.save();
            config.setConfigData(null);
        }
    }

    public void loadDefaultServerConfigs() {
        this.configSets.get((Object)ModConfig.Type.SERVER).forEach(modConfig -> {
            CommentedConfig commentedConfig = CommentedConfig.inMemory();
            modConfig.getSpec().correct(commentedConfig);
            modConfig.setConfigData(commentedConfig);
            CommonAbstractions.INSTANCE.fireConfigLoading(modConfig.getModId(), (ModConfig)modConfig);
        });
    }

    public String getConfigFileName(String modId, ModConfig.Type type) {
        return Optional.ofNullable(this.configsByMod.getOrDefault(modId, Collections.emptyMap()).getOrDefault((Object)type, null)).map(ModConfig::getFullPath).map(Object::toString).orElse(null);
    }

    public Map<ModConfig.Type, Set<ModConfig>> configSets() {
        return this.configSets;
    }

    public ConcurrentHashMap<String, ModConfig> fileMap() {
        return this.fileMap;
    }
}

