/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.WritableLevelData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.ticks.LevelTickAccess;

public class EntityCollector
extends Level {
    private final Level wrappedLevel;
    private final List<Entity> collectedEntities = Lists.newArrayList();
    private BlockState blockState = Blocks.f_50016_.m_49966_();
    private static final Map<Level, EntityCollector> wrappedLevelsMap = Maps.newHashMap();
    private static final Map<ItemClassPair, Boolean> itemCreatesEntityResultCache = Maps.newHashMap();

    protected EntityCollector(Level wrapped) {
        super(new WritableLevelData(){

            public int m_6789_() {
                return 0;
            }

            public int m_6527_() {
                return 0;
            }

            public int m_6526_() {
                return 0;
            }

            public float m_6790_() {
                return 0.0f;
            }

            public long m_6793_() {
                return 0L;
            }

            public long m_6792_() {
                return 0L;
            }

            public boolean m_6534_() {
                return false;
            }

            public boolean m_6533_() {
                return false;
            }

            public void m_5565_(boolean isRaining) {
            }

            public boolean m_5466_() {
                return false;
            }

            public GameRules m_5470_() {
                return new GameRules();
            }

            public Difficulty m_5472_() {
                return Difficulty.EASY;
            }

            public boolean m_5474_() {
                return false;
            }

            public void m_6395_(int x) {
            }

            public void m_6397_(int p_78652_) {
            }

            public void m_6400_(int p_78653_) {
            }

            public void m_7113_(float p_78648_) {
            }
        }, null, wrapped.m_9598_(), wrapped.m_204156_(), wrapped.m_46658_(), false, wrapped.m_46659_(), 0L, 0);
        this.wrappedLevel = wrapped;
    }

    public static EntityCollector of(Level wrappedLevel) {
        if (!wrappedLevelsMap.containsKey(wrappedLevel)) {
            wrappedLevelsMap.put(wrappedLevel, new EntityCollector(wrappedLevel));
        }
        return wrappedLevelsMap.get(wrappedLevel);
    }

    public static List<Entity> collectEntitiesFromItem(ItemStack itemStack) {
        Minecraft minecraft = Minecraft.m_91087_();
        ArrayList entities = Lists.newArrayList();
        Item item = itemStack.m_41720_();
        ItemStack dummyStack = new ItemStack((ItemLike)item, itemStack.m_41613_());
        dummyStack.m_41751_(itemStack.m_41783_());
        try {
            Player dummyPlayer = new Player(minecraft.f_91074_.f_19853_, BlockPos.f_121853_, 0.0f, new GameProfile(null, "_dummy")){

                public boolean m_5833_() {
                    return false;
                }

                public boolean m_7500_() {
                    return false;
                }
            };
            dummyPlayer.m_21008_(InteractionHand.MAIN_HAND, dummyStack);
            EntityCollector levelWrapper = EntityCollector.of(dummyPlayer.f_19853_);
            if (item instanceof SpawnEggItem) {
                SpawnEggItem spawnEggItem = (SpawnEggItem)item;
                entities.add(spawnEggItem.m_43228_(new CompoundTag()).m_20615_((Level)levelWrapper));
            } else {
                dummyStack.m_41682_((Level)levelWrapper, dummyPlayer, InteractionHand.MAIN_HAND);
            }
            entities.addAll(levelWrapper.getCollectedEntities());
            if (entities.isEmpty()) {
                levelWrapper.setBlockState(Blocks.f_50156_.m_49966_());
                dummyStack.m_41661_(new UseOnContext((Level)levelWrapper, dummyPlayer, InteractionHand.MAIN_HAND, dummyPlayer.m_21120_(InteractionHand.MAIN_HAND), new BlockHitResult(Vec3.f_82478_, Direction.DOWN, BlockPos.f_121853_, false)));
                levelWrapper.setBlockState(Blocks.f_50016_.m_49966_());
                entities.addAll(levelWrapper.getCollectedEntities());
            }
            if (entities.isEmpty()) {
                levelWrapper.setBlockState(Blocks.f_50069_.m_49966_());
                dummyStack.m_41661_(new UseOnContext((Level)levelWrapper, dummyPlayer, InteractionHand.MAIN_HAND, dummyPlayer.m_21120_(InteractionHand.MAIN_HAND), new BlockHitResult(Vec3.f_82478_, Direction.NORTH, BlockPos.f_121853_, false)));
                levelWrapper.setBlockState(Blocks.f_50016_.m_49966_());
                entities.addAll(levelWrapper.getCollectedEntities());
                CompoundTag itemTag = dummyStack.m_41783_();
                if (itemTag != null && itemTag.m_128425_("EntityTag", 10)) {
                    CompoundTag entityTag = itemTag.m_128469_("EntityTag");
                    Optional loadedVariant = Painting.m_269030_((CompoundTag)entityTag);
                    if (loadedVariant.isPresent()) {
                        for (Entity entity : entities) {
                            if (!(entity instanceof Painting)) continue;
                            Painting paintingEntity = (Painting)entity;
                            paintingEntity.m_28464_((Holder)loadedVariant.get());
                        }
                    } else {
                        entities.clear();
                    }
                } else {
                    entities.clear();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return entities;
    }

    public static <T extends Entity> boolean itemCreatesEntity(ItemStack itemStack, Class<T> targetClass) {
        ItemClassPair key = new ItemClassPair(itemStack.m_41720_(), itemStack.m_41783_(), targetClass);
        boolean result = false;
        if (!itemCreatesEntityResultCache.containsKey(key)) {
            for (Entity entity : EntityCollector.collectEntitiesFromItem(itemStack)) {
                if (!targetClass.isInstance(entity)) continue;
                result = true;
                break;
            }
            itemCreatesEntityResultCache.put(key, result);
        }
        return itemCreatesEntityResultCache.get(key);
    }

    public List<Entity> getCollectedEntities() {
        ArrayList entities = Lists.newArrayList();
        entities.addAll(this.collectedEntities);
        this.collectedEntities.clear();
        return entities;
    }

    public void setBlockState(BlockState blockState) {
        this.blockState = blockState;
    }

    public BlockState m_8055_(BlockPos blockPos) {
        return this.blockState;
    }

    public int m_45517_(LightLayer lightLayer, BlockPos blockPos) {
        return 15;
    }

    public boolean m_45756_(Entity entity, AABB boundingBox) {
        return true;
    }

    public boolean m_7967_(Entity entity) {
        entity.m_146922_(180.0f);
        this.collectedEntities.add(entity);
        return false;
    }

    public LevelTickAccess<Block> m_183326_() {
        return this.wrappedLevel.m_183326_();
    }

    public LevelTickAccess<Fluid> m_183324_() {
        return this.wrappedLevel.m_183324_();
    }

    public ChunkSource m_7726_() {
        return this.wrappedLevel.m_7726_();
    }

    public void m_5898_(Player p_46771_, int p_46772_, BlockPos p_46773_, int p_46774_) {
    }

    public void m_214171_(GameEvent p_220404_, Vec3 p_220405_, GameEvent.Context p_220406_) {
    }

    public List<? extends Player> m_6907_() {
        return this.wrappedLevel.m_6907_();
    }

    public Holder<Biome> m_203675_(int p_204159_, int p_204160_, int p_204161_) {
        return this.wrappedLevel.m_203675_(p_204159_, p_204160_, p_204161_);
    }

    public RegistryAccess m_9598_() {
        return this.wrappedLevel.m_9598_();
    }

    public FeatureFlagSet m_246046_() {
        return this.wrappedLevel.m_246046_();
    }

    public float m_7717_(Direction p_45522_, boolean p_45523_) {
        return this.wrappedLevel.m_7717_(p_45522_, p_45523_);
    }

    public void m_7260_(BlockPos p_46612_, BlockState p_46613_, BlockState p_46614_, int p_46615_) {
    }

    public void m_262808_(Player p_262953_, double p_263004_, double p_263398_, double p_263376_, Holder<SoundEvent> p_263359_, SoundSource p_263020_, float p_263055_, float p_262914_, long p_262991_) {
    }

    public void m_213890_(Player p_220372_, Entity p_220373_, Holder<SoundEvent> p_263500_, SoundSource p_220375_, float p_220376_, float p_220377_, long p_220378_) {
    }

    public String m_46464_() {
        return this.wrappedLevel.m_46464_();
    }

    public Entity m_6815_(int p_46492_) {
        return null;
    }

    public MapItemSavedData m_7489_(String p_46650_) {
        return this.wrappedLevel.m_7489_(p_46650_);
    }

    public void m_142325_(String p_151533_, MapItemSavedData p_151534_) {
    }

    public int m_7354_() {
        return this.wrappedLevel.m_7354_();
    }

    public void m_6801_(int p_46506_, BlockPos p_46507_, int p_46508_) {
    }

    public Scoreboard m_6188_() {
        return this.wrappedLevel.m_6188_();
    }

    public RecipeManager m_7465_() {
        return this.wrappedLevel.m_7465_();
    }

    public LevelEntityGetter<Entity> m_142646_() {
        return new LevelEntityGetter<Entity>(){

            public Entity get(int p_156931_) {
                return null;
            }

            public Entity get(UUID p_156939_) {
                return null;
            }

            public Iterable<Entity> m_142273_() {
                return List.of();
            }

            public <U extends Entity> void m_142690_(EntityTypeTest<Entity, U> p_156935_, AbortableIterationConsumer<U> p_261602_) {
            }

            public void m_142232_(AABB p_156937_, Consumer<Entity> p_156938_) {
            }

            public <U extends Entity> void m_142137_(EntityTypeTest<Entity, U> p_156932_, AABB p_156933_, AbortableIterationConsumer<U> p_261542_) {
            }
        };
    }

    private record ItemClassPair(Item item, CompoundTag tag, Class<?> targetClass) {
    }
}

