/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.advancementplaques.config;

import com.electronwill.nightconfig.core.Config;
import fuzs.forgeconfigapiport.api.config.v2.ModConfigEvents;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_185;
import net.minecraft.class_189;
import net.minecraft.class_2960;
import net.minecraft.class_5251;
import net.minecraft.class_8779;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class AdvancementPlaquesConfig {
    public static final ForgeConfigSpec SPEC;
    public static final AdvancementPlaquesConfig INSTANCE;
    public final ForgeConfigSpec.BooleanValue onTop;
    public final ForgeConfigSpec.IntValue distance;
    public final ForgeConfigSpec.IntValue horizontalOffset;
    public final ForgeConfigSpec.BooleanValue hideWaila;
    public final ForgeConfigSpec.BooleanValue tasks;
    public final ForgeConfigSpec.BooleanValue goals;
    public final ForgeConfigSpec.BooleanValue challenges;
    public final ForgeConfigSpec.DoubleValue taskEffectFadeInTime;
    public final ForgeConfigSpec.DoubleValue taskEffectFadeOutTime;
    public final ForgeConfigSpec.DoubleValue taskDuration;
    public final ForgeConfigSpec.DoubleValue goalEffectFadeInTime;
    public final ForgeConfigSpec.DoubleValue goalEffectFadeOutTime;
    public final ForgeConfigSpec.DoubleValue goalDuration;
    public final ForgeConfigSpec.DoubleValue challengeEffectFadeInTime;
    public final ForgeConfigSpec.DoubleValue challengeEffectFadeOutTime;
    public final ForgeConfigSpec.DoubleValue challengeDuration;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> whitelist;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> blacklist;
    public final ForgeConfigSpec.DoubleValue taskVolume;
    public final ForgeConfigSpec.DoubleValue goalVolume;
    public final ForgeConfigSpec.DoubleValue challengeVolume;
    private final Supplier<ForgeConfigSpec.ConfigValue<?>> titleSupplier;
    private final Supplier<ForgeConfigSpec.ConfigValue<?>> nameSupplier;
    private class_5251 titleColor = null;
    private class_5251 nameColor = null;

    public AdvancementPlaquesConfig(ForgeConfigSpec.Builder build) {
        build.comment("Client Configuration").push("client").push("visual_options");
        this.onTop = build.comment(" If plaques should show on the top of the screen.").define("on_top", true);
        this.distance = build.comment(" The distance from the top or bottom of the screen, in pixels.").defineInRange("distance", 16, 8, 256);
        this.horizontalOffset = build.comment(" The horizontal offset from the center, in pixels.").defineInRange("horizontal_offset", 0, -256, 256);
        this.hideWaila = build.comment(" Hide waila/hwyla/jade popups while plaques are showing.").define("hide_waila", false);
        this.tasks = build.comment(" If plaques should show for task advancements (normal advancements).").define("tasks", true);
        this.goals = build.comment(" If plaques should show for goal advancements (medium-difficulty advancements).").define("goals", true);
        this.challenges = build.comment(" If plaques should show for challenge advancements (high-difficulty advancements).").define("challenges", true);
        ForgeConfigSpec.ConfigValue titleColorValue = build.comment(" Text color to use for plaque titles (like \"Advancement made!\"). Can be entered as an 8-digit hex color code #AARRGGBB for convenience. If Prism library is installed, any Prism color definition is supported.").define("title_color", (Object)"#FF332200", v -> AdvancementPlaquesConfig.validateColor(v));
        ForgeConfigSpec.ConfigValue nameColorValue = build.comment(" Text color to use for advancement names on plaques. Can be entered as an 8-digit hex color code #AARRGGBB for convenience. If Prism library is installed, any Prism color definition is supported.").define("name_color", (Object)"#FFFFFFFF", v -> AdvancementPlaquesConfig.validateColor(v));
        this.titleSupplier = () -> titleColorValue;
        this.nameSupplier = () -> nameColorValue;
        build.pop().push("duration_options");
        this.taskEffectFadeInTime = build.comment(" Duration of the shiny effect fade in for tasks.").defineInRange("task_effect_fadein", 0.5, 0.1, 3.0);
        this.taskEffectFadeOutTime = build.comment(" Duration of the shiny effect fade out for tasks.").defineInRange("task_effect_fadeout", 1.5, 0.1, 3.0);
        this.taskDuration = build.comment(" Duration of the plaques for tasks (minus the effect fade in/out durations).").defineInRange("task_duration", 7.0, 2.0, 10.0);
        this.goalEffectFadeInTime = build.comment(" Duration of the shiny effect fade in for goals.").defineInRange("goal_effect_fadein", 0.5, 0.1, 3.0);
        this.goalEffectFadeOutTime = build.comment(" Duration of the shiny effect fade out for goals.").defineInRange("goal_effect_fadeout", 1.5, 0.1, 3.0);
        this.goalDuration = build.comment(" Duration of the plaques for goals (minus the effect fade in/out durations).").defineInRange("goal_duration", 7.0, 2.0, 10.0);
        this.challengeEffectFadeInTime = build.comment(" Duration of the shiny effect fade in for challenges.").defineInRange("challenge_effect_fadein", 1.25, 0.1, 3.0);
        this.challengeEffectFadeOutTime = build.comment(" Duration of the shiny effect fade out for challenges.").defineInRange("challenge_effect_fadeout", 1.5, 0.1, 3.0);
        this.challengeDuration = build.comment(" Duration of the plaques for challenges (minus the effect fade in/out durations).").defineInRange("challenge_duration", 7.0, 2.0, 10.0);
        build.pop().push("functionality_options");
        this.blacklist = build.comment(" Blacklist of advancements to never show plaques for.  Takes precedence over whitelist if they conflict.\n Options:\n  Advancement ID (eg. \"minecraft:adventure/adventuring_time\")\n  Mod ID (Omit the colon, eg. \"minecraft\")\n  Advancement Category (End with a /, eg. \"minecraft:story/\")").defineListAllowEmpty(Arrays.asList("blacklist"), () -> new ArrayList(), e -> true);
        this.whitelist = build.comment(" Whitelist of advancements to show plaques for.  Leave empty to display for all.\n Same options available as blacklist.").defineListAllowEmpty(Arrays.asList("whitelist"), () -> new ArrayList(), e -> true);
        this.taskVolume = build.comment(" Volume of task sounds.  Set to 0 to mute.").defineInRange("task_volume", 1.0, 0.0, 1.0);
        this.goalVolume = build.comment(" Volume of goal sounds.  Set to 0 to mute.").defineInRange("goal_volume", 1.0, 0.0, 1.0);
        this.challengeVolume = build.comment(" Volume of challenge sounds.  Set to 0 to mute.").defineInRange("challenge_volume", 1.0, 0.0, 1.0);
        build.pop().pop();
        ModConfigEvents.reloading((String)"advancementplaques").register(AdvancementPlaquesConfig::onReload);
    }

    private static boolean advancementEntryMatches(class_8779 advancementHolder, String entry) {
        class_2960 advancementId = advancementHolder.comp_1919();
        if (advancementId.toString().equals(entry)) {
            return true;
        }
        if (!entry.contains(":") && advancementId.method_12836().toString().equals(entry)) {
            return true;
        }
        return entry.endsWith("/") && advancementId.toString().startsWith(entry);
    }

    public static boolean showPlaqueForAdvancement(class_8779 advancementHolder) {
        boolean advancementFiltered;
        for (String blacklistEntry : (List)AdvancementPlaquesConfig.INSTANCE.blacklist.get()) {
            if (!AdvancementPlaquesConfig.advancementEntryMatches(advancementHolder, blacklistEntry)) continue;
            return false;
        }
        class_185 displayInfo = advancementHolder.comp_1920().comp_1913().orElse(null);
        if (displayInfo == null) {
            return false;
        }
        boolean bl = advancementFiltered = !(displayInfo.method_815() == class_189.field_1254 && (Boolean)AdvancementPlaquesConfig.INSTANCE.tasks.get() != false || displayInfo.method_815() == class_189.field_1249 && (Boolean)AdvancementPlaquesConfig.INSTANCE.goals.get() != false || displayInfo.method_815() == class_189.field_1250 && (Boolean)AdvancementPlaquesConfig.INSTANCE.challenges.get() != false);
        if (advancementFiltered) {
            for (String whitelistEntry : (List)AdvancementPlaquesConfig.INSTANCE.whitelist.get()) {
                if (!AdvancementPlaquesConfig.advancementEntryMatches(advancementHolder, whitelistEntry)) continue;
                return true;
            }
        }
        return !advancementFiltered;
    }

    public class_5251 getTitleColor(float alpha) {
        if (this.titleColor == null) {
            AdvancementPlaquesConfig.resolveColors();
        }
        return this.applyAlpha(this.titleColor, alpha);
    }

    public class_5251 getNameColor(float alpha) {
        if (this.nameColor == null) {
            AdvancementPlaquesConfig.resolveColors();
        }
        return this.applyAlpha(this.nameColor, alpha);
    }

    private class_5251 applyAlpha(class_5251 color, float alpha) {
        int tempColor = color.method_27716();
        int tempAlpha = (int)((float)(tempColor >> 24 & 0xFF) * alpha);
        return class_5251.method_27717((int)(tempColor & 0xFFFFFF | tempAlpha << 24));
    }

    private static void resolveColors() {
        AdvancementPlaquesConfig.INSTANCE.titleColor = AdvancementPlaquesConfig.getColor(AdvancementPlaquesConfig.INSTANCE.titleSupplier.get().get(), class_5251.method_27717((int)-13426176));
        AdvancementPlaquesConfig.INSTANCE.nameColor = AdvancementPlaquesConfig.getColor(AdvancementPlaquesConfig.INSTANCE.nameSupplier.get().get(), class_5251.method_27717((int)-1));
    }

    private static boolean validateColor(Object value) {
        return AdvancementPlaquesConfig.getColor(value, null) != null;
    }

    private static class_5251 getColor(Object value, class_5251 defaultColor) {
        if (FabricLoader.getInstance().isModLoaded("prism")) {
            try {
                return (class_5251)Class.forName("com.anthonyhilyard.advancementplaques.compat.PrismHandler").getMethod("getColor", Object.class).invoke(null, value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (value instanceof String) {
            Object string = (String)value;
            class_5251 parsedColor = class_5251.method_27719((String)string);
            if (parsedColor == null) {
                string = "#" + ((String)string).replace("0x", "").replace("#", "");
                parsedColor = class_5251.method_27719((String)string);
            }
            if (parsedColor != null) {
                return parsedColor;
            }
        } else if (value instanceof Number) {
            Number number = (Number)value;
            return class_5251.method_27717((int)number.intValue());
        }
        return defaultColor;
    }

    public static void onReload(ModConfig config) {
        if (config.getModId().equals("advancementplaques")) {
            AdvancementPlaquesConfig.resolveColors();
        }
    }

    static {
        Config.setInsertionOrderPreserved((boolean)true);
        Pair specPair = new ForgeConfigSpec.Builder().configure(AdvancementPlaquesConfig::new);
        SPEC = (ForgeConfigSpec)specPair.getRight();
        INSTANCE = (AdvancementPlaquesConfig)specPair.getLeft();
    }
}

