/*
 * Decompiled with CFR 0.152.
 */
package fuzs.forgeconfigapiport.impl;

import fuzs.forgeconfigapiport.api.config.v3.ForgeConfigRegistry;
import fuzs.forgeconfigapiport.impl.handler.ServerLifecycleHandler;
import fuzs.forgeconfigapiport.impl.network.config.ConfigSync;
import java.util.List;
import java.util.concurrent.Future;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerLoginConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerLoginNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ForgeConfigAPIPortFabric
implements ModInitializer {
    public void onInitialize() {
        ForgeConfigAPIPortFabric.registerMessages();
        ForgeConfigAPIPortFabric.registerHandlers();
        ForgeConfigRegistry.INSTANCE.register("forgeconfigapiport", ModConfig.Type.SERVER, new ModConfigSpec.Builder().comment("Hello world").define("dummy_optoin", true).next().build());
    }

    private static void registerMessages() {
        ServerLoginConnectionEvents.QUERY_START.register((handler2, server2, sender, synchronizer2) -> {
            List<Pair<String, class_2540>> pairs = ConfigSync.writeSyncedConfigs();
            for (Pair<String, class_2540> pair : pairs) {
                synchronizer2.waitFor((Future)server2.method_20493(() -> sender.sendPacket(ConfigSync.SYNC_CONFIGS_CHANNEL, (class_2540)pair.getValue())));
            }
            synchronizer2.waitFor((Future)server2.method_20493(() -> sender.sendPacket(ConfigSync.ESTABLISH_MODDED_CONNECTION_CHANNEL, PacketByteBufs.create())));
        });
        ServerLoginNetworking.registerGlobalReceiver((class_2960)ConfigSync.SYNC_CONFIGS_CHANNEL, (server1, handler1, understood1, buf1, synchronizer1, responseSender1) -> ConfigSync.onSyncConfigs(server1, handler1, understood1, buf1));
        ServerLoginNetworking.registerGlobalReceiver((class_2960)ConfigSync.ESTABLISH_MODDED_CONNECTION_CHANNEL, (server, handler, understood, buf, synchronizer, responseSender) -> ConfigSync.onEstablishModdedConnection(server, handler, understood, buf));
    }

    private static void registerHandlers() {
        ServerLifecycleEvents.SERVER_STARTING.addPhaseOrdering(ServerLifecycleHandler.BEFORE_PHASE, Event.DEFAULT_PHASE);
        ServerLifecycleEvents.SERVER_STARTING.register(ServerLifecycleHandler.BEFORE_PHASE, ServerLifecycleHandler::onServerStarting);
        ServerLifecycleEvents.SERVER_STOPPED.addPhaseOrdering(Event.DEFAULT_PHASE, ServerLifecycleHandler.AFTER_PHASE);
        ServerLifecycleEvents.SERVER_STOPPED.register(ServerLifecycleHandler.AFTER_PHASE, ServerLifecycleHandler::onServerStopped);
    }
}

